/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.mft.gmf.ui.figures;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.statushandlers.StatusManager;

public class GradiatedColorRegistry {
    public static Integer COLOR_REPORT_THRESHOLD = 1000;
    private static boolean thresholdExceeded;
    public static GradiatedColorRegistry INSTANCE;
    private final Map<RGB, Color> colorCache = new HashMap<RGB, Color>();

    static {
        INSTANCE = new GradiatedColorRegistry();
    }

    private GradiatedColorRegistry() {
    }

    public final Color getColor(RGB rgb) {
        Color color = this.colorCache.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb.red, rgb.green, rgb.blue);
            this.colorCache.put(rgb, color);
            if (this.colorCache.size() > COLOR_REPORT_THRESHOLD && !thresholdExceeded) {
                thresholdExceeded = true;
                Status status = new Status(2, "org.eclipse.mylyn.gmf.ui", "Color cache limit of " + COLOR_REPORT_THRESHOLD + " exceeded. Please report to Mylyn Context project bugzilla. (This message will appear only once.)");
                StatusManager.getManager().handle((IStatus)status, 1);
            }
        }
        return color;
    }

    public Color getColor(Color color1, Color color2, float distance) {
        RGB rgb1 = new RGB(color1.getRed(), color1.getGreen(), color1.getBlue());
        float[] hsb1 = rgb1.getHSB();
        RGB rgb2 = new RGB(color2.getRed(), color2.getGreen(), color2.getBlue());
        float[] hsb2 = rgb2.getHSB();
        float[] hsb = new float[3];
        int i = 0;
        while (i < hsb.length) {
            hsb[i] = hsb1[i] + (hsb2[i] - hsb1[i]) * distance;
            ++i;
        }
        return this.getColor(new RGB(hsb[0], hsb[1], hsb[2]));
    }
}

