/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.widgets;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.tools.databinding.MultipleObservableValue;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.views.properties.Activator;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.contexts.Section;
import org.eclipse.papyrus.views.properties.contexts.View;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;
import org.eclipse.papyrus.views.properties.runtime.DefaultDisplayEngine;
import org.eclipse.papyrus.views.properties.runtime.DisplayEngine;
import org.eclipse.papyrus.views.properties.widgets.AbstractPropertyEditor;
import org.eclipse.papyrus.views.properties.widgets.layout.PropertiesLayout;
import org.eclipse.papyrus.views.properties.xwt.XWTSection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewEditor
extends AbstractPropertyEditor {
    private String viewPath;
    private Composite self;
    private Collection<XWTSection> sections;

    public ViewEditor(Composite parent, int style) {
        this.self = new Composite(parent, 0);
        PropertiesLayout layout = new PropertiesLayout(1, true);
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        this.self.setLayout((Layout)layout);
    }

    @Override
    public void checkInput() {
        if (this.propertyPath != null && this.input != null && this.viewPath != null) {
            this.display();
        }
    }

    public void setNumColumns(int numColumns) {
        ((PropertiesLayout)this.self.getLayout()).numColumns = numColumns;
    }

    public int getNumColumns() {
        return ((PropertiesLayout)this.self.getLayout()).numColumns;
    }

    public void setView(String viewPath) {
        this.viewPath = viewPath;
        this.checkInput();
    }

    public String getView() {
        return this.viewPath;
    }

    private View resolveView() {
        String contextName = this.viewPath.substring(0, this.viewPath.indexOf(":"));
        String viewName = this.viewPath.substring(this.viewPath.indexOf(":") + 1);
        Context context = ConfigurationManager.instance.getContext(contextName);
        for (View view : context.getViews()) {
            if (!view.getName().equals(viewName)) continue;
            return view;
        }
        return null;
    }

    private void display() {
        View view = this.resolveView();
        if (view == null) {
            Activator.log.warn("Unabled to resolve view : " + this.viewPath);
            return;
        }
        IObservable observable = this.getInputObservable();
        if (observable == null) {
            return;
        }
        DefaultDisplayEngine display = new DefaultDisplayEngine(true);
        this.sections = new LinkedList<XWTSection>();
        if (observable instanceof IObservableValue) {
            IObservableValue observableValue = (IObservableValue)observable;
            if (observableValue instanceof MultipleObservableValue) {
                MultipleObservableValue multipleObservable = (MultipleObservableValue)observableValue;
                this.display((DisplayEngine)display, multipleObservable.getObservedValues(), view);
            } else {
                Object value = observableValue.getValue();
                this.display((DisplayEngine)display, value, view);
            }
        } else if (observable instanceof IObservableList) {
            IObservableList observableList = (IObservableList)observable;
            for (Object value : observableList) {
                this.display((DisplayEngine)display, value, view);
            }
        }
        this.updateControls();
    }

    protected void display(DisplayEngine display, Object data, View view) {
        this.display(display, Collections.singletonList(data), view);
    }

    protected void display(DisplayEngine display, List<Object> selectedElements, View view) {
        for (Section section : view.getSections()) {
            XWTSection xwtSection = new XWTSection(section, view, display);
            this.sections.add(xwtSection);
            StructuredSelection selection = new StructuredSelection(selectedElements);
            xwtSection.createControls(new Composite(this.self, 0), null);
            xwtSection.setInput(null, (ISelection)selection);
            xwtSection.refresh();
        }
    }

    protected void updateControls() {
        Control[] controlArray = this.self.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control container = controlArray[n2];
            if (container instanceof Composite) {
                Control[] controlArray2 = ((Composite)container).getChildren();
                int n3 = controlArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Control control = controlArray2[n4];
                    if (control instanceof AbstractEditor) {
                        AbstractEditor editor = (AbstractEditor)control;
                        editor.setReadOnly(this.getReadOnly() || editor.isReadOnly());
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        this.self.setEnabled(!this.getReadOnly());
    }

    @Override
    protected IObservable getInputObservable() {
        return this.input.getObservable(this.propertyPath);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.updateControls();
    }

    @Override
    protected void doBinding() {
    }

    @Override
    public Control getControl() {
        return this.self;
    }
}

