/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IBreakpointsExtension;
import org.eclipse.cdt.dsf.debug.service.command.IEventListener;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.service.GDBBreakpoints_7_0;
import org.eclipse.cdt.dsf.gdb.service.GDBBreakpoints_7_2;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointDMData;
import org.eclipse.cdt.dsf.mi.service.MIBreakpoints;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointsSynchronizer;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakpoint;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MINotifyAsyncOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class GDBBreakpoints_7_4
extends GDBBreakpoints_7_2
implements IEventListener {
    private static final String BREAKPOINT_PREFIX = "breakpoint-";
    private static final String BREAKPOINT_CREATED = "breakpoint-created";
    private static final String BREAKPOINT_MODIFIED = "breakpoint-modified";
    private static final String BREAKPOINT_DELETED = "breakpoint-deleted";
    private IMICommandControl fConnection;

    public GDBBreakpoints_7_4(DsfSession session) {
        super(session);
    }

    @Override
    public void initialize(final RequestMonitor rm) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(rm){

            protected void handleSuccess() {
                GDBBreakpoints_7_4.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        this.fConnection = (IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class);
        if (this.fConnection == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", "Service is not available"));
            rm.done();
            return;
        }
        this.fConnection.addEventListener(this);
        this.register(new String[]{IBreakpoints.class.getName(), IBreakpointsExtension.class.getName(), MIBreakpoints.class.getName(), GDBBreakpoints_7_0.class.getName(), GDBBreakpoints_7_2.class.getName(), GDBBreakpoints_7_4.class.getName()}, new Hashtable());
        rm.done();
    }

    @Override
    public void shutdown(RequestMonitor requestMonitor) {
        IMICommandControl control = this.getCommandControl();
        if (control != null) {
            control.removeEventListener(this);
        }
        this.unregister();
        super.shutdown(requestMonitor);
    }

    public void eventReceived(Object output) {
        MIBreakpointsSynchronizer bs;
        if (output instanceof MIOutput && (bs = (MIBreakpointsSynchronizer)this.getServicesTracker().getService(MIBreakpointsSynchronizer.class)) != null) {
            MIOOBRecord[] records;
            MIOOBRecord[] mIOOBRecordArray = records = ((MIOutput)output).getMIOOBRecords();
            int n = records.length;
            int n2 = 0;
            while (n2 < n) {
                MIOOBRecord r = mIOOBRecordArray[n2];
                if (r instanceof MINotifyAsyncOutput) {
                    MIBreakpoint bpt;
                    MINotifyAsyncOutput notifyOutput = (MINotifyAsyncOutput)r;
                    String asyncClass = notifyOutput.getAsyncClass();
                    if (BREAKPOINT_CREATED.equals(asyncClass)) {
                        bpt = this.getMIBreakpointFromOutput(notifyOutput);
                        if (bpt != null) {
                            bs.targetBreakpointCreated(bpt);
                        }
                    } else if (BREAKPOINT_DELETED.equals(asyncClass)) {
                        int id = this.getMIBreakpointIdFromOutput(notifyOutput);
                        if (id != 0) {
                            bs.targetBreakpointDeleted(id);
                        }
                    } else if (BREAKPOINT_MODIFIED.equals(asyncClass) && (bpt = this.getMIBreakpointFromOutput(notifyOutput)) != null) {
                        bs.targetBreakpointModified(bpt);
                    }
                }
                ++n2;
            }
        }
    }

    private IMICommandControl getCommandControl() {
        return this.fConnection;
    }

    private MIBreakpoint getMIBreakpointFromOutput(MINotifyAsyncOutput notifyOutput) {
        MIBreakpoint bpt = null;
        MIResult[] results = notifyOutput.getMIResults();
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue val = results[i].getMIValue();
            if (var.equals("bkpt") && val instanceof MITuple) {
                bpt = new MIBreakpoint((MITuple)val);
            }
            ++i;
        }
        return bpt;
    }

    private int getMIBreakpointIdFromOutput(MINotifyAsyncOutput notifyOutput) {
        MIResult[] results = notifyOutput.getMIResults();
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue val = results[i].getMIValue();
            if (var.equals("id") && val instanceof MIConst) {
                try {
                    return Integer.parseInt(((MIConst)val).getCString().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    GdbPlugin.log((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", "Invalid breakpoint id"));
                }
            }
            ++i;
        }
        return 0;
    }

    @Override
    protected void addBreakpoint(final IBreakpoints.IBreakpointsTargetDMContext context, final Map<String, Object> attributes, final DataRequestMonitor<IBreakpoints.IBreakpointDMContext> finalRm) {
        final MIBreakpointsSynchronizer bs = (MIBreakpointsSynchronizer)this.getServicesTracker().getService(MIBreakpointsSynchronizer.class);
        if (bs != null) {
            bs.getTargetBreakpoint(context, attributes, new DataRequestMonitor<MIBreakpoint>((Executor)this.getExecutor(), finalRm){

                @ConfinedToDsfExecutor(value="fExecutor")
                protected void handleSuccess() {
                    MIBreakpoint miBpt = (MIBreakpoint)this.getData();
                    if (miBpt != null) {
                        bs.removeCreatedTargetBreakpoint(context, miBpt);
                        MIBreakpointDMData newBreakpoint = new MIBreakpointDMData(miBpt);
                        GDBBreakpoints_7_4.this.getBreakpointMap(context).put(newBreakpoint.getNumber(), newBreakpoint);
                        MIBreakpoints.MIBreakpointDMContext dmc = new MIBreakpoints.MIBreakpointDMContext(GDBBreakpoints_7_4.this, new IDMContext[]{context}, newBreakpoint.getNumber());
                        finalRm.setData((Object)dmc);
                        GDBBreakpoints_7_4.this.getSession().dispatchEvent((Object)new MIBreakpoints.BreakpointAddedEvent(dmc), GDBBreakpoints_7_4.this.getProperties());
                        finalRm.done();
                    } else {
                        GDBBreakpoints_7_4.access$2(GDBBreakpoints_7_4.this, context, attributes, finalRm);
                    }
                }
            });
        } else {
            super.addBreakpoint(context, attributes, finalRm);
        }
    }

    @Override
    protected void addTracepoint(final IBreakpoints.IBreakpointsTargetDMContext context, final Map<String, Object> attributes, final DataRequestMonitor<IBreakpoints.IBreakpointDMContext> drm) {
        final MIBreakpointsSynchronizer bs = (MIBreakpointsSynchronizer)this.getServicesTracker().getService(MIBreakpointsSynchronizer.class);
        if (bs != null) {
            bs.getTargetBreakpoint(context, attributes, new DataRequestMonitor<MIBreakpoint>((Executor)this.getExecutor(), drm){

                @ConfinedToDsfExecutor(value="fExecutor")
                protected void handleSuccess() {
                    MIBreakpoint miBpt = (MIBreakpoint)this.getData();
                    if (miBpt != null) {
                        bs.removeCreatedTargetBreakpoint(context, miBpt);
                        MIBreakpointDMData newBreakpoint = new MIBreakpointDMData(miBpt);
                        GDBBreakpoints_7_4.this.getBreakpointMap(context).put(newBreakpoint.getNumber(), newBreakpoint);
                        MIBreakpoints.MIBreakpointDMContext dmc = new MIBreakpoints.MIBreakpointDMContext(GDBBreakpoints_7_4.this, new IDMContext[]{context}, newBreakpoint.getNumber());
                        drm.setData((Object)dmc);
                        GDBBreakpoints_7_4.this.getSession().dispatchEvent((Object)new MIBreakpoints.BreakpointAddedEvent(dmc), GDBBreakpoints_7_4.this.getProperties());
                        drm.done();
                    } else {
                        GDBBreakpoints_7_4.access$3(GDBBreakpoints_7_4.this, context, attributes, drm);
                    }
                }
            });
        } else {
            super.addTracepoint(context, attributes, drm);
        }
    }

    @Override
    protected void addWatchpoint(final IBreakpoints.IBreakpointsTargetDMContext context, final Map<String, Object> attributes, final DataRequestMonitor<IBreakpoints.IBreakpointDMContext> drm) {
        final MIBreakpointsSynchronizer bs = (MIBreakpointsSynchronizer)this.getServicesTracker().getService(MIBreakpointsSynchronizer.class);
        if (bs != null) {
            bs.getTargetBreakpoint(context, attributes, new DataRequestMonitor<MIBreakpoint>((Executor)this.getExecutor(), drm){

                @ConfinedToDsfExecutor(value="fExecutor")
                protected void handleSuccess() {
                    MIBreakpoint miBpt = (MIBreakpoint)this.getData();
                    if (miBpt != null) {
                        bs.removeCreatedTargetBreakpoint(context, miBpt);
                        MIBreakpointDMData newBreakpoint = new MIBreakpointDMData(miBpt);
                        GDBBreakpoints_7_4.this.getBreakpointMap(context).put(newBreakpoint.getNumber(), newBreakpoint);
                        MIBreakpoints.MIBreakpointDMContext dmc = new MIBreakpoints.MIBreakpointDMContext(GDBBreakpoints_7_4.this, new IDMContext[]{context}, newBreakpoint.getNumber());
                        drm.setData((Object)dmc);
                        GDBBreakpoints_7_4.this.getSession().dispatchEvent((Object)new MIBreakpoints.BreakpointAddedEvent(dmc), GDBBreakpoints_7_4.this.getProperties());
                        drm.done();
                    } else {
                        GDBBreakpoints_7_4.access$4(GDBBreakpoints_7_4.this, context, attributes, drm);
                    }
                }
            });
        } else {
            super.addWatchpoint(context, attributes, drm);
        }
    }

    @Override
    protected void deleteBreakpointFromTarget(IBreakpoints.IBreakpointsTargetDMContext context, int reference, RequestMonitor finalRm) {
        MIBreakpointsSynchronizer bs = (MIBreakpointsSynchronizer)this.getServicesTracker().getService(MIBreakpointsSynchronizer.class);
        if (bs != null && bs.isTargetBreakpointDeleted(context, reference, true)) {
            finalRm.done();
            return;
        }
        super.deleteBreakpointFromTarget(context, reference, finalRm);
    }

    @Override
    public String adjustDebuggerPath(String originalPath) {
        return originalPath;
    }

    static /* synthetic */ void access$2(GDBBreakpoints_7_4 gDBBreakpoints_7_4, IBreakpoints.IBreakpointsTargetDMContext iBreakpointsTargetDMContext, Map map, DataRequestMonitor dataRequestMonitor) {
        super.addBreakpoint(iBreakpointsTargetDMContext, map, (DataRequestMonitor<IBreakpoints.IBreakpointDMContext>)dataRequestMonitor);
    }

    static /* synthetic */ void access$3(GDBBreakpoints_7_4 gDBBreakpoints_7_4, IBreakpoints.IBreakpointsTargetDMContext iBreakpointsTargetDMContext, Map map, DataRequestMonitor dataRequestMonitor) {
        super.addTracepoint(iBreakpointsTargetDMContext, map, (DataRequestMonitor<IBreakpoints.IBreakpointDMContext>)dataRequestMonitor);
    }

    static /* synthetic */ void access$4(GDBBreakpoints_7_4 gDBBreakpoints_7_4, IBreakpoints.IBreakpointsTargetDMContext iBreakpointsTargetDMContext, Map map, DataRequestMonitor dataRequestMonitor) {
        super.addWatchpoint(iBreakpointsTargetDMContext, map, (DataRequestMonitor<IBreakpoints.IBreakpointDMContext>)dataRequestMonitor);
    }
}

