/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.browser.custom.TypeView;
import org.eclipse.emf.facet.infra.browser.custom.core.CustomizationsCatalog;
import org.eclipse.emf.facet.infra.browser.uicore.CustomizationManager;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.FacetSet;
import org.eclipse.emf.facet.infra.facet.core.FacetSetCatalog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.papyrus.infra.core.log.LogHelper;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.papyrus.infra.emf";
    private static Activator plugin;
    public static LogHelper log;
    private CustomizationManager fCustomizationManager;
    public static final String CUSTOMIZATION_MANAGER_SECTION = "org.eclipse.papyrus.infra.emf.customizationManager";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        log = new LogHelper((Plugin)this);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public CustomizationManager getCustomizationManager() {
        if (this.fCustomizationManager == null) {
            this.fCustomizationManager = new CustomizationManager();
            this.init(this.fCustomizationManager);
        }
        return this.fCustomizationManager;
    }

    public void saveCustomizationManagerState() {
        IDialogSettings dialogSettings = this.getBrowserCustomizationDialogSettings();
        List appliedCustomizations = this.getCustomizationManager().getRegisteredCustomizations();
        for (MetamodelView customization : CustomizationsCatalog.getInstance().getRegistryCustomizations()) {
            boolean isApplied = appliedCustomizations.contains(customization);
            String settingKey = this.getSettingKey(customization);
            dialogSettings.put(settingKey, isApplied);
        }
    }

    private String getSettingKey(MetamodelView customization) {
        return customization.getLocation();
    }

    protected IDialogSettings getBrowserCustomizationDialogSettings() {
        String sectionId = CUSTOMIZATION_MANAGER_SECTION;
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(sectionId);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(sectionId);
        }
        return settings;
    }

    private void init(CustomizationManager customizationManager) {
        customizationManager.setShowDerivedLinks(true);
        customizationManager.setDecorateExternalResources(false);
        IDialogSettings settings = this.getBrowserCustomizationDialogSettings();
        try {
            List registryDefaultCustomizations = CustomizationsCatalog.getInstance().getRegistryDefaultCustomizations();
            List registryAllCustomizations = CustomizationsCatalog.getInstance().getRegistryCustomizations();
            LinkedList<MetamodelView> appliedCustomizations = new LinkedList<MetamodelView>();
            for (MetamodelView customization : registryAllCustomizations) {
                String settingKey = this.getSettingKey(customization);
                boolean isActive = false;
                isActive = settings.get(settingKey) == null ? registryDefaultCustomizations.contains(customization) : settings.getBoolean(settingKey);
                if (!isActive) continue;
                customizationManager.registerCustomization(customization);
                appliedCustomizations.add(customization);
            }
            customizationManager.loadCustomizations();
            this.loadFacetsForCustomizations(appliedCustomizations, customizationManager);
        }
        catch (Throwable e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, "Error initializing customizations", e));
        }
    }

    public void restoreDefaultCustomizationManager() {
        CustomizationManager manager = this.getCustomizationManager();
        DialogSettings settings = (DialogSettings)this.getDialogSettings();
        settings.removeSection(CUSTOMIZATION_MANAGER_SECTION);
        List registryDefaultCustomizations = CustomizationsCatalog.getInstance().getRegistryDefaultCustomizations();
        manager.clearCustomizations();
        for (MetamodelView customization : registryDefaultCustomizations) {
            manager.registerCustomization(customization);
        }
        manager.loadCustomizations();
    }

    protected void loadFacetsForCustomizations(List<MetamodelView> customizations, CustomizationManager customizationManager) {
        HashSet<Facet> referencedFacets = new HashSet<Facet>();
        Collection facetSets = FacetSetCatalog.getSingleton().getAllFacetSets();
        for (MetamodelView customization : customizations) {
            String metamodelURI = customization.getMetamodelURI();
            FacetSet customizedFacetSet = null;
            if (metamodelURI != null) {
                for (FacetSet facetSet : facetSets) {
                    if (!metamodelURI.equals(facetSet.getNsURI())) continue;
                    customizedFacetSet = facetSet;
                    break;
                }
            }
            if (customizedFacetSet == null) continue;
            EList types = customization.getTypes();
            for (TypeView typeView : types) {
                String metaclassName = typeView.getMetaclassName();
                Facet facet = this.findFacetWithFullyQualifiedName(metaclassName, customizedFacetSet);
                if (facet != null) {
                    referencedFacets.add(facet);
                    continue;
                }
                log.warn(String.format("Missing required facet \"%s\" in FacetSet \"%s\" for customization \"%s\"", metaclassName, customizedFacetSet.getName(), customization.getName()));
            }
            for (Facet referencedFacet : referencedFacets) {
                customizationManager.loadFacet(referencedFacet);
            }
        }
    }

    private Facet findFacetWithFullyQualifiedName(String metaclassName, FacetSet customizedFacetSet) {
        EList facets = customizedFacetSet.getFacets();
        for (Facet facet : facets) {
            String facetName = Activator.getMetaclassQualifiedName((EClassifier)facet);
            if (!metaclassName.equals(facetName)) continue;
            return facet;
        }
        return null;
    }

    public static String getMetaclassQualifiedName(EClassifier eClass) {
        ArrayList<String> qualifiedNameParts = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        EPackage ePackage = eClass.getEPackage();
        while (ePackage != null) {
            qualifiedNameParts.add(ePackage.getName());
            ePackage = ePackage.getESuperPackage();
        }
        int i = qualifiedNameParts.size() - 1;
        while (i >= 0) {
            builder.append(String.valueOf((String)qualifiedNameParts.get(i)) + ".");
            --i;
        }
        builder.append(eClass.getName());
        return builder.toString();
    }
}

