/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.table.properties.provider;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.edit.internal.context.TypeContext;
import org.eclipse.papyrus.infra.table.properties.Activator;
import org.eclipse.papyrus.infra.table.properties.messages.Messages;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.editors.StringEditor;
import org.eclipse.papyrus.infra.widgets.providers.AbstractStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IGraphicalContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.PatternViewerFilter;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementTypeContentProvider
extends AbstractStaticContentProvider
implements ITreeContentProvider,
IGraphicalContentProvider {
    private Set<String> values = null;
    protected ViewerFilter patternFilter;
    private String currentFilterPattern = "";
    private StructuredViewer viewer;

    public String[] getElements() {
        if (this.values == null) {
            this.values = this.getValues();
        }
        return this.values.toArray(new String[this.values.size()]);
    }

    private Set<String> getValues() {
        Set<String> allValues = this.getAllPossiblesValues();
        return allValues;
    }

    private Set<String> getAllPossiblesValues() {
        IClientContext clientContext = null;
        try {
            clientContext = TypeContext.getContext();
        }
        catch (ServiceException e1) {
            Activator.log.error((Throwable)e1);
        }
        IElementType[] types = ElementTypeRegistry.getInstance().getElementTypes(clientContext);
        TreeSet<String> ids = new TreeSet<String>();
        IElementType[] iElementTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IElementType iElementType = iElementTypeArray[n2];
            String id = iElementType.getId();
            if (!id.contains("sysml.stereotype.") && !id.contains("uml.stereotype.")) {
                ids.add(id);
            }
            ++n2;
        }
        return ids;
    }

    public Object[] getChildren(Object parentElement) {
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }

    public void createBefore(Composite parent) {
        this.createPatternFilter(parent);
    }

    protected void createPatternFilter(Composite parent) {
        StringEditor editor = new StringEditor(parent, 0);
        editor.setLabel("Filter:");
        editor.setToolTipText(Messages.ElementTypeContentProvider_EnterTheNameOfTheWantedElement);
        editor.setValidateOnDelay(true);
        this.patternFilter = new PatternViewerFilter();
        ((PatternViewerFilter)this.patternFilter).setPattern(this.currentFilterPattern);
        editor.addCommitListener(new ICommitListener(){

            public void commit(AbstractEditor editor) {
                String filterPattern = (String)((StringEditor)editor).getValue();
                ((PatternViewerFilter)ElementTypeContentProvider.this.patternFilter).setPattern(filterPattern);
                ElementTypeContentProvider.this.viewer.refresh();
                if (!"".equals(filterPattern) && !ElementTypeContentProvider.this.currentFilterPattern.equals(filterPattern)) {
                    Object firstMatch = ElementTypeContentProvider.this.getFirstMatchingElement(null);
                    ElementTypeContentProvider.this.currentFilterPattern = filterPattern;
                }
            }
        });
        LinkedList<ViewerFilter> filters = new LinkedList<ViewerFilter>(Arrays.asList(this.viewer.getFilters()));
        filters.add(this.patternFilter);
        this.viewer.setFilters(filters.toArray(new ViewerFilter[filters.size()]));
    }

    public void createAfter(Composite parent) {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.viewer = (StructuredViewer)viewer;
    }

    protected Object getFirstMatchingElement(Object parent) {
        if (parent == null) {
            Object[] objectArray = this.getElements(this.viewer.getInput());
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object parentElement = objectArray[n2];
                Object firstMatch = this.getFirstMatchingElement(parentElement);
                if (firstMatch != null) {
                    return firstMatch;
                }
                ++n2;
            }
            return null;
        }
        Object[] objectArray = this.viewer.getFilters();
        int n = objectArray.length;
        int n3 = 0;
        while (n3 < n) {
            ViewerFilter filter = objectArray[n3];
            if (!filter.select((Viewer)this.viewer, this.getParent(parent), parent)) {
                return null;
            }
            ++n3;
        }
        objectArray = this.getChildren(parent);
        n = objectArray.length;
        n3 = 0;
        while (n3 < n) {
            ViewerFilter childElement = objectArray[n3];
            Object firstMatch = this.getFirstMatchingElement(childElement);
            if (firstMatch != null) {
                return firstMatch;
            }
            ++n3;
        }
        return null;
    }
}

