/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.completeocl.attributes;

import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainElement;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.scoping.AbstractAttribution;
import org.eclipse.ocl.examples.pivot.scoping.EnvironmentView;
import org.eclipse.ocl.examples.pivot.scoping.ScopeView;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2Pivot;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.ValidationDiagnostic;
import org.eclipse.ocl.examples.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.CompleteOCLCSTPackage;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.IncludeCS;
import org.eclipse.osgi.util.NLS;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class IncludeCSAttribution
extends AbstractAttribution
implements CS2Pivot.UnresolvedProxyMessageProvider {
    @NonNull
    public static final IncludeCSAttribution INSTANCE = new IncludeCSAttribution();

    public ScopeView computeLookup(@NonNull EObject target, @NonNull EnvironmentView environmentView, @NonNull ScopeView scopeView) {
        IncludeCS targetElement = (IncludeCS)target;
        IncludeAdapter adapter = (IncludeAdapter)((Object)PivotUtil.getAdapter(IncludeAdapter.class, (Notifier)targetElement));
        if (adapter == null) {
            adapter = new IncludeAdapter();
            targetElement.eAdapters().add((Object)adapter);
        }
        return adapter.computeLookup(targetElement, environmentView, scopeView);
    }

    @NonNull
    public EReference getEReference() {
        EReference eReference = CompleteOCLCSTPackage.Literals.INCLUDE_CS__NAMESPACE;
        return eReference;
    }

    public String getMessage(@NonNull EObject context, @NonNull String linkText) {
        IncludeAdapter adapter = (IncludeAdapter)((Object)PivotUtil.getAdapter(IncludeAdapter.class, (Notifier)context));
        if (adapter != null) {
            String message = adapter.getMessage();
            return NLS.bind((String)OCLMessages.UnresolvedInclude_ERROR_, (Object)linkText, (Object)message);
        }
        return null;
    }

    private static class IncludeAdapter
    extends AdapterImpl {
        private URI uri = null;
        private Element importedElement = null;
        private Throwable throwable = null;

        private IncludeAdapter() {
        }

        public ScopeView computeLookup(@NonNull IncludeCS targetElement, @NonNull EnvironmentView environmentView, @NonNull ScopeView scopeView) {
            URI extURI;
            URI envURI;
            URI resolvedURI;
            String name;
            Root root;
            String externalURI;
            Resource importedResource;
            EList errors;
            this.importComplement(targetElement, environmentView);
            Element importedElement2 = this.importedElement;
            if (importedElement2 != null && (errors = (importedResource = importedElement2.eResource()).getErrors()).size() == 0 && importedElement2 instanceof Root && (externalURI = (root = (Root)importedElement2).getExternalURI()) != null && (name = environmentView.getName()) != null && (resolvedURI = (envURI = URI.createURI((String)name)).resolve(extURI = URI.createURI((String)externalURI))).equals(extURI)) {
                environmentView.addElement(name, (DomainElement)root);
            }
            return null;
        }

        public String getMessage() {
            return this.throwable != null ? this.throwable.getMessage() : null;
        }

        protected void importComplement(@NonNull IncludeCS target, @NonNull EnvironmentView environmentView) {
            URI uri2;
            String name = environmentView.getName();
            if (name == null) {
                return;
            }
            BaseCSResource csResource = (BaseCSResource)target.eResource();
            try {
                URI newURI = URI.createURI((String)name);
                assert (newURI != null);
                if ((newURI = csResource.resolve(newURI)).equals(this.uri)) {
                    return;
                }
                uri2 = this.uri = newURI;
                this.importedElement = null;
                this.throwable = null;
            }
            catch (WrappedException e) {
                this.throwable = e.exception();
                return;
            }
            catch (Exception e) {
                this.throwable = e;
                return;
            }
            try {
                EList errors;
                MetaModelManager metaModelManager = environmentView.getMetaModelManager();
                this.importedElement = metaModelManager.loadResource(uri2, target.getName(), csResource.getResourceSet());
                Resource importedResource = this.importedElement.eResource();
                EList warnings = importedResource.getWarnings();
                if (warnings.size() > 0) {
                    ICompositeNode node = NodeModelUtils.getNode((EObject)target);
                    String errorMessage = PivotUtil.formatResourceDiagnostics((List)warnings, (String)DomainUtil.bind((String)OCLMessages.WarningsInURI, (Object[])new Object[]{uri2}), (String)"\n\t");
                    ValidationDiagnostic resourceDiagnostic = new ValidationDiagnostic((INode)node, errorMessage);
                    csResource.getWarnings().add((Object)resourceDiagnostic);
                }
                if ((errors = importedResource.getErrors()).size() > 0) {
                    ICompositeNode node = NodeModelUtils.getNode((EObject)target);
                    String errorMessage = PivotUtil.formatResourceDiagnostics((List)errors, (String)DomainUtil.bind((String)OCLMessages.ErrorsInURI, (Object[])new Object[]{uri2}), (String)"\n\t");
                    ValidationDiagnostic resourceDiagnostic = new ValidationDiagnostic((INode)node, errorMessage);
                    csResource.getErrors().add((Object)resourceDiagnostic);
                }
            }
            catch (WrappedException e) {
                this.throwable = e.exception();
            }
            catch (Exception e) {
                this.throwable = e;
            }
        }

        public boolean isAdapterForType(Object type) {
            return type == IncludeAdapter.class;
        }
    }
}

