/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.syntax;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.uml.alf.alf.AdditiveExpression;
import org.eclipse.papyrus.uml.alf.alf.AndExpression;
import org.eclipse.papyrus.uml.alf.alf.BOOLEAN_LITERAL;
import org.eclipse.papyrus.uml.alf.alf.BooleanValue;
import org.eclipse.papyrus.uml.alf.alf.CollectOrIterateOperation;
import org.eclipse.papyrus.uml.alf.alf.ConditionalAndExpression;
import org.eclipse.papyrus.uml.alf.alf.ConditionalOrExpression;
import org.eclipse.papyrus.uml.alf.alf.ExclusiveOrExpression;
import org.eclipse.papyrus.uml.alf.alf.ForAllOrExistsOrOneOperation;
import org.eclipse.papyrus.uml.alf.alf.INTEGER_LITERAL;
import org.eclipse.papyrus.uml.alf.alf.InclusiveOrExpression;
import org.eclipse.papyrus.uml.alf.alf.IsUniqueOperation;
import org.eclipse.papyrus.uml.alf.alf.LITERAL;
import org.eclipse.papyrus.uml.alf.alf.LinkOperationTuple;
import org.eclipse.papyrus.uml.alf.alf.MultiplicativeExpression;
import org.eclipse.papyrus.uml.alf.alf.NonLiteralValueSpecification;
import org.eclipse.papyrus.uml.alf.alf.NullExpression;
import org.eclipse.papyrus.uml.alf.alf.OperationCallExpression;
import org.eclipse.papyrus.uml.alf.alf.ParenthesizedExpression;
import org.eclipse.papyrus.uml.alf.alf.PrimaryExpression;
import org.eclipse.papyrus.uml.alf.alf.PropertyCallExpression;
import org.eclipse.papyrus.uml.alf.alf.QualifiedNamePath;
import org.eclipse.papyrus.uml.alf.alf.QualifiedNameWithBinding;
import org.eclipse.papyrus.uml.alf.alf.STRING_LITERAL;
import org.eclipse.papyrus.uml.alf.alf.SelectOrRejectOperation;
import org.eclipse.papyrus.uml.alf.alf.SequenceExpansionExpression;
import org.eclipse.papyrus.uml.alf.alf.SuffixExpression;
import org.eclipse.papyrus.uml.alf.alf.TupleElement;
import org.eclipse.papyrus.uml.alf.alf.UNLIMITED_LITERAL;
import org.eclipse.papyrus.uml.alf.alf.UnqualifiedName;
import org.eclipse.papyrus.uml.alf.alf.ValueSpecification;
import org.eclipse.papyrus.uml.alf.syntax.expressions.ArithmeticExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.BitStringUnaryExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.BooleanLiteralExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.BooleanUnaryExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.CastExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.ClassExtentExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.ClassificationExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.ConditionalLogicalExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.ConditionalTestExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.EqualityExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.Expression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.ExtentOrExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.FeatureInvocationExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.FeatureReference;
import org.eclipse.papyrus.uml.alf.syntax.expressions.ForAllOrExistsOrOneExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.InstanceCreationExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.InvocationExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.IsUniqueExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.IsolationExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.LinkOperationExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.LogicalExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.NameBinding;
import org.eclipse.papyrus.uml.alf.syntax.expressions.NameExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.NamedExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.NamedTemplateBinding;
import org.eclipse.papyrus.uml.alf.syntax.expressions.NamedTuple;
import org.eclipse.papyrus.uml.alf.syntax.expressions.NaturalLiteralExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.NumericUnaryExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.PositionalTuple;
import org.eclipse.papyrus.uml.alf.syntax.expressions.PropertyAccessExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.QualifiedName;
import org.eclipse.papyrus.uml.alf.syntax.expressions.RelationalExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.SelectOrRejectExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.SequenceAccessExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.SequenceConstructionExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.SequenceOperationExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.SequenceReductionExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.ShiftExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.StringLiteralExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.SuperInvocationExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.TemplateBinding;
import org.eclipse.papyrus.uml.alf.syntax.expressions.TemplateParameterSubstitution;
import org.eclipse.papyrus.uml.alf.syntax.expressions.ThisExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.Tuple;
import org.eclipse.papyrus.uml.alf.syntax.expressions.UnaryExpression;
import org.eclipse.papyrus.uml.alf.syntax.expressions.UnboundedLiteralExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTFactory {
    public QualifiedName synthesizeQualifiedName(QualifiedNameWithBinding parsed) {
        QualifiedName synthesized = new QualifiedName();
        synthesized.isAmbiguous = false;
        synthesized.nameBinding = new ArrayList<NameBinding>();
        synthesized.nameBinding.add(this.synthesizeNameBinding(parsed));
        QualifiedNameWithBinding remaining = parsed.getRemaining();
        while (remaining != null) {
            synthesized.nameBinding.add(this.synthesizeNameBinding(remaining));
            remaining = remaining.getRemaining();
        }
        return synthesized;
    }

    public QualifiedName synthesizeQualifiedName(org.eclipse.papyrus.uml.alf.alf.NameExpression parsed) {
        QualifiedName synthesized = new QualifiedName();
        synthesized.isAmbiguous = false;
        synthesized.nameBinding = new ArrayList<NameBinding>();
        if (parsed.getPath() != null) {
            QualifiedNamePath path = parsed.getPath();
            for (UnqualifiedName pathElement : path.getNamespace()) {
                synthesized.nameBinding.add(this.synthesizeNameBinding(pathElement));
            }
        }
        NameBinding last = new NameBinding();
        last.name = parsed.getId();
        synthesized.nameBinding.add(last);
        return synthesized;
    }

    public QualifiedName synthesizeQualifiedName(org.eclipse.papyrus.uml.alf.alf.Expression parsed) {
        org.eclipse.papyrus.uml.alf.alf.ConditionalTestExpression tmp1 = (org.eclipse.papyrus.uml.alf.alf.ConditionalTestExpression)parsed;
        if (tmp1.getWhenFalse() != null || tmp1.getWhenTrue() != null) {
            return new QualifiedName();
        }
        ConditionalOrExpression tmp2 = tmp1.getExp();
        if (tmp2.getExp().size() != 1) {
            return new QualifiedName();
        }
        ConditionalAndExpression tmp3 = (ConditionalAndExpression)tmp2.getExp().get(0);
        if (tmp3.getExp().size() != 1) {
            return new QualifiedName();
        }
        InclusiveOrExpression tmp4 = (InclusiveOrExpression)tmp3.getExp().get(0);
        if (tmp4.getExp().size() != 1) {
            return new QualifiedName();
        }
        ExclusiveOrExpression tmp5 = (ExclusiveOrExpression)tmp4.getExp().get(0);
        if (tmp5.getExp().size() != 1) {
            return new QualifiedName();
        }
        AndExpression tmp6 = (AndExpression)tmp5.getExp().get(0);
        if (tmp6.getExp().size() != 1) {
            return new QualifiedName();
        }
        org.eclipse.papyrus.uml.alf.alf.EqualityExpression tmp7 = (org.eclipse.papyrus.uml.alf.alf.EqualityExpression)tmp6.getExp().get(0);
        if (tmp7.getOp().size() != 0) {
            return new QualifiedName();
        }
        org.eclipse.papyrus.uml.alf.alf.ClassificationExpression tmp8 = (org.eclipse.papyrus.uml.alf.alf.ClassificationExpression)tmp7.getExp().get(0);
        if (tmp8.getOp() != null && !tmp8.getOp().equals("")) {
            return new QualifiedName();
        }
        org.eclipse.papyrus.uml.alf.alf.RelationalExpression tmp9 = tmp8.getExp();
        if (tmp9.getOp() != null && !tmp9.getOp().equals("")) {
            return new QualifiedName();
        }
        org.eclipse.papyrus.uml.alf.alf.ShiftExpression tmp10 = tmp9.getLeft();
        if (tmp10.getExp().size() != 1) {
            return new QualifiedName();
        }
        AdditiveExpression tmp11 = (AdditiveExpression)tmp10.getExp().get(0);
        if (tmp11.getExp().size() != 1) {
            return new QualifiedName();
        }
        MultiplicativeExpression tmp12 = (MultiplicativeExpression)tmp11.getExp().get(0);
        if (tmp12.getExp().size() != 1) {
            return new QualifiedName();
        }
        org.eclipse.papyrus.uml.alf.alf.UnaryExpression tmp13 = (org.eclipse.papyrus.uml.alf.alf.UnaryExpression)tmp12.getExp().get(0);
        if (tmp13.getOp() != null && !tmp13.getOp().equals("")) {
            return new QualifiedName();
        }
        PrimaryExpression tmp14 = tmp13.getExp();
        if (tmp14.getPrefix() == null) {
            return new QualifiedName();
        }
        ValueSpecification tmp15 = tmp14.getPrefix();
        if (!(tmp15 instanceof org.eclipse.papyrus.uml.alf.alf.NameExpression)) {
            return new QualifiedName();
        }
        return this.synthesizeQualifiedName((org.eclipse.papyrus.uml.alf.alf.NameExpression)tmp15);
    }

    public QualifiedName synthesizeQualifiedName(Expression synthesized) {
        if (synthesized instanceof NameExpression) {
            return ((NameExpression)synthesized).name;
        }
        return new QualifiedName();
    }

    public NameBinding synthesizeNameBinding(QualifiedNameWithBinding parsed) {
        NameBinding synthesized = new NameBinding();
        synthesized.name = parsed.getId();
        if (parsed.getBinding() != null) {
            synthesized.binding = this.synthesizeTemplateBinding(parsed.getBinding());
        }
        return synthesized;
    }

    public NameBinding synthesizeNameBinding(String parsed) {
        NameBinding synthesized = new NameBinding();
        synthesized.name = parsed;
        return synthesized;
    }

    public NameBinding synthesizeNameBinding(UnqualifiedName parsed) {
        NameBinding synthesized = new NameBinding();
        synthesized.name = parsed.getName();
        if (parsed.getTemplateBinding() != null) {
            synthesized.binding = this.synthesizeTemplateBinding(parsed.getTemplateBinding());
        }
        return synthesized;
    }

    public TemplateBinding synthesizeTemplateBinding(org.eclipse.papyrus.uml.alf.alf.TemplateBinding parsed) {
        return this.synthesizeNamedTemplateBinding(parsed);
    }

    public NamedTemplateBinding synthesizeNamedTemplateBinding(org.eclipse.papyrus.uml.alf.alf.TemplateBinding parsed) {
        NamedTemplateBinding synthesized = new NamedTemplateBinding();
        synthesized.substitution = new ArrayList<TemplateParameterSubstitution>();
        for (org.eclipse.papyrus.uml.alf.alf.NamedTemplateBinding s : parsed.getBindings()) {
            synthesized.substitution.add(this.synthesizeTemplateParameterSubstitution(s));
        }
        return synthesized;
    }

    public TemplateParameterSubstitution synthesizeTemplateParameterSubstitution(org.eclipse.papyrus.uml.alf.alf.NamedTemplateBinding parsed) {
        TemplateParameterSubstitution synthesized = new TemplateParameterSubstitution();
        synthesized.parameterName = parsed.getFormal();
        synthesized.argumentName = this.synthesizeQualifiedName(parsed.getActual());
        return synthesized;
    }

    public Expression synthesizeExpression(org.eclipse.papyrus.uml.alf.alf.Expression parsed) {
        return this.synthesizeConditionalTestExpression((org.eclipse.papyrus.uml.alf.alf.ConditionalTestExpression)parsed);
    }

    public Expression synthesizeExpression(ParenthesizedExpression parsed) {
        if (parsed.getCasted() == null) {
            Expression synthesized = this.synthesizeExpression(parsed.getExpOrTypeCast());
            if (parsed.getSuffix() != null) {
                return this.synthesizeExpression(synthesized, parsed.getSuffix());
            }
            return synthesized;
        }
        return this.synthesizeCastExpression(parsed);
    }

    public Expression synthesizeExpression(org.eclipse.papyrus.uml.alf.alf.NameExpression exp) {
        return new Expression();
    }

    public Expression synthesizeCastExpression(ParenthesizedExpression parsed) {
        CastExpression synthesized = new CastExpression();
        synthesized.operand = this.synthesizePrimaryExpression(parsed.getCasted());
        synthesized.typeName = this.synthesizeQualifiedName(parsed.getExpOrTypeCast());
        return synthesized;
    }

    public Expression synthesizeConditionalTestExpression(org.eclipse.papyrus.uml.alf.alf.ConditionalTestExpression parsed) {
        if (parsed.getWhenFalse() != null || parsed.getWhenTrue() != null) {
            ConditionalTestExpression synthesized = new ConditionalTestExpression();
            synthesized.operand1 = this.synthesizeConditionalLogicalExpression(parsed.getExp());
            synthesized.operand2 = this.synthesizeConditionalTestExpression(parsed.getWhenTrue());
            synthesized.operand3 = this.synthesizeConditionalTestExpression(parsed.getWhenFalse());
            return synthesized;
        }
        return this.synthesizeConditionalLogicalExpression(parsed.getExp());
    }

    public Expression synthesizeConditionalLogicalExpression(ConditionalOrExpression parsed) {
        if (parsed.getExp().size() == 1) {
            return this.synthesizeConditionalLogicalExpression((ConditionalAndExpression)parsed.getExp().get(0));
        }
        ConditionalLogicalExpression synthesized = new ConditionalLogicalExpression();
        synthesized.operand1 = this.synthesizeConditionalLogicalExpression((ConditionalAndExpression)parsed.getExp().get(0));
        synthesized.operand2 = this.synthesizeConditionalLogicalExpression(parsed.getExp().subList(1, parsed.getExp().size()));
        synthesized.operator = "||";
        return synthesized;
    }

    public Expression synthesizeConditionalLogicalExpression(ConditionalAndExpression parsed) {
        if (parsed.getExp().size() == 1) {
            return this.synthesizeLogicalExpression((InclusiveOrExpression)parsed.getExp().get(0));
        }
        ConditionalLogicalExpression synthesized = new ConditionalLogicalExpression();
        synthesized.operand1 = this.synthesizeLogicalExpression((InclusiveOrExpression)parsed.getExp().get(0));
        synthesized.operand2 = this.synthesizeLogicalExpressionFromListOfInclusiveOrExpression(parsed.getExp().subList(1, parsed.getExp().size()));
        synthesized.operator = "&&";
        return synthesized;
    }

    public Expression synthesizeConditionalLogicalExpression(List<ConditionalAndExpression> flatParsed) {
        if (flatParsed.size() == 1) {
            return this.synthesizeConditionalLogicalExpression(flatParsed.get(0));
        }
        ConditionalLogicalExpression synthesized = new ConditionalLogicalExpression();
        synthesized.operand1 = this.synthesizeConditionalLogicalExpression(flatParsed.get(0));
        synthesized.operand2 = this.synthesizeConditionalLogicalExpression(flatParsed.subList(1, flatParsed.size()));
        synthesized.operator = "&&";
        return synthesized;
    }

    public Expression synthesizeLogicalExpression(InclusiveOrExpression parsed) {
        if (parsed.getExp().size() == 1) {
            return this.synthesizeLogicalExpression((ExclusiveOrExpression)parsed.getExp().get(0));
        }
        LogicalExpression synthesized = new LogicalExpression();
        synthesized.operand1 = this.synthesizeLogicalExpression((ExclusiveOrExpression)parsed.getExp().get(0));
        synthesized.operand2 = this.synthesizeLogicalExpressionFromListOfExclusiveOrExpression(parsed.getExp().subList(1, parsed.getExp().size()));
        synthesized.operator = "|";
        return synthesized;
    }

    public Expression synthesizeLogicalExpressionFromListOfInclusiveOrExpression(List<InclusiveOrExpression> flatParsed) {
        if (flatParsed.size() == 1) {
            return this.synthesizeLogicalExpression(flatParsed.get(0));
        }
        LogicalExpression synthesized = new LogicalExpression();
        synthesized.operand1 = this.synthesizeLogicalExpression(flatParsed.get(0));
        synthesized.operand2 = this.synthesizeLogicalExpressionFromListOfInclusiveOrExpression(flatParsed.subList(1, flatParsed.size()));
        synthesized.operator = "|";
        return synthesized;
    }

    public Expression synthesizeLogicalExpression(ExclusiveOrExpression parsed) {
        if (parsed.getExp().size() == 1) {
            return this.synthesizeLogicalExpression((AndExpression)parsed.getExp().get(0));
        }
        LogicalExpression synthesized = new LogicalExpression();
        synthesized.operand1 = this.synthesizeLogicalExpression((AndExpression)parsed.getExp().get(0));
        synthesized.operand2 = this.synthesizeLogicalExpressionFromListOfAndExpression(parsed.getExp().subList(1, parsed.getExp().size()));
        synthesized.operator = "^";
        return synthesized;
    }

    public Expression synthesizeLogicalExpressionFromListOfExclusiveOrExpression(List<ExclusiveOrExpression> flatParsed) {
        if (flatParsed.size() == 1) {
            return this.synthesizeLogicalExpression(flatParsed.get(0));
        }
        LogicalExpression synthesized = new LogicalExpression();
        synthesized.operand1 = this.synthesizeLogicalExpression(flatParsed.get(0));
        synthesized.operand2 = this.synthesizeLogicalExpressionFromListOfExclusiveOrExpression(flatParsed.subList(1, flatParsed.size()));
        synthesized.operator = "^";
        return synthesized;
    }

    public Expression synthesizeLogicalExpression(AndExpression parsed) {
        if (parsed.getExp().size() == 1) {
            return this.synthesizeEqualityExpression((org.eclipse.papyrus.uml.alf.alf.EqualityExpression)parsed.getExp().get(0));
        }
        LogicalExpression synthesized = new LogicalExpression();
        synthesized.operand1 = this.synthesizeEqualityExpression((org.eclipse.papyrus.uml.alf.alf.EqualityExpression)parsed.getExp().get(0));
        synthesized.operand2 = this.synthesizeLogicalExpressionFromListOfEqualityExpression(parsed.getExp().subList(1, parsed.getExp().size()));
        synthesized.operator = "&";
        return synthesized;
    }

    public Expression synthesizeLogicalExpressionFromListOfEqualityExpression(List<org.eclipse.papyrus.uml.alf.alf.EqualityExpression> flatParsed) {
        if (flatParsed.size() == 1) {
            return this.synthesizeEqualityExpression(flatParsed.get(0));
        }
        LogicalExpression synthesized = new LogicalExpression();
        synthesized.operand1 = this.synthesizeEqualityExpression(flatParsed.get(0));
        synthesized.operand2 = this.synthesizeLogicalExpressionFromListOfEqualityExpression(flatParsed.subList(1, flatParsed.size()));
        synthesized.operator = "&";
        return synthesized;
    }

    public Expression synthesizeLogicalExpressionFromListOfAndExpression(List<AndExpression> flatParsed) {
        if (flatParsed.size() == 1) {
            return this.synthesizeLogicalExpression(flatParsed.get(0));
        }
        LogicalExpression synthesized = new LogicalExpression();
        synthesized.operand1 = this.synthesizeLogicalExpression(flatParsed.get(0));
        synthesized.operand2 = this.synthesizeLogicalExpressionFromListOfAndExpression(flatParsed.subList(1, flatParsed.size()));
        synthesized.operator = "&";
        return synthesized;
    }

    public Expression synthesizeEqualityExpression(org.eclipse.papyrus.uml.alf.alf.EqualityExpression parsed) {
        if (parsed.getExp().size() == 1) {
            return this.synthesizeClassificationExpression((org.eclipse.papyrus.uml.alf.alf.ClassificationExpression)parsed.getExp().get(0));
        }
        EqualityExpression synthesized = new EqualityExpression();
        synthesized.operand1 = this.synthesizeClassificationExpression((org.eclipse.papyrus.uml.alf.alf.ClassificationExpression)parsed.getExp().get(0));
        synthesized.operand2 = this.synthesizeEqualityExpression(parsed.getExp().subList(1, parsed.getExp().size()), parsed.getOp().subList(1, parsed.getOp().size()));
        synthesized.operator = (String)parsed.getOp().get(0);
        return synthesized;
    }

    public Expression synthesizeEqualityExpression(List<org.eclipse.papyrus.uml.alf.alf.ClassificationExpression> flatParsed, List<String> operators) {
        if (flatParsed.size() == 1) {
            return this.synthesizeClassificationExpression(flatParsed.get(0));
        }
        EqualityExpression synthesized = new EqualityExpression();
        synthesized.operand1 = this.synthesizeClassificationExpression(flatParsed.get(0));
        synthesized.operand2 = this.synthesizeEqualityExpression(flatParsed.subList(1, flatParsed.size()), operators.subList(1, operators.size()));
        synthesized.operator = operators.get(0);
        return synthesized;
    }

    public Expression synthesizeClassificationExpression(org.eclipse.papyrus.uml.alf.alf.ClassificationExpression parsed) {
        if (parsed.getOp() == null || parsed.getOp().equals("")) {
            return this.synthesizeRelationalExpression(parsed.getExp());
        }
        ClassificationExpression synthesized = new ClassificationExpression();
        synthesized.operand = this.synthesizeRelationalExpression(parsed.getExp());
        synthesized.typeName = this.synthesizeQualifiedName(parsed.getTypeName());
        synthesized.operator = parsed.getOp();
        return synthesized;
    }

    public Expression synthesizeRelationalExpression(org.eclipse.papyrus.uml.alf.alf.RelationalExpression parsed) {
        if (parsed.getOp() == null || parsed.getOp().equals("")) {
            return this.synthesizeShiftExpression(parsed.getLeft());
        }
        RelationalExpression synthesized = new RelationalExpression();
        synthesized.operand1 = this.synthesizeShiftExpression(parsed.getLeft());
        synthesized.operand2 = this.synthesizeShiftExpression(parsed.getRight());
        synthesized.operator = parsed.getOp();
        return synthesized;
    }

    public Expression synthesizeShiftExpression(org.eclipse.papyrus.uml.alf.alf.ShiftExpression parsed) {
        if (parsed.getExp().size() == 1) {
            return this.synthesizeArithmeticExpression((AdditiveExpression)parsed.getExp().get(0));
        }
        ShiftExpression synthesized = new ShiftExpression();
        synthesized.operand1 = this.synthesizeArithmeticExpression((AdditiveExpression)parsed.getExp().get(0));
        synthesized.operand2 = this.synthesizeArithmeticExpression((AdditiveExpression)parsed.getExp().get(1));
        synthesized.operator = parsed.getOp();
        return synthesized;
    }

    public Expression synthesizeArithmeticExpression(AdditiveExpression parsed) {
        if (parsed.getExp().size() == 1) {
            return this.synthesizeArithmeticExpression((MultiplicativeExpression)parsed.getExp().get(0));
        }
        ArithmeticExpression synthesized = new ArithmeticExpression();
        synthesized.operand1 = this.synthesizeArithmeticExpression((MultiplicativeExpression)parsed.getExp().get(0));
        synthesized.operand2 = this.synthesizeArithmeticExpressionFromListOfMultiplicativeExpression(parsed.getExp().subList(1, parsed.getExp().size()), parsed.getOp().subList(1, parsed.getOp().size()));
        synthesized.operator = (String)parsed.getOp().get(0);
        return synthesized;
    }

    public Expression synthesizeArithmeticExpressionFromListOfMultiplicativeExpression(List<MultiplicativeExpression> flatParsed, List<String> operators) {
        if (flatParsed.size() == 1) {
            return this.synthesizeArithmeticExpression(flatParsed.get(0));
        }
        EqualityExpression synthesized = new EqualityExpression();
        synthesized.operand1 = this.synthesizeArithmeticExpression(flatParsed.get(0));
        synthesized.operand2 = this.synthesizeArithmeticExpressionFromListOfMultiplicativeExpression(flatParsed.subList(1, flatParsed.size()), operators.subList(1, operators.size()));
        synthesized.operator = operators.get(0);
        return synthesized;
    }

    public Expression synthesizeArithmeticExpression(MultiplicativeExpression parsed) {
        if (parsed.getExp().size() == 1) {
            return this.synthesizeUnaryExpression((org.eclipse.papyrus.uml.alf.alf.UnaryExpression)parsed.getExp().get(0));
        }
        ArithmeticExpression synthesized = new ArithmeticExpression();
        synthesized.operand1 = this.synthesizeUnaryExpression((org.eclipse.papyrus.uml.alf.alf.UnaryExpression)parsed.getExp().get(0));
        synthesized.operand2 = this.synthesizeArithmeticExpressionFromListOfUnaryExpression(parsed.getExp().subList(1, parsed.getExp().size()), parsed.getOp().subList(1, parsed.getOp().size()));
        synthesized.operator = (String)parsed.getOp().get(0);
        return synthesized;
    }

    public Expression synthesizeArithmeticExpressionFromListOfUnaryExpression(List<org.eclipse.papyrus.uml.alf.alf.UnaryExpression> flatParsed, List<String> operators) {
        if (flatParsed.size() == 1) {
            return this.synthesizeUnaryExpression(flatParsed.get(0));
        }
        EqualityExpression synthesized = new EqualityExpression();
        synthesized.operand1 = this.synthesizeUnaryExpression(flatParsed.get(0));
        synthesized.operand2 = this.synthesizeArithmeticExpressionFromListOfUnaryExpression(flatParsed.subList(1, flatParsed.size()), operators.subList(1, operators.size()));
        synthesized.operator = operators.get(0);
        return synthesized;
    }

    public Expression synthesizeUnaryExpression(org.eclipse.papyrus.uml.alf.alf.UnaryExpression parsed) {
        if (parsed.getOp() == null || parsed.getOp().equals("")) {
            return this.synthesizePrimaryExpression(parsed.getExp());
        }
        UnaryExpression synthesized = new UnaryExpression();
        synthesized = parsed.getOp().equals("!") ? new BooleanUnaryExpression() : (parsed.getOp().equals("$") ? new IsolationExpression() : (parsed.getOp().equals("~") ? new BitStringUnaryExpression() : new NumericUnaryExpression()));
        synthesized.operand = this.synthesizePrimaryExpression(parsed.getExp());
        synthesized.operator = parsed.getOp();
        return synthesized;
    }

    public Expression synthesizePrimaryExpression(PrimaryExpression exp) {
        if (exp instanceof LITERAL) {
            return this.synthesizeLiteralExpression((LITERAL)((Object)exp));
        }
        if (exp instanceof org.eclipse.papyrus.uml.alf.alf.ThisExpression) {
            return this.synthesizeThisExpression((org.eclipse.papyrus.uml.alf.alf.ThisExpression)((Object)exp));
        }
        if (exp instanceof org.eclipse.papyrus.uml.alf.alf.SuperInvocationExpression) {
            return this.synthesizeSuperInvocationExpression((org.eclipse.papyrus.uml.alf.alf.SuperInvocationExpression)((Object)exp));
        }
        if (exp instanceof org.eclipse.papyrus.uml.alf.alf.InstanceCreationExpression) {
            return this.synthesizeInstanceCreationExpression((org.eclipse.papyrus.uml.alf.alf.InstanceCreationExpression)((Object)exp));
        }
        if (exp instanceof ParenthesizedExpression) {
            return this.synthesizeExpression((ParenthesizedExpression)((Object)exp));
        }
        if (exp instanceof org.eclipse.papyrus.uml.alf.alf.NameExpression) {
            return this.synthesizeExpression((org.eclipse.papyrus.uml.alf.alf.NameExpression)((Object)exp));
        }
        return this.synthesizeSequenceConstructionExpression((NullExpression)((Object)exp));
    }

    public Expression synthesizeSequenceConstructionExpression(NullExpression exp) {
        SequenceConstructionExpression synthesized = new SequenceConstructionExpression();
        return synthesized;
    }

    public Expression synthesizePrimaryExpression(NonLiteralValueSpecification exp) {
        if (exp instanceof org.eclipse.papyrus.uml.alf.alf.ThisExpression) {
            return this.synthesizeThisExpression((org.eclipse.papyrus.uml.alf.alf.ThisExpression)exp);
        }
        if (exp instanceof org.eclipse.papyrus.uml.alf.alf.SuperInvocationExpression) {
            return this.synthesizeSuperInvocationExpression((org.eclipse.papyrus.uml.alf.alf.SuperInvocationExpression)exp);
        }
        if (exp instanceof org.eclipse.papyrus.uml.alf.alf.InstanceCreationExpression) {
            return this.synthesizeInstanceCreationExpression((org.eclipse.papyrus.uml.alf.alf.InstanceCreationExpression)exp);
        }
        if (exp instanceof ParenthesizedExpression) {
            return this.synthesizeExpression((ParenthesizedExpression)exp);
        }
        return this.synthesizeExpression((org.eclipse.papyrus.uml.alf.alf.NameExpression)exp);
    }

    public Expression synthesizeLiteralExpression(LITERAL parsed) {
        if (parsed instanceof INTEGER_LITERAL) {
            NaturalLiteralExpression synthesized = new NaturalLiteralExpression();
            synthesized.image = ((INTEGER_LITERAL)parsed).getValue();
            return synthesized;
        }
        if (parsed instanceof UNLIMITED_LITERAL) {
            UnboundedLiteralExpression synthesized = new UnboundedLiteralExpression();
            return synthesized;
        }
        if (parsed instanceof STRING_LITERAL) {
            StringLiteralExpression synthesized = new StringLiteralExpression();
            synthesized.image = ((STRING_LITERAL)parsed).getValue();
            return synthesized;
        }
        BOOLEAN_LITERAL castedExp = (BOOLEAN_LITERAL)parsed;
        BooleanLiteralExpression synthesized = new BooleanLiteralExpression();
        synthesized.image = castedExp.getValue() == BooleanValue.TRUE ? "true" : "false";
        return synthesized;
    }

    public Expression synthesizeThisExpression(org.eclipse.papyrus.uml.alf.alf.ThisExpression parsed) {
        ThisExpression synthesized = new ThisExpression();
        if (parsed.getSuffix() != null) {
            return this.synthesizeExpression(synthesized, parsed.getSuffix());
        }
        return synthesized;
    }

    public Expression synthesizeSuperInvocationExpression(org.eclipse.papyrus.uml.alf.alf.SuperInvocationExpression parsed) {
        SuperInvocationExpression synthesized = new SuperInvocationExpression();
        if (parsed.getOperationName() != null) {
            synthesized.target = this.synthesizeQualifiedName(parsed.getOperationName());
        }
        synthesized.tuple = this.synthesizeTuple(parsed.getTuple(), synthesized);
        return synthesized;
    }

    public Tuple synthesizeTuple(org.eclipse.papyrus.uml.alf.alf.Tuple parsed, InvocationExpression invocation) {
        return this.synthesizePositionalTuple(parsed, invocation);
    }

    public Tuple synthesizePositionalTuple(org.eclipse.papyrus.uml.alf.alf.Tuple parsed, InvocationExpression invocation) {
        PositionalTuple synthesized = new PositionalTuple();
        synthesized.expression = new ArrayList<Expression>();
        for (TupleElement t : parsed.getTupleElements()) {
            synthesized.expression.add(this.synthesizeExpression(t.getArgument()));
        }
        synthesized.invocation = invocation;
        return synthesized;
    }

    public Tuple synthesizeNamedTupleFromLinkOperationExpression(LinkOperationTuple tuple, LinkOperationExpression invocation) {
        NamedTuple synthesized = new NamedTuple();
        synthesized.invocation = invocation;
        synthesized.namedExpression = new ArrayList<NamedExpression>();
        return synthesized;
    }

    public Expression synthesizeNameExpression(String object) {
        return null;
    }

    public Expression synthesizeInstanceCreationExpression(org.eclipse.papyrus.uml.alf.alf.InstanceCreationExpression parsed) {
        InstanceCreationExpression synthesized = new InstanceCreationExpression();
        synthesized.constructor = this.synthesizeQualifiedName(parsed.getConstructor());
        if (parsed.getSuffix() != null) {
            return this.synthesizeExpression(synthesized, parsed.getSuffix());
        }
        return synthesized;
    }

    public Expression synthesizeExpression(Expression synthesized, SuffixExpression suffix) {
        if (suffix instanceof OperationCallExpression) {
            return this.synthesizeFeatureInvocationExpression(synthesized, (OperationCallExpression)suffix);
        }
        if (suffix instanceof PropertyCallExpression) {
            return this.synthesizePropertyAccessExpression(synthesized, (PropertyCallExpression)suffix);
        }
        if (suffix instanceof org.eclipse.papyrus.uml.alf.alf.LinkOperationExpression) {
            return this.synthesizeLinkOperationExpression(synthesized, (org.eclipse.papyrus.uml.alf.alf.LinkOperationExpression)suffix);
        }
        if (suffix instanceof org.eclipse.papyrus.uml.alf.alf.SequenceOperationExpression) {
            return this.synthesizeSequenceOperationExpression(synthesized, (org.eclipse.papyrus.uml.alf.alf.SequenceOperationExpression)suffix);
        }
        if (suffix instanceof org.eclipse.papyrus.uml.alf.alf.SequenceReductionExpression) {
            return this.synthesizeSequenceReductionExpression(synthesized, (org.eclipse.papyrus.uml.alf.alf.SequenceReductionExpression)suffix);
        }
        if (suffix instanceof SequenceExpansionExpression) {
            return this.synthesizeSequenceExpansionExpression(synthesized, (SequenceExpansionExpression)suffix);
        }
        return this.synthesizeClassExtentExpression(synthesized, (org.eclipse.papyrus.uml.alf.alf.ClassExtentExpression)suffix);
    }

    public Expression synthesizeFeatureInvocationExpression(Expression target, OperationCallExpression suffix) {
        FeatureInvocationExpression synthesized = new FeatureInvocationExpression();
        synthesized.tuple = this.synthesizeTuple(suffix.getTuple(), synthesized);
        FeatureReference featureReference = new FeatureReference();
        featureReference.expression = target;
        featureReference.nameBinding = this.synthesizeNameBinding(suffix.getOperationName());
        synthesized.target = featureReference;
        if (suffix.getSuffix() != null) {
            return this.synthesizeExpression(synthesized, suffix.getSuffix());
        }
        return synthesized;
    }

    public Expression synthesizePropertyAccessExpression(Expression target, PropertyCallExpression suffix) {
        PropertyAccessExpression synthesized = new PropertyAccessExpression();
        FeatureReference featureReference = new FeatureReference();
        featureReference.expression = target;
        NameBinding nameBinding = new NameBinding();
        nameBinding.name = suffix.getPropertyName();
        featureReference.nameBinding = nameBinding;
        synthesized.featureReference = featureReference;
        Expression resultingExpression = synthesized;
        if (suffix.getIndex() != null) {
            SequenceAccessExpression synthesizedAccessExpression = new SequenceAccessExpression();
            synthesizedAccessExpression.primary = synthesized;
            synthesizedAccessExpression.index = this.synthesizeExpression(suffix.getIndex());
            resultingExpression = synthesizedAccessExpression;
        }
        if (suffix.getSuffix() != null) {
            return this.synthesizeExpression(resultingExpression, suffix.getSuffix());
        }
        return resultingExpression;
    }

    public Expression synthesizeLinkOperationExpression(Expression target, org.eclipse.papyrus.uml.alf.alf.LinkOperationExpression suffix) {
        LinkOperationExpression synthesized = new LinkOperationExpression();
        synthesized.tuple = this.synthesizeNamedTupleFromLinkOperationExpression(suffix.getTuple(), synthesized);
        synthesized.associationName = this.synthesizeQualifiedName(target);
        switch (suffix.getKind()) {
            case CLEAR: {
                synthesized.operation = "clearAssoc";
                break;
            }
            case CREATE: {
                synthesized.operation = "createLink";
                break;
            }
            case DESTROY: {
                synthesized.operation = "destroyLink";
            }
        }
        return synthesized;
    }

    public Expression synthesizeSequenceOperationExpression(Expression target, org.eclipse.papyrus.uml.alf.alf.SequenceOperationExpression suffix) {
        SequenceOperationExpression synthesized = new SequenceOperationExpression();
        synthesized.tuple = this.synthesizeTuple(suffix.getTuple(), synthesized);
        synthesized.operation = this.synthesizeQualifiedName(target);
        if (suffix.getSuffix() != null) {
            return this.synthesizeExpression(synthesized, suffix.getSuffix());
        }
        return synthesized;
    }

    public Expression synthesizeSequenceReductionExpression(Expression target, org.eclipse.papyrus.uml.alf.alf.SequenceReductionExpression suffix) {
        SequenceReductionExpression synthesized = new SequenceReductionExpression();
        synthesized.behaviorName = this.synthesizeQualifiedName(suffix.getBehavior());
        synthesized.isOrdered = suffix.isIsOrdered();
        synthesized.primary = this.synthesizeExtentOrExpression(target);
        if (suffix.getSuffix() != null) {
            return this.synthesizeExpression(synthesized, suffix.getSuffix());
        }
        return synthesized;
    }

    public Expression synthesizeSequenceExpansionExpression(Expression target, SequenceExpansionExpression suffix) {
        if (suffix instanceof SelectOrRejectOperation) {
            return this.synthesizeSelectOrRejectExpression(target, (SelectOrRejectOperation)suffix);
        }
        if (suffix instanceof ForAllOrExistsOrOneOperation) {
            return this.synthesizeForAllOrExistsOrOneExpression(target, (ForAllOrExistsOrOneOperation)suffix);
        }
        if (suffix instanceof CollectOrIterateOperation) {
            return this.synthesizeCollectOrIterateExpression(target, (CollectOrIterateOperation)suffix);
        }
        return this.synthesizeIsUniqueExpression(target, (IsUniqueOperation)suffix);
    }

    public Expression synthesizeSelectOrRejectExpression(Expression target, SelectOrRejectOperation suffix) {
        SelectOrRejectExpression synthesized = new SelectOrRejectExpression();
        synthesized.argument = this.synthesizeExpression(suffix.getExpr());
        switch (suffix.getOp()) {
            case SELECT: {
                synthesized.operation = "select";
                break;
            }
            case REJECT: {
                synthesized.operation = "reject";
                break;
            }
        }
        synthesized.variable = suffix.getName();
        synthesized.primary = this.synthesizeExtentOrExpression(target);
        if (suffix.getSuffix() != null) {
            return this.synthesizeExpression(synthesized, suffix.getSuffix());
        }
        return synthesized;
    }

    public Expression synthesizeForAllOrExistsOrOneExpression(Expression target, ForAllOrExistsOrOneOperation suffix) {
        ForAllOrExistsOrOneExpression synthesized = new ForAllOrExistsOrOneExpression();
        synthesized.argument = this.synthesizeExpression(suffix.getExpr());
        switch (suffix.getOp()) {
            case EXISTS: {
                synthesized.operation = "exists";
                break;
            }
            case FORALL: {
                synthesized.operation = "forAll";
                break;
            }
            case ONE: {
                synthesized.operation = "one";
                break;
            }
        }
        synthesized.variable = suffix.getName();
        synthesized.primary = this.synthesizeExtentOrExpression(target);
        if (suffix.getSuffix() != null) {
            return this.synthesizeExpression(synthesized, suffix.getSuffix());
        }
        return synthesized;
    }

    public Expression synthesizeCollectOrIterateExpression(Expression target, CollectOrIterateOperation suffix) {
        ForAllOrExistsOrOneExpression synthesized = new ForAllOrExistsOrOneExpression();
        synthesized.argument = this.synthesizeExpression(suffix.getExpr());
        switch (suffix.getOp()) {
            case COLLECT: {
                synthesized.operation = "collect";
                break;
            }
            case ITERATE: {
                synthesized.operation = "iterate";
                break;
            }
        }
        synthesized.variable = suffix.getName();
        synthesized.primary = this.synthesizeExtentOrExpression(target);
        if (suffix.getSuffix() != null) {
            return this.synthesizeExpression(synthesized, suffix.getSuffix());
        }
        return synthesized;
    }

    public Expression synthesizeIsUniqueExpression(Expression target, IsUniqueOperation suffix) {
        IsUniqueExpression synthesized = new IsUniqueExpression();
        synthesized.argument = this.synthesizeExpression(suffix.getExpr());
        synthesized.variable = suffix.getName();
        synthesized.primary = this.synthesizeExtentOrExpression(target);
        if (suffix.getSuffix() != null) {
            return this.synthesizeExpression(synthesized, suffix.getSuffix());
        }
        return synthesized;
    }

    public Expression synthesizeClassExtentExpression(Expression target, org.eclipse.papyrus.uml.alf.alf.ClassExtentExpression suffix) {
        ClassExtentExpression synthesized = new ClassExtentExpression();
        synthesized.className = this.synthesizeQualifiedName(target);
        return synthesized;
    }

    public ExtentOrExpression synthesizeExtentOrExpression(Expression target) {
        ExtentOrExpression synthesized = new ExtentOrExpression();
        QualifiedName tryQualifiedName = this.synthesizeQualifiedName(target);
        if (tryQualifiedName.nameBinding != null && !tryQualifiedName.nameBinding.isEmpty()) {
            synthesized.name = tryQualifiedName;
        } else {
            synthesized.nonNameExpression = target;
        }
        return synthesized;
    }
}

