/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.validation.typing;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.alf.alf.Expression;
import org.eclipse.papyrus.uml.alf.alf.SequenceExpansionExpression;
import org.eclipse.papyrus.uml.alf.alf.SuffixExpression;
import org.eclipse.papyrus.uml.alf.validation.AlfJavaValidator;
import org.eclipse.papyrus.uml.alf.validation.typing.SignatureFacade;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeExpression;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeUtils;
import org.eclipse.papyrus.uml.alf.validation.typing.VoidFacade;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.TypedElement;

public class TypeFacade {
    protected EObject typeObject;

    public void setTypeObject(EObject typeObject) {
        this.typeObject = typeObject;
    }

    public String getLabelWithoutBinding() {
        if (this.typeObject == null) {
            return "<Undefined>";
        }
        return "";
    }

    public int isCompatibleWithMe(TypeFacade type) {
        Classifier myType = TypeFacade.extractActualType(this);
        if (myType == null) {
            return 3;
        }
        Classifier hisType = TypeFacade.extractActualType(type);
        if (hisType == null) {
            return 0;
        }
        if (this.perfectMatch(myType, hisType)) {
            return 3;
        }
        if (this.inheritanceMatch(myType, hisType)) {
            return 1;
        }
        return 0;
    }

    private boolean perfectMatch(Classifier myType, Classifier hisType) {
        boolean hisTypeIsPredefined;
        boolean myTypeIsPredefined = myType.getName().equals("Integer") || myType.getName().equals("String") || myType.getName().equals("Boolean") || myType.getName().equals("UnlimitedNatural");
        boolean bl = hisTypeIsPredefined = hisType.getName().equals("Integer") || hisType.getName().equals("String") || hisType.getName().equals("Boolean") || hisType.getName().equals("UnlimitedNatural");
        if (myTypeIsPredefined && hisTypeIsPredefined) {
            return myType.getName().equals(hisType.getName());
        }
        return myType == hisType;
    }

    private boolean autoConversionMatch(Classifier myType, Classifier hisType) {
        String autoConvertionOperatorName = "To" + myType.getName();
        List<SignatureFacade> availableConversionOperator = AlfJavaValidator.predefinedBehaviorsAndTypes.getSignatures(autoConvertionOperatorName);
        if (availableConversionOperator.isEmpty()) {
            return false;
        }
        int numberOfMatchingOperators = 0;
        for (SignatureFacade cddMatchingConvertionOperator : availableConversionOperator) {
            Classifier parameterType = TypeFacade.extractActualType(cddMatchingConvertionOperator.getParameters().get(0).getTypeFacade());
            Classifier returnType = TypeFacade.extractActualType(cddMatchingConvertionOperator.getReturnType().getTypeFacade());
            if (!this.perfectMatch(parameterType, hisType) || !this.perfectMatch(returnType, myType)) continue;
            ++numberOfMatchingOperators;
        }
        return numberOfMatchingOperators == 1;
    }

    private boolean inheritanceMatch(Classifier myType, Classifier hisType) {
        return hisType.getGenerals().contains((Object)myType);
    }

    public static Classifier extractActualType(TypeFacade t) {
        Classifier actualType = null;
        if (t.typeObject instanceof Classifier) {
            actualType = (Classifier)t.typeObject;
        } else if (t.typeObject instanceof ElementImport) {
            ElementImport eImport = (ElementImport)t.typeObject;
            if (eImport.getImportedElement() instanceof Classifier) {
                actualType = (Classifier)eImport.getImportedElement();
            }
        } else if (t.typeObject instanceof TypedElement) {
            actualType = (Classifier)((TypedElement)t.typeObject).getType();
        } else if (t instanceof VoidFacade) {
            actualType = TypeFacade.extractActualType(((VoidFacade)t).getTypeFacade());
        } else if (t.typeObject instanceof SequenceExpansionExpression) {
            EObject cddExpression = t.typeObject.eContainer();
            while (!(cddExpression instanceof Expression)) {
                cddExpression = cddExpression.eContainer();
            }
            TypeExpression typeOfPrefix = new TypeUtils((SuffixExpression)t.typeObject).getTypeOfExpression((Expression)cddExpression);
            actualType = TypeFacade.extractActualType(typeOfPrefix.getTypeFacade());
            for (Operation o : actualType.getAllOperations()) {
                if (!o.getName().equals("toSequence")) continue;
                Object object = actualType = o.getReturnResult() != null ? o.getReturnResult().getType() : actualType;
            }
        }
        return actualType;
    }

    public Classifier extractActualType() {
        return TypeFacade.extractActualType(this);
    }

    public boolean isAbstract() {
        Classifier myType = this.extractActualType();
        return myType != null ? myType.isAbstract() : false;
    }

    public boolean isATemplate() {
        Classifier myType = this.extractActualType();
        return myType != null ? myType.isTemplate() : false;
    }

    public boolean equals(Classifier c) {
        return this.typeObject == c;
    }

    public boolean isACollection() {
        return this.isCompatibleWithMe(TypeUtils._Collection) > 0 || this.isCompatibleWithMe(TypeUtils._Set) > 0 || this.isCompatibleWithMe(TypeUtils._Bag) > 0 || this.isCompatibleWithMe(TypeUtils._Queue) > 0 || this.isCompatibleWithMe(TypeUtils._OrderedSet) > 0 || this.isCompatibleWithMe(TypeUtils._List) > 0 || this.isCompatibleWithMe(TypeUtils._Deque) > 0 || this.isCompatibleWithMe(TypeUtils._Map) > 0;
    }

    public boolean isOrdered() {
        return false;
    }

    public String getLabel() {
        return "";
    }
}

