/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.service.types.command;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.papyrus.sysml.blocks.BlocksPackage;
import org.eclipse.papyrus.sysml.blocks.NestedConnectorEnd;
import org.eclipse.papyrus.sysml.service.types.utils.ConnectorUtils;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetNestedPathCommand
extends EditElementCommand {
    private ConnectorUtils utils = new ConnectorUtils();
    private List<Property> nestedPath;
    public static final int NESTED_SOURCE = 1;
    public static final int NESTED_TARGET = 2;
    private final int nestedEndDirection;

    public SetNestedPathCommand(String label, EObject elementToEdit, IEditCommandRequest request, List<Property> nestedPath, int nestedEndDirection) {
        super(label, elementToEdit, request);
        this.nestedPath = nestedPath;
        this.nestedEndDirection = nestedEndDirection;
    }

    public boolean canExecute() {
        if (!(this.getRequest() instanceof CreateRelationshipRequest) && !(this.getRequest() instanceof ReorientRelationshipRequest)) {
            return false;
        }
        return this.getConnector() == null || this.getConnector().getEnds().size() == 2;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Unexecutable command.");
        }
        ConnectorEnd modifiedEnd = this.getModifiedConnectorEnd();
        NestedConnectorEnd nestedConnectorEnd = (NestedConnectorEnd)UMLUtil.getStereotypeApplication((Element)modifiedEnd, NestedConnectorEnd.class);
        if (this.nestedPath.isEmpty()) {
            if (nestedConnectorEnd != null) {
                EcoreUtil.delete((EObject)nestedConnectorEnd, (boolean)true);
            }
        } else {
            if (nestedConnectorEnd == null) {
                nestedConnectorEnd = (NestedConnectorEnd)UMLUtil.StereotypeApplicationHelper.INSTANCE.applyStereotype((Element)modifiedEnd, BlocksPackage.eINSTANCE.getNestedConnectorEnd());
            }
            if (!nestedConnectorEnd.getPropertyPath().equals(this.nestedPath)) {
                nestedConnectorEnd.getPropertyPath().clear();
                nestedConnectorEnd.getPropertyPath().addAll(this.nestedPath);
            }
        }
        return CommandResult.newOKCommandResult((Object)this.getConnector());
    }

    private ConnectorEnd getModifiedConnectorEnd() {
        return this.nestedEndDirection == 1 ? this.utils.getSourceConnectorEnd(this.getConnector()) : this.utils.getTargetConnectorEnd(this.getConnector());
    }

    private Connector getConnector() {
        Connector connector = null;
        if (this.getRequest() instanceof CreateRelationshipRequest) {
            connector = (Connector)((CreateRelationshipRequest)this.getRequest()).getNewElement();
        }
        if (this.getRequest() instanceof ReorientRelationshipRequest) {
            connector = (Connector)((ReorientRelationshipRequest)this.getRequest()).getRelationship();
        }
        return connector;
    }
}

