/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.service.types.helper;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.sysml.constraints.ConstraintBlock;
import org.eclipse.papyrus.sysml.constraints.ConstraintsPackage;
import org.eclipse.papyrus.uml.service.types.helper.advice.AbstractStereotypedElementEditHelperAdvice;
import org.eclipse.papyrus.uml.service.types.utils.NamedElementHelper;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ConstraintPropertyEditHelperAdvice
extends AbstractStereotypedElementEditHelperAdvice {
    public ConstraintPropertyEditHelperAdvice() {
        this.requiredProfiles.add(ConstraintsPackage.eINSTANCE);
    }

    protected ICommand getBeforeConfigureCommand(final ConfigureRequest request) {
        return new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                NamedElement element = (NamedElement)request.getElementToConfigure();
                if (element != null) {
                    UMLUtil.StereotypeApplicationHelper.INSTANCE.applyStereotype((Element)element, ConstraintsPackage.eINSTANCE.getConstraintProperty());
                    String initializedName = NamedElementHelper.getDefaultNameWithIncrementFromBase((String)ConstraintsPackage.eINSTANCE.getConstraintProperty().getName().toLowerCase(), (Collection)element.eContainer().eContents());
                    element.setName(initializedName);
                    if (element instanceof Property) {
                        ((Property)element).setAggregation(AggregationKind.COMPOSITE_LITERAL);
                    }
                }
                return CommandResult.newOKCommandResult((Object)element);
            }
        };
    }

    protected ICommand getBeforeSetCommand(SetRequest request) {
        if (UMLPackage.eINSTANCE.getTypedElement_Type().equals(request.getFeature()) && request.getValue() != null) {
            if (!(request.getValue() instanceof Element)) {
                return UnexecutableCommand.INSTANCE;
            }
            ConstraintBlock constraint = (ConstraintBlock)UMLUtil.getStereotypeApplication((Element)((Element)request.getValue()), ConstraintBlock.class);
            if (constraint == null) {
                return UnexecutableCommand.INSTANCE;
            }
        }
        return null;
    }
}

