/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.session;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchHandler;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRange;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.lob.CDOLob;
import org.eclipse.emf.cdo.common.lob.CDOLobInfo;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.remote.CDORemoteSession;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionMessage;
import org.eclipse.emf.cdo.spi.common.CDORawReplicationContext;
import org.eclipse.emf.cdo.spi.common.CDOReplicationContext;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDORevisionAvailabilityInfo;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.RevisionInfo;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.spi.cdo.AbstractQueryIterator;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDORemoteSessionManager;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOXATransaction;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingSessionProtocol
extends Lifecycle
implements CDOSessionProtocol {
    private CDOSessionProtocol delegate;
    private CDOSession.ExceptionHandler exceptionHandler;
    @ReflectUtil.ExcludeFromDump
    private IListener delegateListener = new LifecycleEventAdapter(){

        protected void onDeactivated(ILifecycle lifecycle) {
            DelegatingSessionProtocol.this.deactivate();
        }
    };

    public DelegatingSessionProtocol(CDOSessionProtocol delegate, CDOSession.ExceptionHandler handler) {
        this.delegate = delegate;
        this.exceptionHandler = handler;
        this.activate();
    }

    public CDOSessionProtocol getDelegate() {
        return this.delegate;
    }

    public void setDelegate(CDOSessionProtocol delegate) {
        if (delegate != null) {
            this.unhookDelegate();
            if (LifecycleUtil.isActive((Object)this.delegate)) {
                LifecycleUtil.deactivate((Object)this.delegate);
            }
        }
        this.delegate = delegate;
        this.hookDelegate();
    }

    public CDOSession getSession() {
        return (CDOSession)this.delegate.getSession();
    }

    @Override
    public boolean cancelQuery(int queryId) {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.cancelQuery(queryId);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public void changeSubscription(int viewID, List<CDOID> ids, boolean subscribeMode, boolean clear) {
        int attempt = 0;
        while (true) {
            try {
                this.delegate.changeSubscription(viewID, ids, subscribeMode, clear);
                return;
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public void openView(int viewID, boolean readOnly, CDOBranchPoint branchPoint) {
        int attempt = 0;
        while (true) {
            try {
                this.delegate.openView(viewID, readOnly, branchPoint);
                return;
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public CDOBranchPoint openView(int viewID, boolean readOnly, String durableLockingID) {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.openView(viewID, readOnly, durableLockingID);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public void switchTarget(int viewID, CDOBranchPoint branchPoint, List<InternalCDOObject> invalidObjects, List<CDORevisionKey> allChangedObjects, List<CDOIDAndVersion> allDetachedObjects, OMMonitor monitor) {
        int attempt = 0;
        while (true) {
            try {
                this.delegate.switchTarget(viewID, branchPoint, invalidObjects, allChangedObjects, allDetachedObjects, monitor);
                return;
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public void closeView(int viewID) {
        int attempt = 0;
        while (true) {
            try {
                if (this.delegate != null) {
                    this.delegate.closeView(viewID);
                }
                return;
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public List<byte[]> queryLobs(Set<byte[]> ids) {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.queryLobs(ids);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public void loadLob(CDOLobInfo info, Object outputStreamOrWriter) {
        int attempt = 0;
        while (true) {
            try {
                this.delegate.loadLob(info, outputStreamOrWriter);
                return;
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public void handleRevisions(EClass eClass, CDOBranch branch, boolean exactBranch, long timeStamp, boolean exactTime, CDORevisionHandler handler) {
        int attempt = 0;
        while (true) {
            try {
                this.delegate.handleRevisions(eClass, branch, exactBranch, timeStamp, exactTime, handler);
                return;
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    @Deprecated
    public CDOSessionProtocol.CommitTransactionResult commitTransaction(int transactionID, String comment, boolean releaseLocks, CDOIDProvider idProvider, CDOCommitData commitData, Collection<CDOLob<?>> lobs, OMMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CDOSessionProtocol.CommitTransactionResult commitTransaction(InternalCDOTransaction.InternalCDOCommitContext context, OMMonitor monitor) {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.commitTransaction(context, monitor);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    @Deprecated
    public CDOSessionProtocol.CommitTransactionResult commitDelegation(CDOBranch branch, String userID, String comment, CDOCommitData commitData, Map<CDOID, EClass> detachedObjectTypes, Collection<CDOLob<?>> lobs, OMMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CDOSessionProtocol.CommitTransactionResult commitDelegation(InternalCDOTransaction.InternalCDOCommitContext context, OMMonitor monitor) {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.commitDelegation(context, monitor);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public CDOSessionProtocol.CommitTransactionResult commitXATransactionCancel(InternalCDOXATransaction.InternalCDOXACommitContext xaContext, OMMonitor monitor) {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.commitXATransactionCancel(xaContext, monitor);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public CDOSessionProtocol.CommitTransactionResult commitXATransactionPhase1(InternalCDOXATransaction.InternalCDOXACommitContext xaContext, OMMonitor monitor) {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.commitXATransactionPhase1(xaContext, monitor);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public CDOSessionProtocol.CommitTransactionResult commitXATransactionPhase2(InternalCDOXATransaction.InternalCDOXACommitContext xaContext, OMMonitor monitor) {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.commitXATransactionPhase2(xaContext, monitor);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public CDOSessionProtocol.CommitTransactionResult commitXATransactionPhase3(InternalCDOXATransaction.InternalCDOXACommitContext xaContext, OMMonitor monitor) {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.commitXATransactionPhase3(xaContext, monitor);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public CDOSessionProtocol.RepositoryTimeResult getRepositoryTime() {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.getRepositoryTime();
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public CDOLockState[] getLockStates(int viewID, Collection<CDOID> ids) {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.getLockStates(viewID, ids);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public void enableLockNotifications(int viewID, boolean enable) {
        int attempt = 0;
        while (true) {
            try {
                this.delegate.enableLockNotifications(viewID, enable);
                return;
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean isObjectLocked(CDOView view, CDOObject object, IRWLockManager.LockType lockType, boolean byOthers) {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.isObjectLocked(view, object, lockType, byOthers);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public String changeLockArea(CDOView view, boolean create) {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.changeLockArea(view, create);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    public EPackage[] loadPackages(CDOPackageUnit packageUnit) {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.loadPackages(packageUnit);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    public Pair<Integer, Long> createBranch(int branchID, InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo) {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.createBranch(branchID, branchInfo);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    public InternalCDOBranchManager.BranchLoader.BranchInfo loadBranch(int branchID) {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.loadBranch(branchID);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    public InternalCDOBranchManager.BranchLoader.SubBranchInfo[] loadSubBranches(int branchID) {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.loadSubBranches(branchID);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    public int loadBranches(int startID, int endID, CDOBranchHandler branchHandler) {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.loadBranches(startID, endID, branchHandler);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    public void loadCommitInfos(CDOBranch branch, long startTime, long endTime, CDOCommitInfoHandler handler) {
        int attempt = 0;
        while (true) {
            try {
                this.delegate.loadCommitInfos(branch, startTime, endTime, handler);
                return;
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    public CDOCommitData loadCommitData(long timeStamp) {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.loadCommitData(timeStamp);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public Object loadChunk(InternalCDORevision revision, EStructuralFeature feature, int accessIndex, int fetchIndex, int fromIndex, int toIndex) {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.loadChunk(revision, feature, accessIndex, fetchIndex, fromIndex, toIndex);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    public List<InternalCDORevision> loadRevisions(List<RevisionInfo> infos, CDOBranchPoint branchPoint, int referenceChunk, int prefetchDepth) {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.loadRevisions(infos, branchPoint, referenceChunk, prefetchDepth);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    public InternalCDORevision loadRevisionByVersion(CDOID id, CDOBranchVersion branchVersion, int referenceChunk) {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.loadRevisionByVersion(id, branchVersion, referenceChunk);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    @Deprecated
    public CDOSessionProtocol.LockObjectsResult lockObjects(List<InternalCDORevision> viewedRevisions, int viewID, CDOBranch viewedBranch, IRWLockManager.LockType lockType, long timeout) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CDOSessionProtocol.LockObjectsResult lockObjects2(List<CDORevisionKey> revisionKeys, int viewID, CDOBranch viewedBranch, IRWLockManager.LockType lockType, boolean recursive, long timeout) throws InterruptedException {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.lockObjects2(revisionKeys, viewID, viewedBranch, lockType, recursive, timeout);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public CDOSessionProtocol.LockObjectsResult delegateLockObjects(String lockAreaID, List<CDORevisionKey> revisionKeys, CDOBranch viewedBranch, IRWLockManager.LockType lockType, boolean recursive, long timeout) throws InterruptedException {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.delegateLockObjects(lockAreaID, revisionKeys, viewedBranch, lockType, recursive, timeout);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public CDOSessionProtocol.UnlockObjectsResult delegateUnlockObjects(String lockAreaID, Collection<CDOID> objectIDs, IRWLockManager.LockType lockType, boolean recursive) {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.delegateUnlockObjects(lockAreaID, objectIDs, lockType, recursive);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public void query(CDOView view, AbstractQueryIterator<?> queryResult) {
        int attempt = 0;
        while (true) {
            try {
                this.delegate.query(view, queryResult);
                return;
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public void disablePassiveUpdate() {
        int attempt = 0;
        while (true) {
            try {
                this.delegate.disablePassiveUpdate();
                return;
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public void setPassiveUpdateMode(CDOCommonSession.Options.PassiveUpdateMode mode) {
        int attempt = 0;
        while (true) {
            try {
                this.delegate.setPassiveUpdateMode(mode);
                return;
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public void setLockNotificationMode(CDOCommonSession.Options.LockNotificationMode mode) {
        int attempt = 0;
        while (true) {
            try {
                this.delegate.setLockNotificationMode(mode);
                return;
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public CDOSessionProtocol.RefreshSessionResult refresh(long lastUpdateTime, Map<CDOBranch, Map<CDOID, InternalCDORevision>> viewedRevisions, int initialChunkSize, boolean enablePassiveUpdates) {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.refresh(lastUpdateTime, viewedRevisions, initialChunkSize, enablePassiveUpdates);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    @Deprecated
    public void unlockObjects(CDOView view, Collection<CDOID> objectIDs, IRWLockManager.LockType lockType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CDOSessionProtocol.UnlockObjectsResult unlockObjects2(CDOView view, Collection<CDOID> objectIDs, IRWLockManager.LockType lockType, boolean recursive) {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.unlockObjects2(view, objectIDs, lockType, recursive);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public List<CDORemoteSession> getRemoteSessions(InternalCDORemoteSessionManager manager, boolean subscribe) {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.getRemoteSessions(manager, subscribe);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public Set<Integer> sendRemoteMessage(CDORemoteSessionMessage message, List<CDORemoteSession> recipients) {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.sendRemoteMessage(message, recipients);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean unsubscribeRemoteSessions() {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.unsubscribeRemoteSessions();
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public void replicateRepository(CDOReplicationContext context, OMMonitor monitor) {
        int attempt = 0;
        while (true) {
            try {
                this.delegate.replicateRepository(context, monitor);
                return;
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public void replicateRepositoryRaw(CDORawReplicationContext context, OMMonitor monitor) {
        int attempt = 0;
        while (true) {
            try {
                this.delegate.replicateRepositoryRaw(context, monitor);
                return;
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public CDOChangeSetData[] loadChangeSets(CDOBranchPointRange ... ranges) {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.loadChangeSets(ranges);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public Set<CDOID> loadMergeData(CDORevisionAvailabilityInfo targetInfo, CDORevisionAvailabilityInfo sourceInfo, CDORevisionAvailabilityInfo targetBaseInfo, CDORevisionAvailabilityInfo sourceBaseInfo) {
        int attempt = 0;
        while (true) {
            try {
                return this.delegate.loadMergeData(targetInfo, sourceInfo, targetBaseInfo, sourceBaseInfo);
            }
            catch (Exception ex) {
                this.handleException(++attempt, ex);
                continue;
            }
            break;
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.hookDelegate();
    }

    private void hookDelegate() {
        EventUtil.addListener((Object)this.delegate, (IListener)this.delegateListener);
    }

    protected void doDeactivate() throws Exception {
        this.unhookDelegate();
        LifecycleUtil.deactivate((Object)this.delegate);
        this.delegate = null;
        super.doDeactivate();
    }

    private void unhookDelegate() {
        EventUtil.removeListener((Object)this.delegate, (IListener)this.delegateListener);
    }

    private void handleException(int attempt, Exception exception) {
        try {
            this.exceptionHandler.handleException(this.getSession(), attempt, exception);
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }
}

