/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.local;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.AddToSVNIgnoreOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.refactor.DeleteResourceOperation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.resource.events.IResourceStatesListener;
import org.eclipse.team.svn.core.resource.events.ResourceStatesChangedEvent;
import org.eclipse.team.svn.core.svnstorage.ResourcesParentsProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.action.local.AddToSVNIgnoreAction;
import org.eclipse.team.svn.ui.dialog.DiscardConfirmationDialog;
import org.eclipse.team.svn.ui.panel.local.AbstractResourceSelectionPanel;
import org.eclipse.team.svn.ui.panel.participant.AddToSVNPaneParticipant;
import org.eclipse.team.svn.ui.panel.participant.BasePaneParticipant;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.ResourceScope;

public class AddToSVNPanel
extends AbstractResourceSelectionPanel {
    protected boolean actionTookEffect = false;
    protected IResourceStatesListener resourceStatesListener;

    public AddToSVNPanel(IResource[] resources) {
        this(resources, null);
    }

    public AddToSVNPanel(IResource[] resources, IResource[] userSelectedResources) {
        super(resources, userSelectedResources, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL});
        this.dialogTitle = SVNUIMessages.AddToSVNPanel_Title;
        boolean isParticipantPane = this.paneParticipantHelper.isParticipantPane();
        String string = this.dialogDescription = isParticipantPane ? SVNUIMessages.AddToSVNPanel_Pane_Description : SVNUIMessages.AddToSVNPanel_Description;
        if (resources.length == 1) {
            this.defaultMessage = isParticipantPane ? SVNUIMessages.AddToSVNPanel_Pane_Message_Single : SVNUIMessages.AddToSVNPanel_Message_Single;
        } else {
            String defaultMessage = isParticipantPane ? SVNUIMessages.AddToSVNPanel_Pane_Message_Multi : SVNUIMessages.AddToSVNPanel_Message_Multi;
            this.defaultMessage = SVNUIMessages.format((String)defaultMessage, (Object[])new String[]{String.valueOf(resources.length)});
        }
    }

    protected void addContextMenu() {
        final TableViewer tableViewer = this.selectionComposite.getTableViewer();
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)tableViewer.getTable());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("additions"));
                IStructuredSelection tSelection = (IStructuredSelection)tableViewer.getSelection();
                final IResource[] selectedResources = tSelection.toList().toArray(new IResource[tSelection.size()]);
                Action tAction = null;
                if (selectedResources.length == 1) {
                    tAction = new Action(BaseMessages.format((String)SVNUIMessages.AddToSVNPanel_Ignore_Single, (Object[])new String[]{selectedResources[0].getName()})){

                        public void run() {
                            CompositeOperation op = new CompositeOperation("Operation_AddToSVNIgnore", SVNMessages.class);
                            op.add((IActionOperation)new AddToSVNIgnoreOperation(selectedResources, 0, null));
                            op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider(selectedResources), 2, RefreshResourcesOperation.REFRESH_ALL));
                            UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)AddToSVNIgnoreAction.SF_NEW_AND_PARENT_VERSIONED, (int)0));
                    String name = selectedResources[0].getName();
                    String[] parts = name.split("\\.");
                    if (parts.length != 0) {
                        tAction = new Action(BaseMessages.format((String)SVNUIMessages.AddToSVNPanel_Ignore_Single, (Object[])new String[]{"*." + parts[parts.length - 1]})){

                            public void run() {
                                CompositeOperation op = new CompositeOperation("Operation_AddToSVNIgnore", SVNMessages.class);
                                op.add((IActionOperation)new AddToSVNIgnoreOperation(selectedResources, 1, null));
                                op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider(selectedResources), 2, RefreshResourcesOperation.REFRESH_ALL));
                                UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
                            }
                        };
                        manager.add((IAction)tAction);
                        tAction.setEnabled(FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)AddToSVNIgnoreAction.SF_NEW_AND_PARENT_VERSIONED, (int)0));
                    }
                } else {
                    tAction = new Action(SVNUIMessages.AddToSVNPanel_IgnoreByNames_Multiple){

                        public void run() {
                            CompositeOperation op = new CompositeOperation("Operation_AddToSVNIgnore", SVNMessages.class);
                            op.add((IActionOperation)new AddToSVNIgnoreOperation(selectedResources, 0, null));
                            op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider(selectedResources), 2, RefreshResourcesOperation.REFRESH_ALL));
                            UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(tSelection.size() > 0);
                    tAction = new Action(SVNUIMessages.AddToSVNPanel_IgnoreByExtension_Multiple){

                        public void run() {
                            CompositeOperation op = new CompositeOperation("Operation_AddToSVNIgnore", SVNMessages.class);
                            op.add((IActionOperation)new AddToSVNIgnoreOperation(selectedResources, 1, null));
                            op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider(selectedResources), 2, RefreshResourcesOperation.REFRESH_ALL));
                            UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(tSelection.size() > 0);
                }
                manager.add((IContributionItem)new Separator());
                tAction = new Action(SVNUIMessages.AddToSVNPanel_Delete_Action_Lable){

                    public void run() {
                        DiscardConfirmationDialog dialog = new DiscardConfirmationDialog(UIMonitorUtility.getShell(), selectedResources.length == 1, 2);
                        if (dialog.open() == 0) {
                            DeleteResourceOperation deleteOperation = new DeleteResourceOperation(selectedResources);
                            CompositeOperation op = new CompositeOperation(deleteOperation.getId(), deleteOperation.getMessagesClass());
                            SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(selectedResources);
                            RestoreProjectMetaOperation restoreOp = new RestoreProjectMetaOperation(saveOp);
                            op.add((IActionOperation)saveOp);
                            op.add((IActionOperation)deleteOperation);
                            op.add((IActionOperation)restoreOp);
                            op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider(selectedResources), 2, RefreshResourcesOperation.REFRESH_ALL));
                            UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/delete.gif"));
                tAction.setEnabled(tSelection.size() > 0);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        tableViewer.getTable().setMenu(menu);
    }

    public void postInit() {
        super.postInit();
        this.resourceStatesListener = new IResourceStatesListener(){

            public void resourcesStateChanged(ResourceStatesChangedEvent event) {
                AddToSVNPanel.this.updateResources();
            }
        };
        SVNRemoteStorage.instance().addResourceStatesListener(ResourceStatesChangedEvent.class, this.resourceStatesListener);
    }

    public boolean ifActionTookEffect() {
        return this.actionTookEffect;
    }

    public void updateResources() {
        HashSet<IResource> toDeleteSet = new HashSet<IResource>();
        toDeleteSet.addAll(Arrays.asList(this.resources));
        HashSet<IResource> newResourcesSet = new HashSet<IResource>();
        newResourcesSet.addAll(Arrays.asList(FileUtility.getResourcesRecursive((IResource[])this.resources, (IStateFilter)IStateFilter.SF_UNVERSIONED, (int)0)));
        List<IResource> ignored = Arrays.asList(FileUtility.getResourcesRecursive((IResource[])this.resources, (IStateFilter)IStateFilter.SF_IGNORED, (int)0));
        if (ignored.size() != 0) {
            this.actionTookEffect = true;
        }
        newResourcesSet.removeAll(Arrays.asList(FileUtility.getResourcesRecursive((IResource[])this.resources, (IStateFilter)IStateFilter.SF_IGNORED, (int)0)));
        int i = 0;
        while (i < this.resources.length) {
            if (!this.resources[i].exists()) {
                newResourcesSet.remove(this.resources[i]);
                this.actionTookEffect = true;
            }
            ++i;
        }
        final IResource[] newResources = newResourcesSet.toArray(new IResource[newResourcesSet.size()]);
        toDeleteSet.removeAll(newResourcesSet);
        final IResource[] toDeleteResources = toDeleteSet.toArray(new IResource[toDeleteSet.size()]);
        if (!this.paneParticipantHelper.isParticipantPane()) {
            final TableViewer tableViewer = this.selectionComposite.getTableViewer();
            UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                public void run() {
                    AddToSVNPanel.this.selectionComposite.setResources(newResources);
                    if (!tableViewer.getTable().isDisposed()) {
                        tableViewer.remove((Object[])toDeleteResources);
                        tableViewer.refresh();
                        AddToSVNPanel.this.selectionComposite.fireSelectionChanged();
                    }
                }
            });
        }
        this.resources = newResources;
    }

    public void dispose() {
        super.dispose();
        SVNRemoteStorage.instance().removeResourceStatesListener(ResourceStatesChangedEvent.class, this.resourceStatesListener);
    }

    public String getHelpId() {
        return "org.eclipse.team.svn.help.addToVCDialogContext";
    }

    protected BasePaneParticipant createPaneParticipant() {
        return new AddToSVNPaneParticipant((ISynchronizeScope)new ResourceScope(this.resources), this);
    }
}

