/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.verifier;

import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.verifier.AbstractFormattedVerifier;

public class MultiLinePropertyVerifier
extends AbstractFormattedVerifier {
    protected static String ERROR_MESSAGE_INVALID_FORMAT = "Field '$FIELD_NAME$' contains malformed property in line ";

    public MultiLinePropertyVerifier(String fieldName) {
        super(fieldName);
        ERROR_MESSAGE_INVALID_FORMAT = SVNUIMessages.Verifier_MultiLineProperty_Main;
    }

    protected String getErrorMessageImpl(Control input) {
        String[] properties = this.getText(input).split(System.getProperty("line.separator"));
        int i = 0;
        while (i < properties.length) {
            if (properties[i].length() != 0) {
                String[] nestedProperties = properties[i].split(";");
                int j = 0;
                while (j < nestedProperties.length) {
                    String retVal;
                    String property = nestedProperties[j].trim();
                    if (property.length() != 0 && (retVal = this.validateProperty(property, i)) != null) {
                        return retVal;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    protected String getWarningMessageImpl(Control input) {
        return null;
    }

    protected String validateProperty(String property, int line) {
        if (property.indexOf("=") != property.lastIndexOf("=")) {
            return String.valueOf(this.formatMainMessage(line)) + " " + SVNUIMessages.Verifier_MultiLineProperty_ManyEquals;
        }
        String[] propNameValue = property.split("=");
        if (propNameValue.length == 0 || propNameValue[0].length() == 0) {
            return String.valueOf(this.formatMainMessage(line)) + " " + SVNUIMessages.Verifier_MultiLineProperty_NameIsEmpty;
        }
        Pattern pattern = Pattern.compile("[a-zA-Z].*");
        if (!pattern.matcher(propNameValue[0]).matches()) {
            return String.valueOf(this.formatMainMessage(line)) + " " + SVNUIMessages.Verifier_MultiLineProperty_NotALetter;
        }
        pattern = Pattern.compile("[a-zA-Z0-9:\\-_.]*");
        if (!pattern.matcher(propNameValue[0]).matches()) {
            return String.valueOf(this.formatMainMessage(line)) + " " + SVNUIMessages.Verifier_MultiLineProperty_InvalidNameChar;
        }
        if (property.indexOf("=") != -1) {
            if (propNameValue.length == 1 || propNameValue[1].length() == 0) {
                return String.valueOf(this.formatMainMessage(line)) + " " + SVNUIMessages.Verifier_MultiLineProperty_EmptyValue;
            }
            if (propNameValue[1].indexOf(";") != -1) {
                return String.valueOf(this.formatMainMessage(line)) + " " + SVNUIMessages.Verifier_MultiLineProperty_InvalidValueChar;
            }
        }
        return null;
    }

    protected String formatMainMessage(int line) {
        return BaseMessages.format((String)ERROR_MESSAGE_INVALID_FORMAT, (Object[])new Object[]{"$FIELD_NAME$", String.valueOf(line + 1)});
    }
}

