/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.facet.queries.parametric;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.infra.query.ModelQueryParameter;
import org.eclipse.emf.facet.infra.query.QueryFactory;
import org.eclipse.emf.facet.infra.query.core.AbstractModelQuery;
import org.eclipse.emf.facet.infra.query.core.AbstractModelQueryWithEditingDomain;
import org.eclipse.emf.facet.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryException;
import org.eclipse.emf.facet.infra.query.runtime.ModelQueryContext;
import org.eclipse.emf.facet.infra.query.runtime.ModelQueryParameterValue;
import org.eclipse.emf.facet.infra.query.runtime.RuntimeFactory;
import org.eclipse.papyrus.infra.emf.facet.queries.parametricquery.Argument;
import org.eclipse.papyrus.infra.emf.facet.queries.parametricquery.EStructuralFeatureArgument;
import org.eclipse.papyrus.infra.emf.facet.queries.parametricquery.ParametricQuery;
import org.eclipse.papyrus.infra.emf.facet.queries.parametricquery.StringArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetParametricQuery
extends AbstractModelQueryWithEditingDomain {
    protected ParametricQuery parametricModelQuery;

    public FacetParametricQuery(ParametricQuery modelQuery) {
        super((ModelQuery)modelQuery);
        this.parametricModelQuery = modelQuery;
    }

    public Object basicEvaluate(EObject context, List<ModelQueryParameterValue> parameterValues) throws ModelQueryException {
        ModelQuery calledQuery = this.parametricModelQuery.getCalledQuery();
        EList<Argument> arguments = this.parametricModelQuery.getArguments();
        ModelQuerySetCatalog querySetCatalog = ModelQuerySetCatalog.getSingleton();
        if (calledQuery != null) {
            AbstractModelQuery modelQueryImpl = querySetCatalog.getModelQueryImpl(calledQuery);
            ModelQueryContext modelQueryContext = RuntimeFactory.eINSTANCE.createModelQueryContext();
            modelQueryContext.getSelectedModelElements().add((Object)context);
            List<ModelQueryParameterValue> calledParameterValues = this.getParameterValues(calledQuery, (List<Argument>)arguments);
            if (parameterValues != null && !parameterValues.isEmpty()) {
                calledParameterValues.addAll(parameterValues);
            }
            return modelQueryImpl.basicEvaluate(context, calledParameterValues);
        }
        return Collections.emptyList();
    }

    private List<ModelQueryParameterValue> getParameterValues(ModelQuery calledQuery, List<Argument> arguments) {
        LinkedList<ModelQueryParameterValue> result = new LinkedList<ModelQueryParameterValue>();
        for (Argument argument : arguments) {
            ModelQueryParameterValue parameterValue = RuntimeFactory.eINSTANCE.createModelQueryParameterValue();
            ModelQueryParameter modelQueryParameter = QueryFactory.eINSTANCE.createModelQueryParameter();
            String value = null;
            String name = argument.getArgumentName();
            if (argument instanceof StringArgument) {
                value = ((StringArgument)argument).getValue();
            } else if (argument instanceof EStructuralFeatureArgument) {
                value = ((EStructuralFeatureArgument)argument).getValue();
            }
            modelQueryParameter.setName(name);
            parameterValue.setParameter(modelQueryParameter);
            parameterValue.setValue((Object)value);
            result.add(parameterValue);
        }
        return result;
    }

    public Object basicEvaluate(EObject context, List<ModelQueryParameterValue> parameterValues, EditingDomain editingDomain) throws ModelQueryException {
        ModelQuery calledQuery = this.parametricModelQuery.getCalledQuery();
        EList<Argument> arguments = this.parametricModelQuery.getArguments();
        ModelQuerySetCatalog querySetCatalog = ModelQuerySetCatalog.getSingleton();
        if (calledQuery != null) {
            AbstractModelQuery modelQueryImpl = querySetCatalog.getModelQueryImpl(calledQuery);
            if (!(modelQueryImpl instanceof AbstractModelQueryWithEditingDomain)) {
                return this.basicEvaluate(context, parameterValues);
            }
            ModelQueryContext modelQueryContext = RuntimeFactory.eINSTANCE.createModelQueryContext();
            modelQueryContext.getSelectedModelElements().add((Object)context);
            List<ModelQueryParameterValue> calledParameterValues = this.getParameterValues(calledQuery, (List<Argument>)arguments);
            if (parameterValues != null && !parameterValues.isEmpty()) {
                calledParameterValues.addAll(parameterValues);
            }
            return ((AbstractModelQueryWithEditingDomain)modelQueryImpl).basicEvaluate(context, calledParameterValues, editingDomain);
        }
        return Collections.emptyList();
    }
}

