/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.validation;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.uml2.uml.util.UMLValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EValidatorAdapter
extends UMLValidator {
    private final IBatchValidator batchValidator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);

    public EValidatorAdapter() {
        this.batchValidator.setIncludeLiveConstraints(true);
        this.batchValidator.setReportSuccesses(false);
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(eObject.eClass(), eObject, diagnostics, context);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        super.validate(eClass, eObject, diagnostics, context);
        IStatus status = Status.OK_STATUS;
        if (diagnostics != null && !this.hasProcessed(eObject, context)) {
            status = this.batchValidator.validate(eObject, (IProgressMonitor)new NullProgressMonitor());
            this.processed(eObject, context, status);
            this.appendDiagnostics(status, diagnostics);
        }
        return status.isOK();
    }

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return super.validate(eDataType, value, diagnostics, context);
    }

    private void processed(EObject eObject, Map<Object, Object> context, IStatus status) {
        if (context != null) {
            context.put(eObject, status);
        }
    }

    private boolean hasProcessed(EObject eObject, Map<Object, Object> context) {
        boolean result = false;
        if (context != null) {
            while (eObject != null) {
                if (context.containsKey(eObject)) {
                    result = true;
                    eObject = null;
                    continue;
                }
                eObject = eObject.eContainer();
            }
        }
        return result;
    }

    private void appendDiagnostics(IStatus status, DiagnosticChain diagnostics) {
        if (status.isMultiStatus()) {
            IStatus[] children;
            IStatus[] iStatusArray = children = status.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus element = iStatusArray[n2];
                this.appendDiagnostics(element, diagnostics);
                ++n2;
            }
        } else if (status instanceof IConstraintStatus) {
            IConstraintStatus constraintStatus = (IConstraintStatus)status;
            diagnostics.add((Diagnostic)new BasicDiagnostic(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), this.toArray(constraintStatus.getResultLocus(), constraintStatus.getTarget())));
        }
    }

    private Object[] toArray(Collection<?> elements, Object first) {
        Object[] result;
        if (!elements.contains(first)) {
            result = new Object[elements.size() + 1];
            result[0] = first;
            System.arraycopy(elements.toArray(), 0, result, 1, elements.size());
        } else {
            Iterator<?> iter = elements.iterator();
            Object actualFirst = iter.next();
            if (actualFirst == first) {
                result = elements.toArray();
            } else {
                result = new Object[elements.size()];
                result[0] = first;
                result[1] = actualFirst;
                boolean skipped = false;
                int i = 2;
                while (iter.hasNext()) {
                    Object next = iter.next();
                    if (next == first && !skipped) {
                        skipped = true;
                        --i;
                    } else {
                        result[i] = next;
                    }
                    ++i;
                }
            }
        }
        return result;
    }
}

