/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.actions;

import java.util.Collections;
import java.util.List;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.emf.diffmerge.ui.ComparisonContextManager;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.actions.ComparisonSetup;
import org.eclipse.emf.diffmerge.ui.actions.ComparisonSetupWizard;
import org.eclipse.emf.diffmerge.ui.actions.EMFDiffMergeEditorInput;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonSpecification;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareModelsAction
implements IObjectActionDelegate {
    private IStructuredSelection _selection = null;
    private Shell _shell = null;

    protected List<Object> getSelection() {
        List<Object> result = this._selection == null ? Collections.emptyList() : Collections.unmodifiableList(this._selection.toList());
        return result;
    }

    protected Shell getShell() {
        return this._shell;
    }

    protected boolean isApplicable() {
        List<Object> allSelected = this.getSelection();
        int size = allSelected.size();
        if (size != 2 && size != 3) {
            return false;
        }
        ComparisonContextManager manager = EMFDiffMergeUIPlugin.getDefault().getContextManager();
        for (Object selected : allSelected) {
            if (manager.isValidEntrypoint(selected)) continue;
            return false;
        }
        return true;
    }

    public void run(IAction action_p) {
        List<Object> allSelected = this.getSelection();
        int size = allSelected.size();
        if (size == 2 || size == 3) {
            ComparisonContextManager manager = EMFDiffMergeUIPlugin.getDefault().getContextManager();
            ComparisonSetup setup = manager.createComparisonSetup(allSelected.get(0), allSelected.get(1), size == 3 ? allSelected.get(2) : null);
            if (setup != null) {
                IComparisonSpecification specification;
                ComparisonSetupWizard wizard = new ComparisonSetupWizard(setup);
                WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
                dialog.setHelpAvailable(false);
                if (dialog.open() == 0 && (specification = setup.getComparisonSpecification()) != null) {
                    EMFDiffMergeEditorInput input = new EMFDiffMergeEditorInput(specification);
                    CompareUI.openCompareEditor((CompareEditorInput)input);
                }
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)EMFDiffMergeUIPlugin.LABEL, (String)Messages.CompareModelsAction_ModelsOnly);
            }
        }
    }

    public void selectionChanged(IAction action_p, ISelection selection_p) {
        this._selection = selection_p instanceof IStructuredSelection ? (IStructuredSelection)selection_p : null;
        if (action_p != null) {
            action_p.setEnabled(this.isApplicable());
        }
    }

    public void setActivePart(IAction action_p, IWorkbenchPart targetPart_p) {
        if (targetPart_p != null && targetPart_p.getSite() != null) {
            this._shell = targetPart_p.getSite().getShell();
        }
    }
}

