/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.xwt.jface;

import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.papyrus.xwt.IIndexedElement;
import org.eclipse.papyrus.xwt.XWT;
import org.eclipse.papyrus.xwt.XWTException;
import org.eclipse.papyrus.xwt.jface.CellEditorHelper;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboBoxCellEditor
extends org.eclipse.jface.viewers.ComboBoxCellEditor
implements IIndexedElement {
    protected CellEditorHelper cellEditorHelper;

    public ComboBoxCellEditor() {
    }

    public ComboBoxCellEditor(Composite parent, String[] items, int style) {
        super(parent, items, style);
    }

    public ComboBoxCellEditor(Composite parent, String[] items) {
        super(parent, items);
    }

    protected void doSetValue(Object value) {
        if (value != null) {
            IConverter converter;
            Class<?> targetType = this.getTargetType();
            if (targetType != String.class && (converter = XWT.findConvertor(targetType, String.class)) != null) {
                value = converter.convert(value);
            }
            String[] items = this.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].equals(value)) {
                    super.doSetValue((Object)i);
                    return;
                }
                ++i;
            }
        }
        super.doSetValue((Object)-1);
    }

    protected Object doGetValue() {
        IConverter converter;
        Object value = super.doGetValue();
        String[] items = this.getItems();
        int selected = (Integer)value;
        if (selected < 0) {
            return null;
        }
        String selectedString = items[selected];
        Class<?> targetType = this.getTargetType();
        if (targetType != String.class && (converter = XWT.findConvertor(String.class, targetType)) != null) {
            return converter.convert(value);
        }
        return selectedString;
    }

    protected Class<?> getTargetType() {
        if (this.cellEditorHelper != null) {
            return this.cellEditorHelper.getTargetType();
        }
        return Object.class;
    }

    @Override
    public void setIndex(Object parent, int index) {
        if (!(parent instanceof TableViewer)) {
            throw new XWTException("TableView is expected, not \"" + parent.getClass().getName() + "\"");
        }
        this.cellEditorHelper = new CellEditorHelper((TableViewer)parent, index);
    }
}

