/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.compare;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.compare.structuremergeviewer.StructureDiffViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.internal.reviews.ui.compare.FileItemNode;
import org.eclipse.mylyn.internal.reviews.ui.compare.ReviewCompareAnnotationSupport;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public abstract class ReviewItemCompareEditorInput
extends CompareEditorInput {
    final ReviewBehavior behavior;

    public ReviewItemCompareEditorInput(CompareConfiguration configuration, ReviewBehavior behavior) {
        super(configuration);
        this.behavior = behavior;
    }

    public Viewer findStructureViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        Viewer structureViewer = super.findStructureViewer(oldViewer, input, parent);
        if (structureViewer instanceof StructureDiffViewer) {
            StructureDiffViewer diffViewer = (StructureDiffViewer)structureViewer;
            diffViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof ITypedElement) {
                        return ((ITypedElement)element).getName();
                    }
                    return "<no name>";
                }

                public Image getImage(Object element) {
                    if (element instanceof IDiffElement) {
                        IDiffElement input = (IDiffElement)element;
                        int kind = input.getKind();
                        if (kind == 1) {
                            kind = 2;
                        } else if (kind == 2) {
                            kind = 1;
                        }
                        return ReviewItemCompareEditorInput.this.getCompareConfiguration().getImage(input.getImage(), kind);
                    }
                    return null;
                }
            });
        }
        return structureViewer;
    }

    public Viewer findContentViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        Viewer contentViewer = super.findContentViewer(oldViewer, input, parent);
        if (input instanceof FileItemNode && ((FileItemNode)input).getFileItem() != null) {
            ReviewCompareAnnotationSupport support = ReviewCompareAnnotationSupport.getAnnotationSupport(contentViewer);
            support.setReviewItem(((FileItemNode)input).getFileItem(), this.behavior);
        }
        return contentViewer;
    }
}

