/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class ProgressDialog
extends TitleAreaDialog {
    private boolean lockedUI = false;
    private Composite pageContainer;
    private Cursor waitCursor;
    private ProgressMonitorPart progressMonitorPart;
    private long activeRunningOperations = 0L;
    private final HashMap<Integer, Button> buttons = new HashMap();

    public ProgressDialog(Shell parentShell) {
        super(parentShell);
        ProgressDialog.setDialogHelpAvailable((boolean)false);
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.pageContainer = new Composite(composite, 0);
        this.pageContainer.setLayout((Layout)new FillLayout());
        GridData gd = new GridData(1808);
        this.pageContainer.setLayoutData((Object)gd);
        this.pageContainer.setFont(parent.getFont());
        this.createPageControls(this.pageContainer);
        GridLayout pmlayout = new GridLayout();
        pmlayout.numColumns = 1;
        this.progressMonitorPart = this.createProgressMonitorPart(composite, pmlayout);
        GridData gridData = new GridData(768);
        this.progressMonitorPart.setLayoutData((Object)gridData);
        this.progressMonitorPart.setVisible(true);
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
        ProgressDialog.applyDialogFont((Control)this.progressMonitorPart);
        return composite;
    }

    protected abstract Control createPageControls(Composite var1);

    protected Collection<? extends Control> getDisableableControls() {
        return this.buttons.values();
    }

    private void aboutToStart(boolean enableCancelButton) {
        if (this.getShell() != null) {
            Control focusControl = this.getShell().getDisplay().getFocusControl();
            if (focusControl != null && focusControl.getShell() != this.getShell()) {
                focusControl = null;
            }
            Display d = this.getShell().getDisplay();
            this.waitCursor = new Cursor((Device)d, 1);
            this.setDisplayCursor(this.waitCursor);
            for (Control control : this.getDisableableControls()) {
                control.setEnabled(false);
            }
            this.progressMonitorPart.setVisible(true);
        }
    }

    private void stopped(Object savedState) {
        if (this.getShell() != null) {
            this.progressMonitorPart.setVisible(false);
            this.setDisplayCursor(null);
            this.waitCursor.dispose();
            this.waitCursor = null;
            for (Control control : this.getDisableableControls()) {
                control.setEnabled(true);
            }
        }
    }

    protected ProgressMonitorPart createProgressMonitorPart(Composite composite, GridLayout pmlayout) {
        return new ProgressMonitorPart(composite, (Layout)pmlayout, -1){
            private String currentTask;
            {
                this.currentTask = null;
            }

            public void setBlocked(IStatus reason) {
                super.setBlocked(reason);
                if (!ProgressDialog.this.lockedUI) {
                    ProgressDialog.getBlockedHandler().showBlocked(this.getShell(), (IProgressMonitor)this, reason, this.currentTask);
                }
            }

            public void clearBlocked() {
                super.clearBlocked();
                if (!ProgressDialog.this.lockedUI) {
                    ProgressDialog.getBlockedHandler().clearBlocked();
                }
            }

            public void beginTask(String name, int totalWork) {
                super.beginTask(name, totalWork);
                this.currentTask = name;
            }

            public void setTaskName(String name) {
                super.setTaskName(name);
                this.currentTask = name;
            }

            public void subTask(String name) {
                super.subTask(name);
                if (this.currentTask == null) {
                    this.currentTask = name;
                }
            }
        };
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        Object state = null;
        if (this.activeRunningOperations == 0L) {
            this.aboutToStart(fork && cancelable);
        }
        ++this.activeRunningOperations;
        try {
            if (!fork) {
                this.lockedUI = true;
            }
            ModalContext.run((IRunnableWithProgress)runnable, (boolean)fork, (IProgressMonitor)this.getProgressMonitor(), (Display)this.getShell().getDisplay());
            this.lockedUI = false;
        }
        finally {
            --this.activeRunningOperations;
            if (this.activeRunningOperations <= 0L) {
                this.stopped(state);
            }
        }
    }

    protected IProgressMonitor getProgressMonitor() {
        return this.progressMonitorPart;
    }

    private void setDisplayCursor(Cursor c) {
        Shell[] shells;
        Shell[] shellArray = shells = this.getShell().getDisplay().getShells();
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell element = shellArray[n2];
            element.setCursor(c);
            ++n2;
        }
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Shell shell;
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)new Integer(id));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProgressDialog.this.buttonPressed((Integer)event.widget.getData());
            }
        });
        if (defaultButton && (shell = parent.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        this.buttons.put(new Integer(id), button);
        this.setButtonLayoutData(button);
        return button;
    }
}

