/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.table.widget.celleditors.composite;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.celleditors.AbstractCellEditorComposite;
import org.eclipse.emf.facet.widgets.celleditors.internal.Activator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnumComposite<T>
extends AbstractCellEditorComposite<T> {
    private Combo combo = null;
    private final Composite parentControl;
    private T lastValue;

    public EnumComposite(Composite parent) {
        super(parent);
        this.setLayout((Layout)new FillLayout());
        this.parentControl = parent;
        this.combo = new Combo((Composite)this, 0);
        final Listener clickListener = new Listener(){

            public void handleEvent(Event event) {
                Control control;
                if (event.widget instanceof Control && (control = (Control)event.widget).getShell() == EnumComposite.this.getParentControl().getShell() && event.widget != EnumComposite.this.getCombo()) {
                    EnumComposite.this.commit();
                }
            }
        };
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnumComposite.this.fireChanged();
            }
        });
        this.combo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 && event.stateMask == 0 || event.keyCode == 0x1000050 && event.stateMask == 0) {
                    EnumComposite.this.commit();
                } else if (event.keyCode == 27 && event.stateMask == 0) {
                    EnumComposite.this.close();
                }
            }
        });
        Display.getDefault().addFilter(3, clickListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Display.getDefault().removeFilter(3, clickListener);
            }
        });
        this.combo.forceFocus();
    }

    protected void commit() {
        this.fireCommit();
    }

    public void setValue(T value) {
        this.lastValue = value;
        if (value == null) {
            this.combo.setText("");
        } else {
            String strValue = this.getEnumString(value);
            this.combo.setText(strValue);
        }
    }

    public T getValue() {
        try {
            this.lastValue = this.getEnumValue(this.combo.getText());
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        return this.lastValue;
    }

    protected abstract T getEnumValue(String var1);

    protected abstract String getEnumString(T var1);

    protected abstract String[] getEnumStrings();

    public Combo getCombo() {
        return this.combo;
    }

    protected Composite getParentControl() {
        return this.parentControl;
    }
}

