/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.common.figure;

import java.util.ArrayList;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.papyrus.uml.diagram.common.draw2d.InteractionFigure;
import org.eclipse.papyrus.uml.diagram.common.draw2d.LeftToolbarLayout;
import org.eclipse.papyrus.uml.diagram.common.figure.node.AutomaticCompartmentLayoutManager;
import org.eclipse.papyrus.uml.diagram.common.figure.node.NodeNamedElementFigure;

public class SysMLDiagramFrameFigure
extends NodeNamedElementFigure {
    private WrappingLabel frameLabel;
    private RectangleFigure frameLabelContainerFigure;
    private RectangleFigure structureCompartmentFigure;

    public SysMLDiagramFrameFigure() {
        this.createContents();
    }

    protected void createContents() {
        this.add((IFigure)this.createInteractionFigureHeader());
        this.add(this.createStructureCompartmentFigures());
        this.setLayoutManager((LayoutManager)new SysMLLayoutLayoutManager());
    }

    protected RectangleFigure createInteractionFigureHeader() {
        if (this.frameLabel == null) {
            this.frameLabel = new WrappingLabel(){

                public Dimension getPreferredSize(int wHint, int hHint) {
                    Dimension preferredSize = super.getPreferredSize(wHint, hHint);
                    if (preferredSize.width == 0) {
                        return preferredSize;
                    }
                    return new Dimension(preferredSize.width + 2, preferredSize.height + 2);
                }
            };
        }
        InteractionFigure interactionFigure = new InteractionFigure();
        interactionFigure.setBorder((Border)new MarginBorder(3, 3, 3, 3));
        interactionFigure.setLayoutManager((LayoutManager)new LeftToolbarLayout());
        interactionFigure.add((IFigure)this.frameLabel);
        this.frameLabelContainerFigure = new RectangleFigure();
        this.frameLabelContainerFigure.setOutline(false);
        this.frameLabelContainerFigure.setFill(false);
        this.frameLabelContainerFigure.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        this.frameLabelContainerFigure.add((IFigure)interactionFigure, 0);
        return this.frameLabelContainerFigure;
    }

    public WrappingLabel getNameLabel() {
        if (this.frameLabel == null) {
            this.createInteractionFigureHeader();
        }
        return this.frameLabel;
    }

    public RectangleFigure getLabelContainer() {
        return this.frameLabelContainerFigure;
    }

    public IFigure getStructureCompartmentFigure() {
        if (this.structureCompartmentFigure == null) {
            this.createStructureCompartmentFigures();
        }
        return this.structureCompartmentFigure;
    }

    public IFigure createStructureCompartmentFigures() {
        this.structureCompartmentFigure = new RectangleFigure();
        this.structureCompartmentFigure.setFill(false);
        this.structureCompartmentFigure.setOutline(false);
        return this.structureCompartmentFigure;
    }

    private class SysMLLayoutLayoutManager
    extends AutomaticCompartmentLayoutManager {
        private SysMLLayoutLayoutManager() {
        }

        public void layout(IFigure container) {
            ArrayList<IFigure> figuresToRemove = new ArrayList<IFigure>();
            int i = 0;
            while (i < container.getChildren().size()) {
                IFigure currentCompartment = (IFigure)container.getChildren().get(i);
                if (currentCompartment == SysMLDiagramFrameFigure.this.structureCompartmentFigure) {
                    Rectangle bound = new Rectangle(currentCompartment.getBounds());
                    currentCompartment.invalidate();
                    Dimension pref = currentCompartment.getPreferredSize();
                    currentCompartment.invalidate();
                    Dimension prefConstraint = currentCompartment.getPreferredSize(container.getBounds().width - 40, -1);
                    if (pref.width < prefConstraint.width) {
                        bound.setSize(pref);
                    } else {
                        bound.setSize(prefConstraint);
                    }
                    int offset = 24;
                    bound.x = container.getBounds().x + 10;
                    bound.y = container.getBounds().y + offset;
                    bound.width = container.getBounds().width - 20;
                    bound.height = container.getBounds().height - offset - 10;
                    currentCompartment.setBounds(bound);
                } else if (currentCompartment == SysMLDiagramFrameFigure.this.frameLabelContainerFigure) {
                    Rectangle boundLabel = new Rectangle(SysMLDiagramFrameFigure.this.frameLabelContainerFigure.getBounds());
                    boundLabel.setSize(SysMLDiagramFrameFigure.this.frameLabelContainerFigure.getPreferredSize());
                    SysMLDiagramFrameFigure.this.frameLabelContainerFigure.setBounds(boundLabel);
                } else {
                    figuresToRemove.add(currentCompartment);
                }
                ++i;
            }
            for (IFigure iFigure : figuresToRemove) {
                container.getChildren().remove(iFigure);
            }
        }
    }
}

