/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.edit.part;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IAdvancedEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IPopupEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.ui.ExtendedDirectEditionDialog;
import org.eclipse.papyrus.extensionpoints.editors.ui.ILabelEditorDialog;
import org.eclipse.papyrus.extensionpoints.editors.ui.IPopupEditorHelper;
import org.eclipse.papyrus.uml.diagram.common.edit.part.AbstractElementNodeLabelEditPart;
import org.eclipse.papyrus.uml.tools.utils.ValueSpecificationUtil;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.ValueSpecification;

public class ConstraintNodeLabelEditPart
extends AbstractElementNodeLabelEditPart {
    protected static final String LEFT_BRACE = "{";
    protected static final String RIGHT_BRACE = "}";

    public ConstraintNodeLabelEditPart(View view) {
        super(view);
    }

    public String getLabelRole() {
        return "Label";
    }

    public String getIconPathRole() {
        return "";
    }

    protected void refreshVisuals() {
        EObject resolveSemanticElement;
        super.refreshVisuals();
        IFigure figure = this.getFigure();
        if (figure instanceof WrappingLabel && (resolveSemanticElement = this.resolveSemanticElement()) instanceof Constraint) {
            String specificationValue = ValueSpecificationUtil.getSpecificationValue((ValueSpecification)((Constraint)resolveSemanticElement).getSpecification());
            specificationValue = specificationValue == null ? "" : specificationValue;
            ((WrappingLabel)figure).setText(LEFT_BRACE + specificationValue + RIGHT_BRACE);
        }
    }

    protected void handleNotificationEvent(Notification event) {
        this.refresh();
    }

    protected void performDirectEditRequest(Request request) {
        final Request theRequest = request;
        if (this.directEditionMode == 0) {
            this.directEditionMode = this.getDirectEditionType();
        }
        switch (this.directEditionMode) {
            case 8: {
                return;
            }
            case 4: {
                this.updateExtendedEditorConfiguration();
                if (this.configuration == null || this.configuration.getLanguage() == null) {
                    this.performDefaultDirectEditorEdit(theRequest);
                    break;
                }
                this.configuration.preEditAction((Object)this.resolveSemanticElement());
                Dialog dialog = null;
                if (this.configuration instanceof IPopupEditorConfiguration) {
                    IPopupEditorHelper helper = ((IPopupEditorConfiguration)this.configuration).createPopupEditorHelper((Object)this);
                    helper.showEditor();
                    return;
                }
                if (this.configuration instanceof IAdvancedEditorConfiguration) {
                    dialog = ((IAdvancedEditorConfiguration)this.configuration).createDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.resolveSemanticElement(), this.configuration.getTextToEdit((Object)this.resolveSemanticElement()));
                } else if (this.configuration instanceof IDirectEditorConfiguration) {
                    dialog = new ExtendedDirectEditionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Object)this.resolveSemanticElement(), this.configuration.getTextToEdit((Object)this.resolveSemanticElement()), this.configuration);
                } else {
                    return;
                }
                final Dialog finalDialog = dialog;
                if (dialog.open() != 0) break;
                TransactionalEditingDomain domain = this.getEditingDomain();
                RecordingCommand command = new RecordingCommand(domain, "Edit Label"){

                    protected void doExecute() {
                        ConstraintNodeLabelEditPart.this.configuration.postEditAction((Object)ConstraintNodeLabelEditPart.this.resolveSemanticElement(), ((ILabelEditorDialog)finalDialog).getValue());
                    }
                };
                domain.getCommandStack().execute((Command)command);
                break;
            }
            case 2: {
                try {
                    this.getEditingDomain().runExclusive(new Runnable(){

                        public void run() {
                            if (ConstraintNodeLabelEditPart.this.isActive() && ConstraintNodeLabelEditPart.this.isEditable()) {
                                if (theRequest.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                                    Character initialChar = (Character)theRequest.getExtendedData().get("directedit_extendeddata_initial_char");
                                    ConstraintNodeLabelEditPart.this.performDirectEdit(initialChar.charValue());
                                } else if (theRequest instanceof DirectEditRequest && ConstraintNodeLabelEditPart.this.getEditText().equals(ConstraintNodeLabelEditPart.this.getLabelText())) {
                                    DirectEditRequest editRequest = (DirectEditRequest)theRequest;
                                    ConstraintNodeLabelEditPart.this.performDirectEdit(editRequest.getLocation());
                                } else {
                                    ConstraintNodeLabelEditPart.this.performDirectEdit();
                                }
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
    }

    private void performDirectEdit(char initialCharacter) {
        if (this.getManager() instanceof TextDirectEditManager) {
            ((TextDirectEditManager)this.getManager()).show(initialCharacter);
        } else {
            this.performDirectEdit();
        }
    }

    protected void performDirectEdit(Point eventLocation) {
        if (this.getManager() instanceof TextDirectEditManager) {
            ((TextDirectEditManager)this.getManager()).show(eventLocation.getSWTPoint());
        }
    }
}

