/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.papyrus.gmf.diagram.common.parser.IMaskManagedSemanticParser;
import org.eclipse.papyrus.uml.tools.utils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiplicityElementLabelParser
implements IMaskManagedSemanticParser {
    protected static final String MULTIPLICITY_FORMAT = "[%s..%s]";
    protected static final String MULTIPLICITY_FORMAT_ALT = "[%s]";

    public String getEditString(IAdaptable element, int flags) {
        return this.getPrintString(element, flags);
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.UNEDITABLE_STATUS;
    }

    public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
        return UnexecutableCommand.INSTANCE;
    }

    public String getPrintString(IAdaptable element, int flags) {
        if (flags == 0) {
            return "<empty label>";
        }
        String result = "";
        EObject eObject = (EObject)element.getAdapter(EObject.class);
        if (eObject != null && eObject instanceof MultiplicityElement) {
            MultiplicityElement multElt = (MultiplicityElement)eObject;
            if ((flags & 0x20) == 32) {
                String upper;
                String lower = multElt.getLowerValue() != null ? ValueSpecificationUtil.getSpecificationValue((ValueSpecification)multElt.getLowerValue()) : "1";
                String string = upper = multElt.getLowerValue() != null ? ValueSpecificationUtil.getSpecificationValue((ValueSpecification)multElt.getUpperValue()) : "1";
                if ((flags & 0x100000) == 0x100000 || !"1".equals(lower) || !"1".equals(upper)) {
                    result = lower.equals(upper) ? String.format(MULTIPLICITY_FORMAT_ALT, lower, upper) : String.format(MULTIPLICITY_FORMAT, lower, upper);
                }
            }
        }
        return result;
    }

    public boolean isAffectingEvent(Object event, int flags) {
        Object feature;
        if (event instanceof Notification && (feature = ((Notification)event).getFeature()) instanceof EStructuralFeature) {
            return EcorePackage.eINSTANCE.getEAnnotation_Details().equals(feature) || UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue().equals(feature) || UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue().equals(feature);
        }
        return false;
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }

    public List<EObject> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<EObject> semanticElementsBeingParsed = new ArrayList<EObject>();
        if (element != null && element instanceof MultiplicityElement) {
            MultiplicityElement semElement = (MultiplicityElement)element;
            semanticElementsBeingParsed.add((EObject)semElement);
            if (semElement.getLowerValue() != null) {
                semanticElementsBeingParsed.add((EObject)semElement.getLowerValue());
            }
            if (semElement.getUpperValue() != null) {
                semanticElementsBeingParsed.add((EObject)semElement.getUpperValue());
            }
        }
        return semanticElementsBeingParsed;
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        return true;
    }

    @Override
    public Map<Integer, String> getMasks() {
        HashMap<Integer, String> masks = new HashMap<Integer, String>(2);
        masks.put(32, "Multiplicity");
        masks.put(0x100000, "Show default multiplicity");
        return masks;
    }
}

