/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.collection;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractSimpleUnaryOperation;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.RealValue;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.library.numeric.NumericMaxOperation;

public class CollectionMaxOperation
extends AbstractSimpleUnaryOperation {
    @NonNull
    public static final CollectionMaxOperation INSTANCE = new CollectionMaxOperation();

    @Deprecated
    @NonNull
    public Object evaluate(@NonNull DomainEvaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        return this.evaluate(sourceValue);
    }

    @NonNull
    public Object evaluate(@Nullable Object sourceVal) {
        CollectionValue collectionValue = CollectionMaxOperation.asCollectionValue((Object)sourceVal);
        RealValue result = null;
        for (Object element : collectionValue.iterable()) {
            if (result == null) {
                result = (RealValue)element;
                continue;
            }
            if (element == null) continue;
            result = NumericMaxOperation.INSTANCE.evaluate(result, element);
        }
        if (result == null) {
            throw new InvalidValueException(EvaluatorMessages.EmptyCollection, new Object[]{collectionValue.getKind(), "max"});
        }
        return result;
    }
}

