/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.ecore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.library.ecore.EcoreIdResolver;
import org.eclipse.ocl.examples.library.executor.ExecutorManager;
import org.eclipse.ocl.examples.library.executor.ExecutorStandardLibrary;
import org.eclipse.ocl.examples.library.executor.LazyModelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreExecutorManager
extends ExecutorManager {
    @Nullable
    private final Object contextObject;
    private DomainModelManager modelManager = null;
    private IdResolver idResolver = null;

    public EcoreExecutorManager(@Nullable Object contextObject, @NonNull ExecutorStandardLibrary standardLibrary) {
        super((DomainStandardLibrary)standardLibrary);
        this.contextObject = contextObject;
    }

    @Deprecated
    public EcoreExecutorManager(@Nullable Object contextObject, @Nullable Map<Object, Object> contextMap, @NonNull ExecutorStandardLibrary standardLibrary) {
        this(contextObject, standardLibrary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected IdResolver createIdResolver() {
        ResourceSet resourceSet;
        if (!(this.contextObject instanceof EObject)) {
            List emptyList = Collections.emptyList();
            return new EcoreIdResolver(emptyList, (ExecutorStandardLibrary)this.standardLibrary);
        }
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)((EObject)this.contextObject));
        Resource resource = rootContainer.eResource();
        Object notifier = resource != null ? ((resourceSet = resource.getResourceSet()) != null ? resourceSet : resource) : rootContainer;
        EObject eObject = notifier;
        synchronized (eObject) {
            DomainPackage root;
            EList eAdapters = notifier.eAdapters();
            for (Adapter adapter : eAdapters) {
                if (!(adapter instanceof EcoreIdResolver)) continue;
                return (EcoreIdResolver)adapter;
            }
            Object roots = null;
            if (resource != null) {
                ResourceSet resourceSet2 = resource.getResourceSet();
                if (resourceSet2 != null) {
                    roots = new ArrayList();
                    for (Resource r : resourceSet2.getResources()) {
                        roots.addAll(r.getContents());
                    }
                } else {
                    roots = resource.getContents();
                }
            }
            if ((root = this.standardLibrary.getOclAnyType().getPackage()) instanceof EObject) {
                if (roots == null) {
                    roots = new ArrayList();
                }
                roots.add((EObject)root);
            }
            if (roots == null) {
                roots = Collections.singletonList(rootContainer);
            }
            assert (roots != null);
            EcoreIdResolver adapter = new EcoreIdResolver((Collection<? extends EObject>)roots, (ExecutorStandardLibrary)this.standardLibrary);
            eAdapters.add((Object)adapter);
            return adapter;
        }
    }

    @NonNull
    public DomainEvaluator createNestedEvaluator() {
        return new EcoreExecutorManager(this.contextObject, (ExecutorStandardLibrary)this.standardLibrary);
    }

    @Override
    @NonNull
    public DomainType getDynamicTypeOf(@Nullable Object value) {
        IdResolver idResolver2 = this.idResolver;
        if (idResolver2 == null) {
            this.idResolver = idResolver2 = this.createIdResolver();
        }
        return idResolver2.getDynamicTypeOf(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public DomainModelManager getModelManager() {
        DomainModelManager modelManager2 = this.modelManager;
        if (modelManager2 == null) {
            EcoreExecutorManager ecoreExecutorManager = this;
            synchronized (ecoreExecutorManager) {
                modelManager2 = this.modelManager;
                if (modelManager2 == null) {
                    modelManager2 = this.contextObject instanceof EObject ? new LazyModelManager((EObject)this.contextObject){

                        protected boolean isInstance(@NonNull DomainType type, @NonNull EObject element) {
                            EClass eClass = (EClass)DomainUtil.nonNullEMF((Object)element.eClass());
                            DomainType elementType = EcoreExecutorManager.this.idResolver.getType((EClassifier)eClass);
                            return elementType.conformsTo(EcoreExecutorManager.this.standardLibrary, type);
                        }
                    } : DomainModelManager.NULL;
                    this.modelManager = modelManager2;
                }
            }
        }
        return modelManager2;
    }

    @NonNull
    public IdResolver getIdResolver() {
        IdResolver idResolver2 = this.idResolver;
        if (idResolver2 == null) {
            this.idResolver = idResolver2 = this.createIdResolver();
        }
        return idResolver2;
    }

    @Override
    @NonNull
    public DomainType getStaticTypeOf(@Nullable Object value) {
        IdResolver idResolver2 = this.idResolver;
        if (idResolver2 == null) {
            this.idResolver = idResolver2 = this.createIdResolver();
        }
        return idResolver2.getStaticTypeOf(value);
    }

    @Override
    @NonNull
    public DomainType getStaticTypeOf(@Nullable Object value, Object ... values) {
        IdResolver idResolver2 = this.idResolver;
        if (idResolver2 == null) {
            this.idResolver = idResolver2 = this.createIdResolver();
        }
        return idResolver2.getStaticTypeOf(value, values);
    }

    @Override
    @NonNull
    public DomainType getStaticTypeOf(@Nullable Object value, @NonNull Iterable<?> values) {
        IdResolver idResolver2 = this.idResolver;
        if (idResolver2 == null) {
            this.idResolver = idResolver2 = this.createIdResolver();
        }
        return idResolver2.getStaticTypeOf(value, values);
    }
}

