/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.ecore;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.elements.DomainTypeParameters;
import org.eclipse.ocl.examples.domain.ids.BuiltInTypeId;
import org.eclipse.ocl.examples.domain.ids.IdManager;
import org.eclipse.ocl.examples.domain.ids.PackageId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.library.ecore.EcoreExecutorPackage;
import org.eclipse.ocl.examples.library.executor.ExecutorFragment;
import org.eclipse.ocl.examples.library.executor.ExecutorPackage;
import org.eclipse.ocl.examples.library.executor.ExecutorType;
import org.eclipse.ocl.examples.library.executor.ExecutorTypeParameter;

public class EcoreExecutorType
extends ExecutorType {
    @Nullable
    protected EClassifier eClassifier;
    @Nullable
    private TypeId typeId = null;

    public EcoreExecutorType(@NonNull String name, @NonNull ExecutorPackage evaluationPackage, int flags, ExecutorTypeParameter ... typeParameters) {
        super(name, evaluationPackage, flags, typeParameters);
        this.eClassifier = null;
    }

    public EcoreExecutorType(@NonNull BuiltInTypeId typeId, @NonNull ExecutorPackage evaluationPackage, int flags, ExecutorTypeParameter ... typeParameters) {
        super(typeId.getName(), evaluationPackage, flags, typeParameters);
        this.eClassifier = null;
        this.typeId = typeId;
    }

    public EcoreExecutorType(EClassifier eClassifier, @NonNull EcoreExecutorPackage evaluationPackage, int flags, ExecutorTypeParameter ... typeParameters) {
        super((String)DomainUtil.nonNullModel((Object)eClassifier.getName()), evaluationPackage, flags, typeParameters);
        this.eClassifier = eClassifier;
    }

    @NonNull
    public Object createInstance() {
        EClassifier eClassifier2 = this.eClassifier;
        if (eClassifier2 instanceof EClass) {
            EClass eClass = (EClass)eClassifier2;
            EObject element = eClass.getEPackage().getEFactoryInstance().create(eClass);
            return DomainUtil.nonNullEMF((Object)element);
        }
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Object createInstance(@NonNull String value) {
        EClassifier eClassifier2 = this.eClassifier;
        if (eClassifier2 instanceof EDataType) {
            EDataType eDataType = (EDataType)eClassifier2;
            Object element = eDataType.getEPackage().getEFactoryInstance().createFromString(eDataType, value);
            return DomainUtil.nonNullEMF((Object)element);
        }
        throw new UnsupportedOperationException();
    }

    public final EClassifier getEClassifier() {
        return this.eClassifier;
    }

    @NonNull
    public String getMetaTypeName() {
        if (this.eClassifier != null) {
            return (String)DomainUtil.nonNullModel((Object)((EClassifier)DomainUtil.nonNullState((Object)this.eClassifier)).getName());
        }
        return this.getTypeId().getMetaTypeName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public TypeId getTypeId() {
        Object typeId2 = this.typeId;
        if (typeId2 == null) {
            EcoreExecutorType ecoreExecutorType = this;
            synchronized (ecoreExecutorType) {
                typeId2 = this.typeId;
                if (typeId2 == null) {
                    EClassifier eClassifier2 = this.eClassifier;
                    if (eClassifier2 != null) {
                        typeId2 = IdManager.getTypeId((EClassifier)eClassifier2);
                    } else if ("Metaclass".equals(this.name)) {
                        typeId2 = TypeId.METACLASS;
                    } else {
                        PackageId packageTypeId = IdManager.getPackageId((DomainPackage)this.evaluationPackage);
                        DomainTypeParameters typeParameters = this.getTypeParameters();
                        typeId2 = this.eClassifier instanceof EDataType ? packageTypeId.getDataTypeId(this.name, typeParameters.parametersSize()) : packageTypeId.getClassId(this.name, typeParameters.parametersSize());
                    }
                    this.typeId = typeId2;
                }
            }
        }
        return typeId2;
    }

    @NonNull
    public EcoreExecutorType initFragments(@NonNull ExecutorFragment[] fragments, int[] depthCounts, EClassifier eClassifier) {
        assert (eClassifier != null);
        assert (this.eClassifier == null);
        assert (this.name.equals(eClassifier.getName()));
        this.eClassifier = (EClassifier)DomainUtil.nonNullState((Object)eClassifier);
        this.initFragments(fragments, depthCounts);
        return this;
    }
}

