/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.executor;

import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainIterationManager;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractIterationManager;
import org.eclipse.ocl.examples.domain.library.LibraryBinaryOperation;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;

public class ExecutorSingleIterationManager
extends AbstractIterationManager {
    @NonNull
    protected final CollectionValue collectionValue;
    @NonNull
    protected final TypeId returnTypeId;
    @NonNull
    protected final LibraryBinaryOperation body;
    @Nullable
    private Object accumulatorValue;
    @NonNull
    protected final Iterator<? extends Object> iteratorValue;
    private Object currentValue;

    @Deprecated
    public ExecutorSingleIterationManager(@NonNull DomainEvaluator evaluator, @NonNull DomainType returnType, @NonNull LibraryBinaryOperation body, @Nullable CollectionValue value, @Nullable Object accumulatorValue) {
        this(evaluator, returnType.getTypeId(), body, value, accumulatorValue);
    }

    public ExecutorSingleIterationManager(@NonNull DomainEvaluator evaluator, @NonNull TypeId returnTypeId, @NonNull LibraryBinaryOperation body, @Nullable CollectionValue value, @Nullable Object accumulatorValue) {
        super(evaluator);
        this.collectionValue = ValuesUtil.asCollectionValue((Object)value);
        this.returnTypeId = returnTypeId;
        this.body = body;
        this.updateAccumulator(accumulatorValue);
        this.iteratorValue = this.collectionValue.iterator();
        this.advanceIterators();
    }

    protected ExecutorSingleIterationManager(@NonNull ExecutorSingleIterationManager iterationManager, @NonNull CollectionValue collectionValue) {
        super(iterationManager.getEvaluator());
        this.collectionValue = collectionValue;
        this.returnTypeId = iterationManager.returnTypeId;
        this.body = iterationManager.body;
        this.accumulatorValue = iterationManager.accumulatorValue;
        this.iteratorValue = collectionValue.iterator();
        this.advanceIterators();
    }

    public boolean advanceIterators() {
        Object object = this.currentValue = this.iteratorValue.hasNext() ? this.iteratorValue.next() : this.iteratorValue;
        return this.currentValue != this.iteratorValue;
    }

    @NonNull
    public DomainIterationManager createNestedIterationManager(@NonNull CollectionValue value) {
        return new Nested(this, value);
    }

    @Nullable
    public Object evaluateBody() {
        return this.body.evaluate(this.evaluator, this.returnTypeId, this.accumulatorValue, this.get());
    }

    @Nullable
    public Object get() {
        return this.currentValue;
    }

    @Nullable
    public Object getAccumulatorValue() {
        return this.accumulatorValue;
    }

    public int getDepth() {
        return 0;
    }

    @NonNull
    public ExecutorSingleIterationManager getRootIterationManager() {
        return this;
    }

    @NonNull
    public CollectionValue getSourceCollection() {
        return this.collectionValue;
    }

    public boolean hasCurrent() {
        return this.currentValue != this.iteratorValue;
    }

    public boolean isOuterIteration() {
        return true;
    }

    @Nullable
    public Object updateAccumulator(Object newValue) {
        this.accumulatorValue = newValue;
        return null;
    }

    class Nested
    extends ExecutorSingleIterationManager {
        @NonNull
        protected final ExecutorSingleIterationManager rootIterationManager;
        protected final int depth;

        protected Nested(@NonNull ExecutorSingleIterationManager iterationManager, CollectionValue value) {
            super(iterationManager, value);
            this.rootIterationManager = iterationManager.getRootIterationManager();
            this.depth = iterationManager.getDepth() + 1;
        }

        public int getDepth() {
            return this.depth;
        }

        @NonNull
        public ExecutorSingleIterationManager getRootIterationManager() {
            return this.rootIterationManager;
        }

        @NonNull
        public CollectionValue getSourceCollection() {
            return this.rootIterationManager.getSourceCollection();
        }

        public boolean isOuterIteration() {
            return false;
        }
    }
}

