/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.executor;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.LibraryFeature;
import org.eclipse.ocl.examples.domain.types.AbstractType;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaType
extends AbstractType {
    @NonNull
    protected final Class<?> javaClass;

    public JavaType(@NonNull DomainStandardLibrary standardLibrary, @NonNull Class<?> javaClass) {
        super(standardLibrary, (String)DomainUtil.nonNullState((Object)javaClass.getName()));
        this.javaClass = javaClass;
    }

    public boolean conformsTo(@NonNull DomainStandardLibrary standardLibrary, @NonNull DomainType thatType) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public DomainType getCommonType(@NonNull IdResolver idResolver, @NonNull DomainType type) {
        if (this == type) {
            return this;
        }
        if (!(type instanceof JavaType)) {
            return idResolver.getStandardLibrary().getOclAnyType();
        }
        Class<?> commonClass = JavaType.getCommonClass1(this.javaClass, ((JavaType)type).javaClass);
        if (commonClass != null) {
            return idResolver.getJavaType(commonClass);
        }
        return idResolver.getStandardLibrary().getOclAnyType();
    }

    @Nullable
    private static Class<?> getCommonClass1(@NonNull Class<?> thisClass, @NonNull Class<?> thatClass) {
        Class<?> commonClass = JavaType.getCommonClass2(thisClass, thatClass);
        if (commonClass != null) {
            return commonClass;
        }
        Class<?> superclass = thisClass.getSuperclass();
        if (superclass != null && (commonClass = JavaType.getCommonClass1(superclass, thatClass)) != null) {
            return commonClass;
        }
        Class<?>[] classArray = thisClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> superInterface = classArray[n2];
            if (superInterface != null && (commonClass = JavaType.getCommonClass1(superInterface, thatClass)) != null) {
                return commonClass;
            }
            ++n2;
        }
        return null;
    }

    @Nullable
    private static Class<?> getCommonClass2(@NonNull Class<?> thisClass, @NonNull Class<?> thatClass) {
        Class<?> commonClass;
        if (thisClass == thatClass) {
            return thisClass;
        }
        Class<?> superclass = thatClass.getSuperclass();
        if (superclass != null && (commonClass = JavaType.getCommonClass2(thisClass, superclass)) != null) {
            return commonClass;
        }
        Class<?>[] classArray = thatClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> commonClass2;
            Class<?> superInterface = classArray[n2];
            if (superInterface != null && (commonClass2 = JavaType.getCommonClass2(thisClass, superInterface)) != null) {
                return commonClass2;
            }
            ++n2;
        }
        return null;
    }

    @NonNull
    public DomainInheritance getInheritance(@NonNull DomainStandardLibrary standardLibrary) {
        if (Comparable.class.isAssignableFrom(this.javaClass)) {
            return standardLibrary.getOclComparableType().getInheritance(standardLibrary);
        }
        return standardLibrary.getOclAnyType().getInheritance(standardLibrary);
    }

    @NonNull
    public TypeId getTypeId() {
        throw new UnsupportedOperationException();
    }

    public boolean isEqualTo(@NonNull DomainStandardLibrary standardLibrary, @NonNull DomainType thatType) {
        return this == thatType;
    }

    @NonNull
    public LibraryFeature lookupImplementation(@NonNull DomainStandardLibrary standardLibrary, @NonNull DomainOperation staticOperation) {
        DomainInheritance inheritance = standardLibrary.getInheritance(standardLibrary.getOclAnyType());
        return inheritance.lookupImplementation(standardLibrary, staticOperation);
    }

    public String toString() {
        return this.getName();
    }
}

