/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.iterator;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainIterationManager;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractIteration;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;

public class OnlyIteration
extends AbstractIteration {
    @NonNull
    public static final OnlyIteration INSTANCE = new OnlyIteration();

    @NonNull
    public Object createAccumulatorValue(@NonNull DomainEvaluator evaluator, @NonNull TypeId accumulatorTypeId, @NonNull TypeId bodyTypeId) {
        return new MutableObject();
    }

    @NonNull
    protected Object resolveTerminalValue(@NonNull DomainIterationManager iterationManager) {
        MutableObject accumulatorValue = (MutableObject)iterationManager.getAccumulatorValue();
        assert (accumulatorValue != null);
        Object object = accumulatorValue.get();
        if (object != null) {
            return object;
        }
        throw new InvalidValueException("No matching content for 'only'", new Object[0]);
    }

    @Nullable
    protected Object updateAccumulator(@NonNull DomainIterationManager iterationManager) {
        Object bodyVal = iterationManager.evaluateBody();
        if (bodyVal == null) {
            throw new InvalidValueException(EvaluatorMessages.UndefinedBody, new Object[]{"only"});
        }
        if (bodyVal == Boolean.FALSE) {
            return CARRY_ON;
        }
        MutableObject accumulatorValue = (MutableObject)iterationManager.getAccumulatorValue();
        assert (accumulatorValue != null);
        Object object = accumulatorValue.get();
        if (object != null) {
            throw new InvalidValueException("Multiple matching content for 'only'", new Object[0]);
        }
        Object value = iterationManager.get();
        accumulatorValue.set(value);
        return CARRY_ON;
    }

    public static class MutableObject {
        private Object value = null;

        public Object get() {
            return this.value;
        }

        public void set(Object value) {
            this.value = value;
        }
    }
}

