/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.string;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractSimpleTernaryOperation;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;

public class StringSubstringOperation
extends AbstractSimpleTernaryOperation {
    @NonNull
    public static final StringSubstringOperation INSTANCE = new StringSubstringOperation();

    @Deprecated
    @NonNull
    public String evaluate(@NonNull DomainEvaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue, @Nullable Object firstArgumentValue, @Nullable Object secondArgumentValue) {
        return this.evaluate(sourceValue, firstArgumentValue, secondArgumentValue);
    }

    @NonNull
    public String evaluate(@Nullable Object sourceValue, @Nullable Object firstArgumentValue, @Nullable Object secondArgumentValue) {
        String sourceString = StringSubstringOperation.asString((Object)sourceValue);
        Integer startInteger = StringSubstringOperation.asInteger((Object)firstArgumentValue);
        Integer endInteger = StringSubstringOperation.asInteger((Object)secondArgumentValue);
        int size = sourceString.length();
        int lower = startInteger;
        int upper = endInteger;
        if (lower > 0 && lower <= upper && upper <= size) {
            String result = sourceString.substring(lower - 1, upper);
            return result;
        }
        throw new InvalidValueException(DomainUtil.bind((String)EvaluatorMessages.IndexesOutOfRange, (Object[])new Object[]{lower, upper, size}), new Object[0]);
    }
}

