/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.ui.internal.wizards.pages;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.efacet.ui.internal.Messages;
import org.eclipse.emf.facet.efacet.ui.internal.widget.MetamodelSelectionControl;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.FilteredList;

public class SelectEPackageWizardPage
extends WizardPage {
    private MetamodelSelectionControl metamodelSelectionControl;
    private final EditingDomain editingDomain;

    public SelectEPackageWizardPage(EditingDomain editingDomain) {
        super("Whatever");
        this.setTitle(Messages.Select_EPackage);
        this.editingDomain = editingDomain;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.metamodelSelectionControl.getFilterText().setFocus();
            this.setPageComplete(true);
        }
    }

    public void createControl(Composite parent) {
        this.metamodelSelectionControl = new MetamodelSelectionControl(parent);
        this.metamodelSelectionControl.setLayoutData(new GridData(1808));
        final FilteredList filteredList = this.metamodelSelectionControl.getFilteredList();
        filteredList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item != null) {
                    SelectEPackageWizardPage.this.setPageComplete(filteredList.getSelection().length == 1);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (SelectEPackageWizardPage.this.getWizard().canFinish()) {
                    SelectEPackageWizardPage.this.getWizard().performFinish();
                }
                if (SelectEPackageWizardPage.this.getNextPage() != null) {
                    SelectEPackageWizardPage.this.goToNextPage();
                }
            }
        });
        filteredList.setSelection(new int[0]);
        this.setPageComplete(false);
        this.setControl((Control)this.metamodelSelectionControl);
    }

    protected void goToNextPage() {
        this.getContainer().showPage(this.getNextPage());
    }

    public EPackage getFirstSelectedEPackage() {
        Object result;
        if (this.metamodelSelectionControl.getSelectedElements() != null && EPackage.Registry.INSTANCE.containsKey((Object)(result = this.metamodelSelectionControl.getSelectedElements()[0]).toString())) {
            return EPackage.Registry.INSTANCE.getEPackage(result.toString());
        }
        return null;
    }

    public void loadSelectedMetamodel() {
        Object[] results = this.metamodelSelectionControl.getSelectedElements();
        if (results != null) {
            ResourceSet resourceSet = this.editingDomain.getResourceSet();
            Object[] objectArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                Object result = objectArray[n2];
                URI uri = URI.createURI((String)result.toString());
                Resource r = resourceSet.getResource(uri, true);
                if (!resourceSet.getResources().contains((Object)r)) {
                    EPackage.Registry packageRegistry = resourceSet.getPackageRegistry();
                    for (EObject eObject : r.getContents()) {
                        if (!(eObject instanceof EPackage)) continue;
                        EPackage ePackage = (EPackage)eObject;
                        packageRegistry.put((Object)ePackage.getNsURI(), (Object)ePackage);
                    }
                    resourceSet.getResources().add((Object)r);
                }
                ++n2;
            }
        }
    }
}

