/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.services.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.EditorLifecycleEventListener;
import org.eclipse.papyrus.infra.core.services.EditorLifecycleManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.services.internal.InternalEditorLifecycleManager;

public class EditorLifecycleManagerImpl
implements EditorLifecycleManager,
InternalEditorLifecycleManager {
    private final Set<EditorLifecycleEventListener> listeners = new HashSet<EditorLifecycleEventListener>();

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
    }

    public void startService() throws ServiceException {
    }

    public void disposeService() throws ServiceException {
        this.listeners.clear();
    }

    public void addEditorLifecycleEventsListener(EditorLifecycleEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeEditorLifecycleEventsListener(EditorLifecycleEventListener listener) {
        this.listeners.remove(listener);
    }

    public void firePostInit(final IMultiDiagramEditor editor) {
        for (final EditorLifecycleEventListener listener : this.listeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.postInit(editor);
                }

                public void handleException(Throwable exception) {
                }
            });
        }
    }

    public void firePostDisplay(final IMultiDiagramEditor editor) {
        for (final EditorLifecycleEventListener listener : this.listeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.postDisplay(editor);
                }

                public void handleException(Throwable exception) {
                }
            });
        }
    }

    public void fireBeforeClose(final IMultiDiagramEditor editor) {
        for (final EditorLifecycleEventListener listener : this.listeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.beforeClose(editor);
                }

                public void handleException(Throwable exception) {
                }
            });
        }
    }
}

