/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.services.internal;

import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.core.services.BadStateException;
import org.eclipse.papyrus.infra.core.services.ServiceDescriptor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServiceState;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceTypeEntry {
    protected ServiceState state = ServiceState.registered;
    protected ServiceDescriptor serviceDescriptor;

    public ServiceTypeEntry(ServiceDescriptor serviceDescriptor) {
        this.serviceDescriptor = serviceDescriptor;
    }

    protected void setState(ServiceState newState) {
        this.state = newState;
    }

    public ServiceState getState() {
        return this.state;
    }

    protected void checkState(ServiceState expectedState) throws BadStateException {
        if (expectedState != this.state) {
            throw new BadStateException(expectedState, this.state, this.serviceDescriptor);
        }
    }

    public ServiceDescriptor getDescriptor() {
        return this.serviceDescriptor;
    }

    protected Object instanciateService() throws ServiceException {
        String serviceClassname = this.serviceDescriptor.getServiceClassname();
        Class<?> classname = this.loadClass();
        try {
            return classname.newInstance();
        }
        catch (SecurityException e) {
            throw new ServiceException("Can't instanciate '" + serviceClassname + "' with zero args.", e);
        }
        catch (IllegalArgumentException e) {
            throw new ServiceException("Can't instanciate '" + serviceClassname + "' with zero args.", e);
        }
        catch (InstantiationException e) {
            throw new ServiceException("Can't instanciate '" + serviceClassname + "' with zero args.", e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("Can't instanciate '" + serviceClassname + "' with zero args.", e);
        }
    }

    private Class<?> loadClass() throws ServiceException {
        Class serviceClass;
        String serviceClassname = this.serviceDescriptor.getServiceClassname();
        try {
            serviceClass = Class.forName(serviceClassname);
        }
        catch (ClassNotFoundException e1) {
            try {
                String bundleID = this.serviceDescriptor.getClassBundleID();
                Bundle bundle = Platform.getBundle((String)bundleID);
                serviceClass = bundle.loadClass(serviceClassname);
            }
            catch (ClassNotFoundException e2) {
                throw new ServiceException("Can't find class for the name '" + serviceClassname + "'.", e2);
            }
        }
        return serviceClass;
    }

    public boolean isStarted() {
        return this.state == ServiceState.started;
    }

    public abstract Object getServiceInstance() throws ServiceException;

    public abstract void createService() throws ServiceException;

    public abstract void initService(ServicesRegistry var1) throws ServiceException;

    public abstract void startService() throws ServiceException;

    public abstract void disposeService() throws ServiceException;
}

