/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.oclinecore;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.DependencyVisitor;
import org.eclipse.ocl.examples.codegen.cgmodel.CGClass;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstantExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstraint;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNamedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGPackage;
import org.eclipse.ocl.examples.codegen.cgmodel.CGProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.java.CG2JavaPreVisitor;
import org.eclipse.ocl.examples.codegen.java.CG2JavaVisitor;
import org.eclipse.ocl.examples.codegen.java.JavaCodeGenerator;
import org.eclipse.ocl.examples.codegen.java.JavaDependencyVisitor;
import org.eclipse.ocl.examples.codegen.oclinecore.OCLinEcoreGlobalContext;
import org.eclipse.ocl.examples.codegen.oclinecore.OCLinEcoreLocalContext;
import org.eclipse.ocl.examples.codegen.oclinecore.OCLinEcorePivot2CGVisitor;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.Feature;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.util.Visitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLinEcoreCG2JavaVisitor
extends CG2JavaVisitor {
    @NonNull
    protected final GenPackage genPackage;
    @NonNull
    protected final CGPackage cgPackage;
    protected ExpressionInOCL expInOcl;
    protected Feature feature;

    public OCLinEcoreCG2JavaVisitor(@NonNull JavaCodeGenerator codeGenerator, @NonNull GenPackage genPackage) {
        super(codeGenerator);
        this.genPackage = genPackage;
        MetaModelManager metaModelManager = codeGenerator.getMetaModelManager();
        EPackage ecorePackage = genPackage.getEcorePackage();
        Package pivotPackage = (Package)metaModelManager.getPivotOfEcore(Package.class, (EObject)ecorePackage);
        assert (pivotPackage != null);
        OCLinEcorePivot2CGVisitor pivot2CGVisitor = new OCLinEcorePivot2CGVisitor(this.analyzer, this.getGlobalContext());
        this.cgPackage = (CGPackage)DomainUtil.nonNullState((Object)((CGNamedElement)pivotPackage.accept((Visitor)pivot2CGVisitor)));
        XMIResourceImpl resource = new XMIResourceImpl(URI.createURI((String)"cg.xmi"));
        resource.getContents().add((Object)this.cgPackage);
        this.analyzer.analyze(this.cgPackage);
    }

    @Override
    protected void appendGlobalPrefix() {
        this.js.append(this.getGlobalContext().getTablesClassName());
        this.js.append(".");
    }

    @NonNull
    public CGPackage generate() {
        this.js.resetStream();
        CG2JavaPreVisitor cg2PreVisitor = ((JavaCodeGenerator)this.context).createCG2JavaPreVisitor();
        this.cgPackage.accept(cg2PreVisitor);
        return this.cgPackage;
    }

    @NonNull
    public Map<String, String> generateBodies() {
        HashMap<String, String> bodies = new HashMap<String, String>();
        for (CGClass cgClass : this.cgPackage.getClasses()) {
            String fragmentURI;
            String bodyText;
            String returnClassName;
            CGValuedElement cgBody;
            for (CGConstraint cgConstraint : cgClass.getInvariants()) {
                cgBody = cgConstraint.getBody();
                NamedElement pivotClass = cgClass.getPivot();
                NamedElement pivotElement = cgConstraint.getPivot();
                if (cgBody == null || !(pivotClass instanceof Type) || !(pivotElement instanceof Constraint)) continue;
                Constraint pivotConstraint = (Constraint)pivotElement;
                this.localContext = this.globalContext.getLocalContext(cgConstraint);
                String bodyText2 = this.generateValidatorBody(cgBody, pivotConstraint, (Type)pivotClass);
                String fragmentURI2 = String.valueOf(this.getFragmentURI((Element)pivotClass)) + "==" + this.getRuleName(pivotConstraint);
                bodies.put(fragmentURI2, bodyText2);
            }
            for (CGOperation cgOperation : cgClass.getOperations()) {
                cgBody = cgOperation.getBody();
                NamedElement pivotOperation = cgOperation.getPivot();
                if (cgBody == null || !(pivotOperation instanceof Operation)) continue;
                returnClassName = this.genModelHelper.getOperationReturnType((Operation)pivotOperation);
                this.localContext = this.globalContext.getLocalContext(cgOperation);
                bodyText = this.generateBody(cgBody, returnClassName);
                fragmentURI = this.getFragmentURI((Element)pivotOperation);
                bodies.put(fragmentURI, bodyText);
            }
            for (CGProperty cgProperty : cgClass.getProperties()) {
                cgBody = cgProperty.getBody();
                NamedElement pivotProperty = cgProperty.getPivot();
                if (cgBody == null || !(pivotProperty instanceof Property)) continue;
                returnClassName = this.genModelHelper.getPropertyResultType((Property)pivotProperty);
                this.localContext = this.globalContext.getLocalContext(cgProperty);
                bodyText = this.generateBody(cgBody, returnClassName);
                fragmentURI = this.getFragmentURI((Element)pivotProperty);
                bodies.put(fragmentURI, bodyText);
            }
        }
        this.localContext = null;
        return bodies;
    }

    @NonNull
    public String generateBody(@NonNull CGValuedElement cgBody, @NonNull String returnClassName) {
        this.js.resetStream();
        this.js.appendCommentWithOCL(null, (Element)cgBody.getPivot());
        this.js.appendCastParameters(this.localContext);
        JavaDependencyVisitor dependencyVisitor = new JavaDependencyVisitor(this.localContext);
        dependencyVisitor.visit(cgBody);
        dependencyVisitor.visitAll(this.localContext.getLocalVariables());
        Iterable<CGValuedElement> sortedDependencies = dependencyVisitor.getSortedDependencies();
        for (CGValuedElement cgElement : sortedDependencies) {
            if (cgElement.isInlineable() || !cgElement.isConstant() || cgElement.isGlobal()) continue;
            cgElement.accept(this);
        }
        this.js.appendLocalStatements(cgBody);
        if (cgBody.isInvalid()) {
            this.js.append("throw ");
            this.js.appendValueName(cgBody);
        } else {
            this.js.append("return ");
            this.js.appendEcoreValue(returnClassName, cgBody);
        }
        this.js.append(";");
        return this.toString();
    }

    @NonNull
    public String generateConstants() {
        this.js.resetStream();
        this.js.pushIndentation(null);
        DependencyVisitor dependencyVisitor = ((JavaCodeGenerator)this.context).createDependencyVisitor();
        dependencyVisitor.visitAll(this.globalContext.getGlobals());
        Iterable<CGValuedElement> sortedDependencies = dependencyVisitor.getSortedDependencies();
        this.generateGlobals(sortedDependencies);
        return this.toString();
    }

    @NonNull
    public String generateValidatorBody(@NonNull CGValuedElement cgBody, @NonNull Constraint pivotConstraint, @NonNull Type pivotType) {
        String genClassifierName;
        this.js.resetStream();
        String constraintName = pivotConstraint.getName();
        GenClassifier genClassifier = this.genModelHelper.getGenClassifier(pivotType);
        String string = genClassifierName = genClassifier != null ? genClassifier.getName() : null;
        if (genClassifierName == null) {
            genClassifierName = "";
        }
        String constraintLiteralName = String.valueOf(CodeGenUtil.upperName((String)genClassifierName)) + "__" + CodeGenUtil.upperName((String)(constraintName != null ? constraintName : ""));
        String validatorClass = this.genModelHelper.getQualifiedValidatorClassName(this.genPackage);
        this.js.appendCommentWithOCL(null, (Element)pivotConstraint);
        this.js.appendCastParameters(this.localContext);
        DependencyVisitor dependencyVisitor = ((JavaCodeGenerator)this.context).createDependencyVisitor(this.localContext);
        dependencyVisitor.visit(cgBody);
        dependencyVisitor.visitAll(this.localContext.getLocalVariables());
        Iterable<CGValuedElement> sortedDependencies = dependencyVisitor.getSortedDependencies();
        for (CGValuedElement cgElement : sortedDependencies) {
            if (cgElement.isInlineable() || !cgElement.isConstant() || cgElement.isGlobal()) continue;
            cgElement.accept(this);
        }
        this.js.appendLocalStatements(cgBody);
        this.js.append("if (");
        this.js.appendValueName(cgBody);
        this.js.append(" == ");
        this.js.appendClassReference(ValuesUtil.class);
        this.js.append(".TRUE_VALUE) {\n");
        this.js.pushIndentation(null);
        this.js.append("return true;\n");
        this.js.popIndentation();
        this.js.append("}\n");
        this.js.append("if (diagnostics != null) {\n");
        this.js.pushIndentation(null);
        this.js.append("int ");
        this.js.append(this.getLocalContext().getSeverityName());
        this.js.append(" = ");
        if (cgBody.isNull()) {
            this.js.appendClassReference(Diagnostic.class);
            this.js.append(".ERROR : ");
        } else if (cgBody.isNonNull()) {
            this.js.appendClassReference(Diagnostic.class);
            this.js.append(".WARNING;\n");
        } else {
            this.js.appendValueName(cgBody);
            this.js.append(" == null ? ");
            this.js.appendClassReference(Diagnostic.class);
            this.js.append(".ERROR : ");
            this.js.appendClassReference(Diagnostic.class);
            this.js.append(".WARNING;\n");
        }
        this.js.appendClassReference(String.class);
        this.js.append(" " + this.getLocalContext().getMessageName() + " = ");
        this.js.appendClassReference(NLS.class);
        this.js.append(".bind(");
        this.js.appendClassReference(EvaluatorMessages.class);
        this.js.append(".ValidationConstraintIsNotSatisfied_ERROR_, new Object[]{\"");
        this.js.append(genClassifierName);
        this.js.append("\", \"");
        this.js.append(constraintName != null ? constraintName : "UnnamedConstraint");
        this.js.append("\", ");
        this.js.appendClassReference(EObjectValidator.class);
        this.js.append(".getObjectLabel(this, context)});\n");
        this.js.append("diagnostics.add(new ");
        this.js.appendClassReference(BasicDiagnostic.class);
        this.js.append("(" + this.getLocalContext().getSeverityName() + ", ");
        this.js.appendClassReference(validatorClass);
        this.js.append(".DIAGNOSTIC_SOURCE, ");
        this.js.appendClassReference(validatorClass);
        this.js.append("." + constraintLiteralName + ", " + this.getLocalContext().getMessageName() + ", new Object [] { this }));\n");
        this.js.popIndentation();
        this.js.append("}\n");
        this.js.append("return false;");
        return this.toString();
    }

    protected String getFragmentURI(@NonNull Element element) {
        return EcoreUtil.getURI((EObject)element).fragment().toString();
    }

    @NonNull
    protected OCLinEcoreGlobalContext getGlobalContext() {
        return (OCLinEcoreGlobalContext)this.globalContext;
    }

    @NonNull
    protected OCLinEcoreLocalContext getLocalContext() {
        return (OCLinEcoreLocalContext)this.localContext;
    }

    protected String getRuleName(@NonNull Constraint constraint) {
        String name = constraint.getName();
        return name != null ? name : "";
    }

    @Override
    @Nullable
    public Object visitCGClass(@NonNull CGClass cgClass) {
        return null;
    }

    @Override
    @Nullable
    public Object visitCGConstantExp(@NonNull CGConstantExp cgConstantExp) {
        CGValuedElement globalConstant = cgConstantExp.getReferredConstant();
        if (globalConstant != null) {
            this.appendGlobalPrefix();
            this.js.appendValueName(globalConstant);
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGOperation(@NonNull CGOperation cgOperation) {
        return null;
    }

    @Override
    @Nullable
    public Object visitCGPackage(@NonNull CGPackage cgPackage) {
        return null;
    }
}

