/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.oclinjunit;

import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.java.ImportUtils;
import org.eclipse.ocl.examples.codegen.java.JavaCodeGenerator;
import org.eclipse.ocl.examples.codegen.oclinjunit.JUnitCG2JavaClassVisitor;
import org.eclipse.ocl.examples.codegen.oclinjunit.JUnitGlobalContext;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;

public class JUnitCodeGenerator
extends JavaCodeGenerator {
    @NonNull
    protected final CodeGenAnalyzer cgAnalyzer;
    @NonNull
    protected final ExpressionInOCL expInOcl;

    public JUnitCodeGenerator(@NonNull MetaModelManager metaModelManager, @NonNull ExpressionInOCL expInOcl, boolean useNullAnnotations) {
        super(metaModelManager);
        this.getOptions().setUseNullAnnotations(useNullAnnotations);
        this.cgAnalyzer = new CodeGenAnalyzer(this);
        this.expInOcl = expInOcl;
    }

    @NonNull
    public String generateClassFile(String packageName, String className) {
        JUnitCG2JavaClassVisitor generator = JUnitCG2JavaClassVisitor.generate(this, this.expInOcl, packageName, className);
        Set<String> allImports = generator.getAllImports();
        Map<String, String> long2ShortImportNames = ImportUtils.getLong2ShortImportNames(allImports);
        return ImportUtils.resolveImports(generator.toString(), long2ShortImportNames);
    }

    @NonNull
    protected JUnitGlobalContext createGlobalContext() {
        return new JUnitGlobalContext(this);
    }

    @NonNull
    public CodeGenAnalyzer getAnalyzer() {
        return this.cgAnalyzer;
    }
}

