/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.indexing;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.internal.compiler.SourceElementParser;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.core.BasicCompilationUnit;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.Logger;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchDocument;
import org.eclipse.wst.jsdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.wst.jsdt.internal.core.search.indexing.SourceIndexerRequestor;
import org.eclipse.wst.jsdt.internal.oaametadata.LibraryAPIs;
import org.eclipse.wst.jsdt.internal.oaametadata.MetadataReader;
import org.eclipse.wst.jsdt.internal.oaametadata.MetadataSourceElementNotifier;

public class SourceIndexer
extends AbstractIndexer
implements SuffixConstants {
    public SourceIndexer(SearchDocument document) {
        super(document);
    }

    public void indexDocument() {
        SourceIndexerRequestor requestor = new SourceIndexerRequestor(this);
        String documentPath = this.document.getPath();
        SourceElementParser parser = this.document.parser;
        if (parser == null) {
            Path path = new Path(documentPath);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
            parser = JavaModelManager.getJavaModelManager().indexManager.getSourceElementParser(JavaScriptCore.create(project), requestor);
        } else {
            parser.setRequestor(requestor);
        }
        char[] source = null;
        char[] name = null;
        try {
            source = this.document.getCharContents();
            name = documentPath.toCharArray();
        }
        catch (Exception exception) {}
        if (source == null || name == null) {
            return;
        }
        String pkgName = ((JavaSearchDocument)this.document).getPackageName();
        char[][] packageName = null;
        if (pkgName != null) {
            packageName = new char[][]{pkgName.toCharArray()};
        }
        BasicCompilationUnit compilationUnit = new BasicCompilationUnit(source, packageName, new String(name));
        try {
            parser.parseCompilationUnit(compilationUnit, true);
        }
        catch (Exception e) {
            Logger.logException("Error while indexing document", e);
        }
    }

    public void indexMetadata() {
        SourceIndexerRequestor requestor = new SourceIndexerRequestor(this);
        String documentPath = this.document.getPath();
        char[] source = null;
        char[] name = null;
        try {
            source = this.document.getCharContents();
            name = documentPath.toCharArray();
        }
        catch (Exception exception) {}
        if (source == null || name == null) {
            return;
        }
        String pkgName = ((JavaSearchDocument)this.document).getPackageName();
        char[][] packageName = null;
        if (pkgName != null) {
            packageName = new char[][]{pkgName.toCharArray()};
        }
        LibraryAPIs apis = MetadataReader.readAPIsFromString(new String(source), documentPath);
        new MetadataSourceElementNotifier(apis, requestor).notifyRequestor();
    }

    /*
     * Exception decompiling
     */
    public void indexArchive() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 213->217)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

