/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.InferredMethod;
import org.eclipse.wst.jsdt.core.search.MethodDeclarationMatch;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.ImportReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryType;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleSet;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.search.BasicSearchEngine;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.wst.jsdt.internal.core.search.matching.DeclarationOfReferencedMethodsPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.wst.jsdt.internal.core.search.matching.MethodPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.PatternLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.SuperTypeNamesCollector;
import org.eclipse.wst.jsdt.internal.core.util.QualificationHelpers;

public class MethodLocator
extends PatternLocator {
    protected MethodPattern pattern;
    protected boolean isDeclarationOfReferencedMethodsPattern;
    public char[][][] allSuperDeclaringTypeNames;
    private HashMap methodDeclarationsWithInvalidParam = new HashMap();

    public MethodLocator(MethodPattern pattern) {
        super(pattern);
        this.pattern = pattern;
        this.isDeclarationOfReferencedMethodsPattern = this.pattern instanceof DeclarationOfReferencedMethodsPattern;
    }

    protected void clear() {
        this.methodDeclarationsWithInvalidParam = new HashMap();
    }

    public void initializePolymorphicSearch(MatchLocator locator) {
        long start = 0L;
        if (BasicSearchEngine.VERBOSE) {
            start = System.currentTimeMillis();
        }
        try {
            this.allSuperDeclaringTypeNames = new SuperTypeNamesCollector(this.pattern, this.pattern.getDeclaringSimpleName(), this.pattern.getDeclaringQualification(), locator, null, locator.progressMonitor).collect();
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        if (BasicSearchEngine.VERBOSE) {
            System.out.println("Time to initialize polymorphic search: " + (System.currentTimeMillis() - start));
        }
    }

    private boolean isTypeInSuperDeclaringTypeNames(char[][] typeName) {
        if (this.allSuperDeclaringTypeNames == null) {
            return false;
        }
        int length = this.allSuperDeclaringTypeNames.length;
        int i = 0;
        while (i < length) {
            if (CharOperation.equals(this.allSuperDeclaringTypeNames[i], typeName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isVirtualInvoke(MethodBinding method, MessageSend messageSend) {
        return !method.isStatic() && !method.isPrivate() && !messageSend.isSuperAccess();
    }

    public int match(ASTNode node, MatchingNodeSet nodeSet) {
        int declarationsLevel = 0;
        return nodeSet.addMatch(node, declarationsLevel);
    }

    public int match(MethodDeclaration node, MatchingNodeSet nodeSet) {
        if (!this.pattern.findDeclarations) {
            return 0;
        }
        if (node.isInferred()) {
            return 0;
        }
        if (!this.matchesName(this.pattern.selector, node.getName())) {
            return 0;
        }
        boolean resolve = this.pattern.mustResolve;
        if (this.pattern.parameterSimpleNames != null) {
            int argsLength;
            int length = this.pattern.parameterSimpleNames.length;
            Argument[] args = node.arguments;
            int n = argsLength = args == null ? 0 : args.length;
            if (length != argsLength) {
                return 0;
            }
            int i = 0;
            while (i < argsLength) {
                if (args != null && !this.matchesTypeReference(this.pattern.parameterSimpleNames[i], args[i].type)) {
                    if (this.mayBeGeneric) {
                        if (!this.pattern.mustResolve) {
                            nodeSet.mustResolve = true;
                            resolve = true;
                        }
                        this.methodDeclarationsWithInvalidParam.put(node, null);
                    } else {
                        return 0;
                    }
                }
                ++i;
            }
        }
        return nodeSet.addMatch(node, resolve ? 2 : 3);
    }

    public int match(MessageSend node, MatchingNodeSet nodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        if (!this.matchesName(this.pattern.selector, node.selector)) {
            return 0;
        }
        if (this.pattern.parameterSimpleNames != null && (node.bits & 0x8000) != 0) {
            int argsLength;
            int length = this.pattern.parameterSimpleNames.length;
            Expression[] args = node.arguments;
            int n = argsLength = args == null ? 0 : args.length;
            if (length != argsLength) {
                return 0;
            }
        }
        return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
    }

    protected int matchContainer() {
        if (this.pattern.findReferences) {
            return 15;
        }
        return this.pattern.isFunction ? 1 : 2;
    }

    protected void matchLevelAndReportImportRef(ImportReference importRef, Binding binding, MatchLocator locator) throws CoreException {
    }

    protected int matchMethod(MethodBinding method, boolean skipImpossibleArg) {
        if (!this.matchesName(this.pattern.selector, method.selector)) {
            return 0;
        }
        int level = 3;
        if (this.pattern.getDeclaringSimpleName() == null) {
            int newLevel = this.resolveLevelForType(this.pattern.returnSimpleName, this.pattern.returnQualification, method.returnType);
            if (level > newLevel) {
                if (newLevel == 0) {
                    return 0;
                }
                level = newLevel;
            }
        } else if (!CharOperation.equals(this.pattern.getDeclaringSimpleName(), IIndexConstants.GLOBAL_SYMBOL, false)) {
            level = this.resolveLevelForType(this.pattern.getDeclaringSimpleName(), this.pattern.getDeclaringQualification(), method.declaringClass);
        }
        return level;
    }

    private boolean matchOverriddenMethod(ReferenceBinding type, MethodBinding method, MethodBinding matchMethod) {
        ReferenceBinding superClass;
        if (type == null || this.pattern.selector == null) {
            return false;
        }
        return !CharOperation.equals(type.compoundName, TypeConstants.JAVA_LANG_OBJECT) && this.matchOverriddenMethod(superClass = type.getSuperBinding(), method, matchMethod);
    }

    protected void matchReportReference(ASTNode reference, IJavaScriptElement element, Binding elementBinding, int accuracy, MatchLocator locator) throws CoreException {
        MethodBinding methodBinding;
        MethodBinding methodBinding2 = reference instanceof MessageSend ? ((MessageSend)reference).binding : (methodBinding = elementBinding instanceof MethodBinding ? (MethodBinding)elementBinding : null);
        if (this.isDeclarationOfReferencedMethodsPattern) {
            if (methodBinding == null) {
                return;
            }
            if (accuracy != 0) {
                return;
            }
            DeclarationOfReferencedMethodsPattern declPattern = (DeclarationOfReferencedMethodsPattern)this.pattern;
            while (element != null && !declPattern.enclosingElement.equals(element)) {
                element = element.getParent();
            }
            if (element != null) {
                this.reportDeclaration(methodBinding, locator, declPattern.knownMethods);
            }
        } else {
            this.match = locator.newMethodReferenceMatch(element, elementBinding, accuracy, -1, -1, false, reference);
            if (this.pattern.findReferences && reference instanceof MessageSend) {
                boolean isPrivate;
                IJavaScriptElement focus = this.pattern.focus;
                if (focus != null && focus.getElementType() == 9 && methodBinding != null && (isPrivate = Flags.isPrivate(((IFunction)focus).getFlags())) && !CharOperation.equals(methodBinding.declaringClass.sourceName, focus.getParent().getElementName().toCharArray())) {
                    return;
                }
                this.matchReportReference((MessageSend)reference, locator, ((MessageSend)reference).binding);
            } else {
                int offset = reference.sourceStart;
                int length = reference.sourceEnd - offset + 1;
                this.match.setOffset(offset);
                this.match.setLength(length);
                locator.report(this.match);
            }
        }
    }

    void matchReportReference(MessageSend messageSend, MatchLocator locator, MethodBinding methodBinding) throws CoreException {
        boolean report;
        if (this.match.getRule() == 0) {
            return;
        }
        boolean bl = report = this.isErasureMatch && this.match.isErasure() || this.isEquivalentMatch && this.match.isEquivalent() || this.match.isExact();
        if (!report) {
            return;
        }
        int offset = (int)(messageSend.nameSourcePosition >>> 32);
        this.match.setOffset(offset);
        this.match.setLength(messageSend.sourceEnd - offset + 1);
        locator.report(this.match);
    }

    public SearchMatch newDeclarationMatch(ASTNode reference, IJavaScriptElement element, Binding elementBinding, int accuracy, int length, MatchLocator locator) {
        if (elementBinding != null) {
            MethodBinding methodBinding = (MethodBinding)elementBinding;
            if (this.methodDeclarationsWithInvalidParam.containsKey(reference)) {
                Boolean report = (Boolean)this.methodDeclarationsWithInvalidParam.get(reference);
                if (report != null) {
                    if (report.booleanValue()) {
                        return super.newDeclarationMatch(reference, element, elementBinding, accuracy, length, locator);
                    }
                    return null;
                }
                if (this.matchOverriddenMethod(methodBinding.declaringClass, methodBinding, null)) {
                    this.methodDeclarationsWithInvalidParam.put(reference, Boolean.TRUE);
                    return super.newDeclarationMatch(reference, element, elementBinding, accuracy, length, locator);
                }
                if (this.isTypeInSuperDeclaringTypeNames(methodBinding.declaringClass.compoundName)) {
                    MethodBinding patternBinding = locator.getMethodBinding(this.pattern);
                    if (patternBinding != null && !this.matchOverriddenMethod(patternBinding.declaringClass, patternBinding, methodBinding)) {
                        this.methodDeclarationsWithInvalidParam.put(reference, Boolean.FALSE);
                        return null;
                    }
                    this.methodDeclarationsWithInvalidParam.put(reference, Boolean.TRUE);
                    return super.newDeclarationMatch(reference, element, elementBinding, accuracy, length, locator);
                }
                this.methodDeclarationsWithInvalidParam.put(reference, Boolean.FALSE);
                return null;
            }
        }
        return super.newDeclarationMatch(reference, element, elementBinding, accuracy, length, locator);
    }

    protected int referenceType() {
        return 9;
    }

    protected void reportDeclaration(MethodBinding methodBinding, MatchLocator locator, SimpleSet knownMethods) throws CoreException {
        ReferenceBinding declaringClass = methodBinding.declaringClass;
        IType type = locator.lookupType(declaringClass);
        if (type == null) {
            return;
        }
        char[] bindingSelector = methodBinding.selector;
        boolean isBinary = type.isBinary();
        IFunction method = null;
        TypeBinding[] parameters = methodBinding.original().parameters;
        int parameterLength = parameters.length;
        String[] parameterTypes = new String[parameterLength];
        int i = 0;
        while (i < parameterLength) {
            char[] typeName = parameters[i].shortReadableName();
            if (parameters[i].isMemberType()) {
                typeName = CharOperation.subarray(typeName, CharOperation.indexOf('.', typeName) + 1, typeName.length);
            }
            parameterTypes[i] = Signature.createTypeSignature(typeName, false);
            ++i;
        }
        method = type.getFunction(new String(bindingSelector), parameterTypes);
        if (method == null || knownMethods.addIfNotIncluded(method) == null) {
            return;
        }
        IResource resource = type.getResource();
        IBinaryType info = null;
        if (isBinary) {
            if (resource == null) {
                resource = type.getJavaScriptProject().getProject();
            }
            info = locator.getBinaryInfo((ClassFile)type.getClassFile(), resource);
            locator.reportBinaryMemberDeclaration(resource, method, methodBinding, info, 0);
        } else {
            ClassScope scope = (ClassScope)((SourceTypeBinding)declaringClass).scope;
            if (scope != null) {
                TypeDeclaration typeDecl = scope.referenceContext;
                AbstractMethodDeclaration methodDecl = null;
                AbstractMethodDeclaration[] methodDecls = typeDecl.methods;
                int i2 = 0;
                int length = methodDecls.length;
                while (i2 < length) {
                    if (CharOperation.equals(bindingSelector, methodDecls[i2].getName())) {
                        methodDecl = methodDecls[i2];
                        break;
                    }
                    ++i2;
                }
                if (methodDecl != null) {
                    int offset = methodDecl.sourceStart;
                    MethodBinding binding = methodDecl.getBinding();
                    if (binding != null) {
                        method = (IFunction)((Object)((JavaElement)((Object)method)).resolved(binding));
                    }
                    this.match = new MethodDeclarationMatch(method, 0, offset, methodDecl.sourceEnd - offset + 1, locator.getParticipant(), resource);
                    locator.report(this.match);
                }
            }
        }
    }

    public int resolveLevel(ASTNode possibleMatchingNode) {
        if (this.pattern.findReferences && possibleMatchingNode instanceof MessageSend) {
            return this.resolveLevel((MessageSend)possibleMatchingNode);
        }
        if (this.pattern.findDeclarations) {
            if (possibleMatchingNode instanceof MethodDeclaration) {
                return this.resolveLevel(((MethodDeclaration)possibleMatchingNode).getBinding());
            }
            if (possibleMatchingNode instanceof InferredMethod) {
                return this.resolveLevel(((InferredMethod)possibleMatchingNode).methodBinding);
            }
        }
        return 0;
    }

    public int resolveLevel(Binding binding) {
        boolean subType;
        char[] qualifiedPattern;
        if (binding == null) {
            return 1;
        }
        if (!(binding instanceof MethodBinding)) {
            return 0;
        }
        MethodBinding method = (MethodBinding)binding;
        boolean skipVerif = this.pattern.findDeclarations && this.mayBeGeneric;
        int methodLevel = this.matchMethod(method, skipVerif);
        if (methodLevel == 0) {
            if (method != method.original()) {
                methodLevel = this.matchMethod(method.original(), skipVerif);
            }
            if (methodLevel == 0) {
                return 0;
            }
            method = method.original();
        }
        if ((qualifiedPattern = MethodLocator.qualifiedPattern(this.pattern.getDeclaringSimpleName(), this.pattern.getDeclaringQualification())) == null) {
            return methodLevel;
        }
        boolean bl = subType = !method.isStatic() && !method.isPrivate();
        if (subType && this.pattern.getDeclaringQualification() != null && method.declaringClass != null && method.declaringClass.fPackage != null) {
            subType = CharOperation.compareWith(this.pattern.getDeclaringQualification(), method.declaringClass.fPackage.shortReadableName()) == 0;
        }
        int declaringLevel = subType ? this.resolveLevelAsSubtype(qualifiedPattern, method.declaringClass, null) : this.resolveLevelForType(qualifiedPattern, method.declaringClass);
        return methodLevel > declaringLevel ? declaringLevel : methodLevel;
    }

    protected int resolveLevel(MessageSend messageSend) {
        int declaringLevel;
        char[] qualifiedPattern;
        MethodBinding method = messageSend.binding;
        if (method == null) {
            return 1;
        }
        if (messageSend.resolvedType == null) {
            int argLength;
            int n = argLength = messageSend.arguments == null ? 0 : messageSend.arguments.length;
            if (this.pattern.parameterSimpleNames == null || argLength == this.pattern.parameterSimpleNames.length) {
                return 1;
            }
            return 0;
        }
        int methodLevel = this.matchMethod(method, false);
        if (methodLevel == 0) {
            if (method != method.original()) {
                methodLevel = this.matchMethod(method.original(), false);
            }
            if (methodLevel == 0) {
                return 0;
            }
            method = method.original();
        }
        if ((qualifiedPattern = MethodLocator.qualifiedPattern(this.pattern.getDeclaringSimpleName(), this.pattern.getDeclaringQualification())) == null) {
            return methodLevel;
        }
        if (this.isVirtualInvoke(method, messageSend) && messageSend.actualReceiverType instanceof ReferenceBinding) {
            ReferenceBinding methodReceiverType = (ReferenceBinding)messageSend.actualReceiverType;
            declaringLevel = this.resolveLevelAsSubtype(qualifiedPattern, methodReceiverType, method.parameters);
            if (declaringLevel == 0) {
                if (method.declaringClass == null || this.allSuperDeclaringTypeNames == null) {
                    declaringLevel = 1;
                } else {
                    char[][] compoundName = methodReceiverType.compoundName;
                    int i = 0;
                    int max = this.allSuperDeclaringTypeNames.length;
                    while (i < max) {
                        if (CharOperation.equals(this.allSuperDeclaringTypeNames[i], compoundName)) {
                            return methodLevel | 0x200;
                        }
                        ++i;
                    }
                }
            }
            if ((declaringLevel & 0xFFFFFFF0) != 0) {
                return declaringLevel;
            }
        } else {
            declaringLevel = this.resolveLevelForType(qualifiedPattern, method.declaringClass);
        }
        return methodLevel > declaringLevel ? declaringLevel : methodLevel;
    }

    protected int resolveLevelAsSubtype(char[] qualifiedPattern, ReferenceBinding type, TypeBinding[] argumentTypes) {
        if (type == null) {
            return 1;
        }
        int level = this.resolveLevelForType(qualifiedPattern, type);
        if (level != 0) {
            return level |= 0x800;
        }
        if (!CharOperation.equals(type.compoundName, TypeConstants.JAVA_LANG_OBJECT) && (level = this.resolveLevelAsSubtype(qualifiedPattern, type.getSuperBinding(), argumentTypes)) != 0) {
            if (argumentTypes != null) {
                MethodBinding[] methods = type.getMethods(this.pattern.selector);
                int i = 0;
                int length = methods.length;
                while (i < length) {
                    MethodBinding method = methods[i];
                    TypeBinding[] parameters = method.parameters;
                    if (argumentTypes.length == parameters.length) {
                        boolean found = true;
                        int j = 0;
                        int l = parameters.length;
                        while (j < l) {
                            if (parameters[j] != argumentTypes[j]) {
                                found = false;
                                break;
                            }
                            ++j;
                        }
                        if (found) {
                            if ((level & 0x800) != 0) {
                                return 0;
                            }
                            if (!method.isAbstract()) {
                                level |= 0x800;
                            }
                        }
                    }
                    ++i;
                }
            }
            return level | 0x400;
        }
        return 1;
    }

    public String toString() {
        return "Locator for " + this.pattern.toString();
    }

    public int match(InferredMethod inferredMethod, MatchingNodeSet nodeSet) {
        if (!this.pattern.findDeclarations) {
            return 0;
        }
        if (!this.matchesName(this.pattern.selector, inferredMethod.name)) {
            return 0;
        }
        boolean resolve = this.pattern.mustResolve;
        if (!resolve && inferredMethod.inType != null && !this.matchesName(QualificationHelpers.createFullyQualifiedName(this.pattern.getDeclaringQualification(), this.pattern.getDeclaringSimpleName()), inferredMethod.inType.getName())) {
            return 0;
        }
        if (this.pattern.parameterSimpleNames != null) {
            int argsLength;
            int length = this.pattern.parameterSimpleNames.length;
            Argument[] args = ((AbstractMethodDeclaration)((Object)inferredMethod.getFunctionDeclaration())).arguments;
            int n = argsLength = args == null ? 0 : args.length;
            if (length != argsLength) {
                return 0;
            }
            int i = 0;
            while (i < argsLength) {
                if (args != null && !this.matchesTypeReference(this.pattern.parameterSimpleNames[i], args[i].type)) {
                    if (this.mayBeGeneric) {
                        if (!this.pattern.mustResolve) {
                            nodeSet.mustResolve = true;
                            resolve = true;
                        }
                        this.methodDeclarationsWithInvalidParam.put(inferredMethod.getFunctionDeclaration(), null);
                    } else {
                        return 0;
                    }
                }
                ++i;
            }
        }
        return nodeSet.addMatch(inferredMethod, resolve ? 2 : 3);
    }
}

