/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.readonly;

import com.google.common.base.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.infra.emf.readonly.AbstractReadOnlyHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSReadOnlyHandler
extends AbstractReadOnlyHandler {
    public FSReadOnlyHandler(EditingDomain editingDomain) {
        super(editingDomain);
    }

    public Optional<Boolean> anyReadOnly(URI[] uris) {
        URI[] uRIArray = uris;
        int n = uris.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            IFile file = FSReadOnlyHandler.getFile(uri);
            if (file != null && file.isReadOnly()) {
                return Optional.of((Object)Boolean.TRUE);
            }
            ++n2;
        }
        return Optional.absent();
    }

    private static IFile getFile(URI uri) {
        if (uri.isPlatform()) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
        }
        return null;
    }

    public Optional<Boolean> makeWritable(final URI[] uris) {
        final AtomicBoolean doEnableWrite = new AtomicBoolean();
        Display.getCurrent().syncExec(new Runnable(){

            public void run() {
                String message = "Do you want to remove read only flag on those files ?\n\n";
                URI[] uRIArray = uris;
                int n = uris.length;
                int n2 = 0;
                while (n2 < n) {
                    URI uri = uRIArray[n2];
                    IFile file = FSReadOnlyHandler.getFile(uri);
                    if (file != null && file.isReadOnly()) {
                        message = String.valueOf(message) + file.getName() + "\n";
                    }
                    ++n2;
                }
                doEnableWrite.set(MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Enable write", (String)message));
            }
        });
        if (doEnableWrite.get()) {
            Boolean ok = true;
            URI[] uRIArray = uris;
            int n = uris.length;
            int n2 = 0;
            while (n2 < n) {
                URI uri = uRIArray[n2];
                IFile file = FSReadOnlyHandler.getFile(uri);
                if (file != null && file.isReadOnly()) {
                    try {
                        ResourceAttributes att = file.getResourceAttributes();
                        att.setReadOnly(false);
                        file.setResourceAttributes(att);
                    }
                    catch (CoreException e) {
                        ok = false;
                    }
                }
                ++n2;
            }
            return Optional.of((Object)ok);
        }
        return Optional.absent();
    }
}

