/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.actions;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.papyrus.uml.diagram.common.helper.AlignmentLinkHelper;
import org.eclipse.papyrus.uml.diagram.common.layout.AlignmentTree;
import org.eclipse.papyrus.uml.diagram.common.layout.EditPartTree;
import org.eclipse.papyrus.uml.diagram.common.layout.LayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomAlignAction {
    private AlignmentTree rootTree;
    private int alignment;
    private List<IGraphicalEditPart> selectedElements;

    public CustomAlignAction(int alignment, List<IGraphicalEditPart> selectedElements) {
        this.alignment = alignment;
        this.selectedElements = selectedElements;
    }

    public Command getCommand() {
        ArrayList<IGraphicalEditPart> editparts = new ArrayList<IGraphicalEditPart>();
        for (IGraphicalEditPart current : this.selectedElements) {
            editparts.add(current);
        }
        if (!this.isMixedSelection(editparts)) {
            if (this.isLinkSelection(editparts)) {
                AlignmentLinkHelper helper = new AlignmentLinkHelper(editparts, this.alignment);
                return helper.createCommand();
            }
            if (editparts.size() >= 2) {
                this.rootTree = new AlignmentTree(editparts);
                this.createRequests(editparts);
                CompoundCommand command = new CompoundCommand("Alignment Command");
                Enumeration eptEnum = this.rootTree.breadthFirstEnumeration();
                while (eptEnum.hasMoreElements()) {
                    AlignmentRequest currentReq;
                    EditPartTree ept = (EditPartTree)eptEnum.nextElement();
                    if (ept.getEditPart() == null || (currentReq = (AlignmentRequest)ept.getRequest()) == null) continue;
                    Command curCommand = null;
                    curCommand = ept.getEditPart().getCommand((Request)currentReq);
                    if (curCommand == null) continue;
                    command.add(curCommand);
                }
                return command.isEmpty() ? UnexecutableCommand.INSTANCE : command;
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected void createRequests(List<?> editparts) {
        EditPart refEP = (EditPart)editparts.get(editparts.size() - 1);
        PrecisionRectangle boundsRef = LayoutUtils.getAbsolutePosition((EditPart)refEP);
        int depth = this.rootTree.getDepth();
        int i = 1;
        while (i <= depth) {
            List epTrees = this.rootTree.getChildLevel(i);
            for (EditPartTree ept : epTrees) {
                ArrayList<EditPart> nodeChild = new ArrayList<EditPart>();
                Enumeration vectorisedChildren = ((EditPartTree)ept.getPath()[1]).breadthFirstEnumeration();
                while (vectorisedChildren.hasMoreElements()) {
                    nodeChild.add(((EditPartTree)vectorisedChildren.nextElement()).getEditPart());
                }
                if (ept.isSelected()) {
                    if (ept.getEditPart() != refEP && !ept.existsUnselectedChild()) {
                        int level = ept.getLevelForFirstSelectedElement();
                        if (ToolUtilities.isAncestorContainedIn(nodeChild, (EditPart)refEP)) {
                            level = this.rootTree.getTree(refEP).getLevel();
                            int currentLevel = ept.getLevel();
                            level = level - currentLevel + 1;
                        }
                        ArrayList<EditPart> coll = new ArrayList<EditPart>(1);
                        coll.add(ept.getEditPart());
                        PrecisionRectangle alignRef = new PrecisionRectangle((Rectangle)boundsRef);
                        PrecisionRectangle containerBounds = ((AlignmentTree)ept).getNewContainerBounds();
                        if (!containerBounds.equals((Object)LayoutUtils.getAbsolutePosition((EditPart)ept.getEditPart().getRoot()))) {
                            containerBounds.setX(containerBounds.preciseX + 6.0);
                            containerBounds.setY(containerBounds.preciseY + 6.0);
                            containerBounds.setWidth(containerBounds.preciseWidth - 12.0);
                            containerBounds.setHeight(containerBounds.preciseHeight - 12.0);
                        }
                        switch (this.alignment) {
                            case 1: {
                                alignRef.setX(boundsRef.preciseX - (double)(level - 1) * 6.0);
                                alignRef.setWidth(boundsRef.preciseWidth + 2.0 * ((double)(level - 1) * 6.0));
                                break;
                            }
                            case 2: {
                                break;
                            }
                            case 4: {
                                alignRef.setX(boundsRef.preciseX + (double)(-level + 1) * 6.0);
                                alignRef.setWidth(boundsRef.preciseWidth - 2.0 * ((double)(-level + 1) * 6.0));
                                break;
                            }
                            case 32: {
                                alignRef.setY(boundsRef.preciseY + (double)(-level + 1) * 6.0);
                                alignRef.setHeight(boundsRef.preciseHeight - 2.0 * ((double)(-level + 1) * 6.0));
                                break;
                            }
                            case 16: {
                                double heightMax = 0.0;
                                Enumeration children = ept.children();
                                while (children.hasMoreElements()) {
                                    EditPartTree currentChild = (EditPartTree)children.nextElement();
                                    double height = LayoutUtils.getAbsolutePosition((EditPart)currentChild.getEditPart()).preciseHeight();
                                    double d = heightMax = height > heightMax ? height : heightMax;
                                }
                                List childrenEP = ept.getEditPart().getChildren();
                                double compartmentHeight = 0.0;
                                int iter = 0;
                                while (iter < childrenEP.size()) {
                                    CompartmentEditPart child;
                                    EditPolicy policy;
                                    if (childrenEP.get(iter) instanceof CompartmentEditPart && (policy = (child = (CompartmentEditPart)childrenEP.get(iter)).getEditPolicy((Object)"LayoutEditPolicy")) != null) {
                                        compartmentHeight = LayoutUtils.getAbsolutePosition((EditPart)child).preciseHeight();
                                        break;
                                    }
                                    ++iter;
                                }
                                double heightToRemove = this.getLabelHeightToRemove(ept);
                                if (!(compartmentHeight < heightMax + 6.0 + heightToRemove)) break;
                                alignRef.setY(alignRef.preciseY - heightToRemove);
                                alignRef.setHeight(alignRef.preciseHeight + heightToRemove);
                                break;
                            }
                            case 8: {
                                alignRef.setY(boundsRef.preciseY - (double)(level - 1) * 6.0);
                                alignRef.setHeight(boundsRef.preciseHeight + 2.0 * ((double)(level - 1) * 6.0));
                                if (!ept.children().hasMoreElements()) break;
                                double dist = this.getLabelHeightToRemove(ept);
                                alignRef.setY(alignRef.preciseY() - dist);
                                break;
                            }
                        }
                        this.createConstrainedRequest(alignRef, containerBounds, null, (AlignmentTree)ept);
                        continue;
                    }
                    if (ept.getEditPart() != refEP && ept.existsUnselectedChild()) {
                        PrecisionRectangle containerBounds;
                        ArrayList<EditPart> parent = new ArrayList<EditPart>(1);
                        parent.add(ept.getEditPart());
                        int distance = ept.getDistanceWithTheFirstUnselectedChild();
                        EditPartTree unselectedTree = ept.getFirstUnselectedChild();
                        PrecisionRectangle boundsLimit = null;
                        if (ToolUtilities.isAncestorContainedIn(parent, (EditPart)refEP)) {
                            boundsLimit = new PrecisionRectangle((Rectangle)LayoutUtils.getAbsolutePosition((EditPart)unselectedTree.getEditPart()));
                            boundsLimit.setX(boundsLimit.preciseX - (double)distance * 6.0);
                            boundsLimit.setY(boundsLimit.preciseY - (double)distance * 6.0);
                            boundsLimit.setWidth((double)boundsLimit.width + (double)(2 * distance) * 6.0);
                            boundsLimit.setHeight((double)boundsLimit.height + (double)(2 * distance) * 6.0);
                            if (this.alignment == 8) {
                                double dist = this.getLabelHeightToRemove(ept);
                                boundsLimit.setY(boundsLimit.preciseY() - dist);
                            }
                        }
                        if (!(containerBounds = ((AlignmentTree)ept).getNewContainerBounds()).equals((Object)LayoutUtils.getAbsolutePosition((EditPart)ept.getEditPart().getRoot()))) {
                            containerBounds.setX(containerBounds.preciseX + 6.0);
                            containerBounds.setY(containerBounds.preciseY + 6.0);
                            containerBounds.setWidth((double)containerBounds.width - 12.0);
                            containerBounds.setHeight((double)containerBounds.height - 12.0);
                        }
                        this.createConstrainedRequest(boundsRef, containerBounds, boundsLimit, (AlignmentTree)ept);
                        continue;
                    }
                    if (ept.getEditPart() == refEP && ToolUtilities.isAncestorContainedIn(nodeChild, (EditPart)refEP)) {
                        if (!((EditPartTree)ept.getParent()).isSelected()) continue;
                        PrecisionRectangle containerBounds = ((AlignmentTree)ept).getNewContainerBounds();
                        containerBounds.setX(containerBounds.preciseX + 6.0);
                        containerBounds.setY(containerBounds.preciseY + 6.0);
                        containerBounds.setWidth((double)containerBounds.width - 12.0);
                        containerBounds.setHeight((double)containerBounds.height - 12.0);
                        this.createConstrainedRequest(LayoutUtils.getAbsolutePosition((EditPart)refEP), containerBounds, null, (AlignmentTree)ept);
                        continue;
                    }
                    if (ept.getEditPart() != refEP) continue;
                    ToolUtilities.isAncestorContainedIn(nodeChild, (EditPart)refEP);
                    continue;
                }
                PrecisionRectangle containerBounds = ((AlignmentTree)ept).getNewContainerBounds();
                containerBounds.setX(containerBounds.preciseX + 6.0);
                containerBounds.setY(containerBounds.preciseY + 6.0);
                containerBounds.setWidth((double)containerBounds.width - 12.0);
                containerBounds.setHeight((double)containerBounds.height - 12.0);
                this.createConstrainedRequest(LayoutUtils.getAbsolutePosition((EditPart)ept.getEditPart()), containerBounds, null, (AlignmentTree)ept);
            }
            ++i;
        }
    }

    protected void createConstrainedRequest(PrecisionRectangle ref, PrecisionRectangle containerBounds, PrecisionRectangle dontCross, AlignmentTree tree) {
        double xMinForObject = 0.0;
        double xMaxForObject = 0.0;
        double yMinForObject = 0.0;
        double yMaxForObject = 0.0;
        PrecisionRectangle editpartBounds = LayoutUtils.getAbsolutePosition((EditPart)tree.getEditPart());
        PrecisionRectangle newPosition = new PrecisionRectangle((Rectangle)editpartBounds);
        if (dontCross == null && containerBounds.equals((Object)LayoutUtils.getAbsolutePosition((EditPart)tree.getEditPart().getRoot()))) {
            AlignmentRequest newRequest = new AlignmentRequest((Object)"align");
            PrecisionRectangle newPrecisionRectangle = new PrecisionRectangle((Rectangle)ref);
            newRequest.setAlignment(this.alignment);
            newRequest.setAlignmentRectangle((Rectangle)newPrecisionRectangle);
            double pos = 0.0;
            switch (this.alignment) {
                case 1: {
                    newPosition.setX(ref.preciseX());
                    break;
                }
                case 2: {
                    pos = ref.getTop().preciseX() - editpartBounds.preciseWidth() / 2.0;
                    newPosition.setX(pos);
                    break;
                }
                case 4: {
                    pos = ref.getRight().preciseX() - editpartBounds.preciseWidth();
                    newPosition.setX(pos);
                    break;
                }
                case 8: {
                    pos = ref.getTop().preciseY();
                    newPosition.setY(pos);
                    break;
                }
                case 16: {
                    pos = ref.getLeft().preciseY() - editpartBounds.preciseHeight / 2.0;
                    newPosition.setY(pos);
                    break;
                }
                case 32: {
                    pos = ref.getBottom().preciseY() - editpartBounds.preciseHeight();
                    newPosition.setY(pos);
                    break;
                }
            }
            tree.setNewPosition(newPosition);
            tree.setRequest((Request)newRequest);
            return;
        }
        if (dontCross == null && !containerBounds.equals((Object)LayoutUtils.getAbsolutePosition((EditPart)tree.getEditPart().getRoot()))) {
            xMinForObject = containerBounds.preciseX;
            xMaxForObject = containerBounds.getRight().preciseX() - editpartBounds.preciseWidth();
            yMinForObject = containerBounds.preciseY;
            yMaxForObject = containerBounds.getBottom().preciseY() - editpartBounds.preciseHeight();
        } else if (dontCross != null) {
            xMinForObject = dontCross.getRight().preciseX() - editpartBounds.preciseWidth;
            xMaxForObject = dontCross.preciseX;
            yMinForObject = dontCross.getBottom().preciseY() - editpartBounds.preciseHeight;
            yMaxForObject = dontCross.preciseY;
            if (!containerBounds.equals((Object)LayoutUtils.getAbsolutePosition((EditPart)tree.getEditPart().getRoot()))) {
                double xMinContainerLimit = containerBounds.preciseX;
                double xMaxContainerLimit = containerBounds.getRight().preciseX() - editpartBounds.preciseWidth();
                double yMinContainerLimit = containerBounds.preciseY;
                double yMaxContainerLimit = containerBounds.getBottom().preciseY() - editpartBounds.preciseHeight();
                xMinForObject = xMinForObject > xMinContainerLimit ? xMinForObject : xMinContainerLimit;
                xMaxForObject = xMaxForObject > xMaxContainerLimit ? xMaxContainerLimit : xMaxForObject;
                yMinForObject = yMinForObject > yMinContainerLimit ? yMinForObject : yMinContainerLimit;
                yMaxForObject = yMaxForObject > yMaxContainerLimit ? yMaxContainerLimit : yMaxForObject;
            }
        }
        PrecisionRectangle myAlignRectangle = new PrecisionRectangle((Rectangle)editpartBounds);
        PrecisionRectangle newTmpPosition = tree.getAbsolutePositionInTheNewContainerPosition();
        double distance = 0.0;
        Point translationPoint = null;
        AlignmentRequest newRequest = new AlignmentRequest((Object)"align");
        newRequest.setAlignment(this.alignment);
        switch (this.alignment) {
            case 1: {
                if (ref.preciseX >= xMinForObject && ref.preciseX <= xMaxForObject) {
                    distance = ref.preciseX - newTmpPosition.preciseX;
                } else if (ref.preciseX < xMinForObject) {
                    distance = xMinForObject - newTmpPosition.preciseX;
                } else if (ref.preciseX > xMaxForObject) {
                    distance = xMaxForObject - newTmpPosition.preciseX;
                }
                myAlignRectangle.setX(LayoutUtils.getAbsolutePosition((EditPart)tree.getEditPart()).preciseX + distance);
                translationPoint = new Point(distance, 0.0);
                break;
            }
            case 2: {
                double minCenter = xMinForObject + editpartBounds.preciseWidth / 2.0;
                double maxCenter = xMaxForObject + editpartBounds.preciseWidth / 2.0;
                if (ref.getTop().preciseX() >= minCenter && ref.getTop().preciseX() <= maxCenter) {
                    distance = ref.preciseX + ref.preciseWidth / 2.0 - (newTmpPosition.preciseX + newTmpPosition.preciseWidth / 2.0);
                } else if (ref.getTop().preciseX() < minCenter) {
                    distance = minCenter - (newTmpPosition.preciseX + newTmpPosition.preciseWidth / 2.0);
                } else if (ref.getTop().preciseX() > maxCenter) {
                    distance = maxCenter - (newTmpPosition.preciseX + newTmpPosition.preciseWidth / 2.0);
                }
                myAlignRectangle.setX(LayoutUtils.getAbsolutePosition((EditPart)tree.getEditPart()).preciseX + distance);
                translationPoint = new Point(distance, 0.0);
                break;
            }
            case 4: {
                double minRight = xMinForObject + editpartBounds.preciseWidth;
                double maxRight = xMaxForObject + editpartBounds.preciseWidth;
                if (ref.getRight().preciseX() >= minRight && ref.getRight().preciseX() <= maxRight) {
                    distance = ref.preciseX + ref.preciseWidth - (newTmpPosition.preciseX + newTmpPosition.preciseWidth);
                } else if (ref.getRight().preciseX() < minRight) {
                    distance = minRight - (newTmpPosition.preciseX + newTmpPosition.preciseWidth);
                } else if (ref.getRight().preciseX() > maxRight) {
                    distance = maxRight - (newTmpPosition.preciseX + newTmpPosition.preciseWidth);
                }
                myAlignRectangle.setX(LayoutUtils.getAbsolutePosition((EditPart)tree.getEditPart()).preciseX + distance);
                translationPoint = new Point(distance, 0.0);
                break;
            }
            case 32: {
                double minBottom = yMinForObject + editpartBounds.preciseHeight;
                double maxBottom = yMaxForObject + editpartBounds.preciseHeight;
                if (ref.getBottom().preciseY() >= minBottom && ref.getBottom().preciseY() <= maxBottom) {
                    distance = ref.preciseY + ref.preciseHeight - (newTmpPosition.preciseY + newTmpPosition.preciseHeight);
                } else if (ref.getBottom().preciseY() < minBottom) {
                    distance = minBottom - (newTmpPosition.preciseY + newTmpPosition.preciseHeight);
                } else if (ref.getBottom().preciseY() > maxBottom) {
                    distance = maxBottom - (newTmpPosition.preciseY + newTmpPosition.preciseHeight);
                }
                translationPoint = new Point(0.0, distance);
                myAlignRectangle.setY(LayoutUtils.getAbsolutePosition((EditPart)tree.getEditPart()).preciseY + distance);
                break;
            }
            case 16: {
                double minMiddle = yMinForObject + editpartBounds.preciseHeight / 2.0;
                double maxMiddle = yMaxForObject + editpartBounds.preciseHeight / 2.0;
                if (ref.preciseY + ref.preciseHeight / 2.0 >= minMiddle && ref.preciseY + ref.preciseHeight / 2.0 <= maxMiddle) {
                    distance = ref.preciseY + ref.preciseHeight / 2.0 - (newTmpPosition.preciseY + newTmpPosition.preciseHeight / 2.0);
                } else if (ref.preciseY + (double)ref.height / 2.0 < minMiddle) {
                    distance = minMiddle - (newTmpPosition.preciseY + newTmpPosition.preciseHeight / 2.0);
                } else if (ref.preciseY + (double)ref.height / 2.0 > maxMiddle) {
                    distance = maxMiddle - (newTmpPosition.preciseY + newTmpPosition.preciseHeight / 2.0);
                }
                translationPoint = new Point(0.0, distance);
                myAlignRectangle.setY(LayoutUtils.getAbsolutePosition((EditPart)tree.getEditPart()).preciseY + distance);
                break;
            }
            case 8: {
                if (ref.preciseY >= yMinForObject && ref.preciseY <= yMaxForObject) {
                    distance = ref.preciseY - newTmpPosition.preciseY;
                } else if (ref.preciseY < yMinForObject) {
                    distance = yMinForObject - newTmpPosition.preciseY;
                } else if (ref.preciseY > yMaxForObject) {
                    distance = yMaxForObject - newTmpPosition.preciseY;
                }
                translationPoint = new Point(0.0, distance);
                myAlignRectangle.setY(LayoutUtils.getAbsolutePosition((EditPart)tree.getEditPart()).preciseY + distance);
                break;
            }
        }
        newRequest.setAlignmentRectangle((Rectangle)myAlignRectangle);
        newPosition = (PrecisionRectangle)tree.getAbsolutePositionInTheNewContainerPosition().translate(translationPoint);
        tree.setNewPosition(newPosition);
        tree.setRequest((Request)newRequest);
    }

    protected double getLabelHeightToRemove(EditPartTree ept) {
        double dist = 0.0;
        List children = ept.getEditPart().getChildren();
        int iter = 0;
        while (iter < children.size()) {
            CompartmentEditPart child;
            EditPolicy policy;
            if (children.get(iter) instanceof CompartmentEditPart && (policy = (child = (CompartmentEditPart)children.get(iter)).getEditPolicy((Object)"LayoutEditPolicy")) != null) {
                PrecisionRectangle cptSize = LayoutUtils.getAbsolutePosition((EditPart)child);
                dist += cptSize.preciseY() - LayoutUtils.getAbsolutePosition((EditPart)ept.getEditPart()).preciseY();
                break;
            }
            ++iter;
        }
        Enumeration eptChildren = ept.children();
        double max = 0.0;
        while (eptChildren.hasMoreElements()) {
            EditPartTree currentElement = (EditPartTree)eptChildren.nextElement();
            if (!currentElement.isSelected() || currentElement.isReference()) continue;
            double tmp = this.getLabelHeightToRemove(currentElement);
            double d = max = tmp > max ? tmp : max;
        }
        return dist += max;
    }

    protected boolean isMixedSelection(List<?> editparts) {
        boolean node = false;
        boolean link = false;
        for (Object editPart : editparts) {
            if (editPart instanceof AbstractConnectionEditPart) {
                link = true;
                continue;
            }
            node = true;
        }
        return node && link;
    }

    protected boolean isLinkSelection(List<?> editparts) {
        if (editparts.size() == 0) {
            return false;
        }
        for (Object object : editparts) {
            if (object instanceof AbstractConnectionEditPart) continue;
            return false;
        }
        return true;
    }
}

