/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.ecore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Import;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.ecore.AbstractEcore2Pivot;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2Moniker;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2PivotDeclarationSwitch;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2PivotReferenceSwitch;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.model.OCLstdlib;
import org.eclipse.ocl.examples.pivot.utilities.AliasAdapter;
import org.eclipse.ocl.examples.pivot.utilities.PivotObjectImpl;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ecore2Pivot
extends AbstractEcore2Pivot {
    public static MetaModelManager.Factory FACTORY = new Factory();
    private Map<String, Element> oldIdMap = null;
    private Map<EObject, Element> newCreateMap = null;
    private Set<EObject> referencers = null;
    private Set<Ecore2Pivot> allConverters = new HashSet<Ecore2Pivot>();
    private List<EGenericType> genericTypes = null;
    private List<Resource.Diagnostic> errors = null;
    protected final Resource ecoreResource;
    protected Root pivotRoot = null;
    protected final Ecore2PivotDeclarationSwitch declarationPass = new Ecore2PivotDeclarationSwitch(this);
    protected final Ecore2PivotReferenceSwitch referencePass = new Ecore2PivotReferenceSwitch(this);
    private HashMap<EClassifier, Type> ecore2PivotMap = null;
    private URI ecoreURI = null;

    @Nullable
    public static Ecore2Pivot findAdapter(@NonNull Resource resource, @NonNull MetaModelManager metaModelManager) {
        for (Adapter adapter : resource.eAdapters()) {
            Ecore2Pivot ecore2Pivot;
            if (!(adapter instanceof Ecore2Pivot) || (ecore2Pivot = (Ecore2Pivot)adapter).getMetaModelManager() != metaModelManager) continue;
            return ecore2Pivot;
        }
        return null;
    }

    public static Ecore2Pivot getAdapter(@NonNull Resource resource, @Nullable MetaModelManager metaModelManager) {
        Ecore2Pivot adapter;
        if (metaModelManager == null) {
            metaModelManager = new MetaModelManager();
        } else {
            adapter = Ecore2Pivot.findAdapter(resource, metaModelManager);
            if (adapter != null) {
                return adapter;
            }
        }
        adapter = new Ecore2Pivot(resource, metaModelManager);
        EList eAdapters = resource.eAdapters();
        eAdapters.add(adapter);
        return adapter;
    }

    @NonNull
    public static Root importFromEcore(@NonNull MetaModelManager metaModelManager, String alias, @NonNull Resource ecoreResource) {
        Ecore2Pivot conversion = Ecore2Pivot.getAdapter(ecoreResource, metaModelManager);
        return conversion.getPivotRoot();
    }

    public static boolean isEcore(@NonNull Resource resource) {
        EList contents = resource.getContents();
        for (EObject content : contents) {
            if (!(content instanceof EPackage)) continue;
            return true;
        }
        return false;
    }

    public static Element importFromEcore(@NonNull MetaModelManager metaModelManager, String alias, @NonNull EObject eObject) {
        Resource ecoreResource = (Resource)DomainUtil.nonNullEMF((Object)eObject.eResource());
        Ecore2Pivot conversion = Ecore2Pivot.getAdapter(ecoreResource, metaModelManager);
        Root pivotRoot = conversion.getPivotRoot();
        return conversion.newCreateMap.get(eObject);
    }

    public Ecore2Pivot(@Nullable Resource ecoreResource, @Nullable MetaModelManager metaModelManager) {
        super(metaModelManager != null ? metaModelManager : new MetaModelManager());
        this.ecoreResource = ecoreResource;
        this.metaModelManager.addExternalResource(this);
        this.metaModelManager.addListener(this);
    }

    protected void addCreated(EObject eObject, Element pivotElement) {
        Element oldElement = this.newCreateMap.put(eObject, pivotElement);
    }

    @Override
    public void addGenericType(@NonNull EGenericType eObject) {
        this.genericTypes.add(eObject);
    }

    @Override
    public void addMapping(@NonNull EObject eObject, @NonNull Element pivotElement) {
        Type pivotType;
        if (pivotElement instanceof PivotObjectImpl) {
            ((PivotObjectImpl)((Object)pivotElement)).setTarget((Notifier)eObject);
        }
        Element pivotElement1 = pivotElement;
        if (eObject instanceof EDataType && (pivotType = this.getEcore2PivotMap().get(eObject)) != null) {
            pivotElement1 = pivotType;
        }
        this.addCreated(eObject, pivotElement1);
    }

    @NonNull
    protected URI createPivotURI() {
        URI uri = this.ecoreResource.getURI();
        if (uri == null) {
            throw new IllegalStateException("Missing resource URI");
        }
        return PivotUtil.getPivotURI(uri);
    }

    public void dispose() {
        this.metaModelManager.removeExternalResource(this);
        Notifier target = this.getTarget();
        if (target != null) {
            target.eAdapters().remove((Object)this);
        }
        this.metaModelManager.removeListener(this);
    }

    @Override
    public void error(@Nullable String message) {
        if (this.errors == null) {
            this.errors = new ArrayList<Resource.Diagnostic>();
        }
        this.errors.add((Resource.Diagnostic)new XMIException(message));
    }

    @Nullable
    public <T extends Element> T getCreated(@NonNull java.lang.Class<T> requiredClass, @NonNull EObject eObject) {
        return this.getPivotOfEcore(requiredClass, eObject);
    }

    @NonNull
    public Map<EClassifier, Type> getEcore2PivotMap() {
        HashMap<Object, Type> ecore2PivotMap2 = this.ecore2PivotMap;
        if (ecore2PivotMap2 == null) {
            ecore2PivotMap2 = this.ecore2PivotMap = new HashMap();
            this.initializeEcore2PivotMap();
        }
        return ecore2PivotMap2;
    }

    @Nullable
    public Resource getEcoreResource() {
        return this.ecoreResource;
    }

    @Nullable
    public <T extends Element> T getPivotOfEcore(@NonNull java.lang.Class<T> requiredClass, @NonNull EObject eObject) {
        Element element;
        if (this.pivotRoot == null) {
            this.getPivotRoot();
        }
        if ((element = this.newCreateMap.get(eObject)) == null) {
            return null;
        }
        if (!requiredClass.isAssignableFrom(element.getClass())) {
            throw new ClassCastException(String.valueOf(element.getClass().getName()) + " is not assignable to " + requiredClass.getName());
        }
        Element castElement = element;
        return (T)castElement;
    }

    public <T extends Element> T getPivotElement(@NonNull java.lang.Class<T> requiredClass, @NonNull EObject eObject) {
        Element element;
        if (this.pivotRoot == null) {
            this.getPivotRoot();
        }
        if ((element = this.newCreateMap.get(eObject)) == null) {
            Ecore2Pivot converter;
            Resource resource = eObject.eResource();
            if (resource != this.ecoreResource && resource != null && this.allConverters.add(converter = Ecore2Pivot.getAdapter(resource, this.metaModelManager))) {
                converter.getPivotRoot();
                for (Map.Entry<EObject, Element> entry : converter.newCreateMap.entrySet()) {
                    this.newCreateMap.put(entry.getKey(), entry.getValue());
                }
            }
            element = this.newCreateMap.get(eObject);
        }
        if (element == null) {
            this.error("Unresolved " + eObject);
        } else if (!requiredClass.isAssignableFrom(element.getClass())) {
            throw new ClassCastException(String.valueOf(element.getClass().getName()) + " is not assignable to " + requiredClass.getName());
        }
        Element castElement = element;
        return (T)castElement;
    }

    public Type getPivotType(@NonNull EObject eObject) {
        Element pivotElement = this.newCreateMap.get(eObject);
        if (pivotElement == null) {
            Ecore2Pivot converter;
            Resource resource = eObject.eResource();
            if (resource != this.ecoreResource && resource != null && this.allConverters.add(converter = Ecore2Pivot.getAdapter(resource, this.metaModelManager))) {
                converter.getPivotRoot();
                for (Map.Entry<EObject, Element> entry : converter.newCreateMap.entrySet()) {
                    this.newCreateMap.put(entry.getKey(), entry.getValue());
                }
            }
            pivotElement = this.newCreateMap.get(eObject);
        }
        if (pivotElement == null) {
            this.error("Unresolved " + eObject);
        } else if (!(pivotElement instanceof Type)) {
            this.error("Incompatible " + eObject);
        } else {
            return (Type)pivotElement;
        }
        return null;
    }

    @NonNull
    public Root getPivotRoot() {
        Root pivotRoot2 = this.pivotRoot;
        if (pivotRoot2 == null) {
            pivotRoot2 = this.pivotRoot = this.importObjects((Collection)DomainUtil.nonNullEMF((Object)this.ecoreResource.getContents()), this.createPivotURI());
            Resource pivotResource = pivotRoot2.eResource();
            AliasAdapter ecoreAdapter = AliasAdapter.findAdapter(this.ecoreResource);
            if (ecoreAdapter != null) {
                Map<EObject, String> ecoreAliasMap = ecoreAdapter.getAliasMap();
                AliasAdapter pivotAdapter = AliasAdapter.getAdapter(pivotResource);
                Map<EObject, String> pivotAliasMap = pivotAdapter.getAliasMap();
                for (EObject eObject : ecoreAliasMap.keySet()) {
                    String alias = ecoreAliasMap.get(eObject);
                    Element element = this.newCreateMap.get(eObject);
                    pivotAliasMap.put(element, alias);
                }
            }
            this.metaModelManager.installResource(pivotResource);
            this.installImports();
        }
        return pivotRoot2;
    }

    @Override
    @Nullable
    public Resource getResource() {
        return this.ecoreResource;
    }

    @Nullable
    public Notifier getTarget() {
        return this.ecoreResource;
    }

    @Override
    @NonNull
    public URI getURI() {
        return (URI)DomainUtil.nonNullEMF((Object)this.ecoreResource.getURI());
    }

    @NonNull
    public Root importObjects(@NonNull Collection<EObject> ecoreContents, @NonNull URI pivotURI) {
        EObject eObject;
        String nsURI;
        Resource pivotResource = this.metaModelManager.getResource(pivotURI, "org.eclipse.ocl.examples.pivot");
        if (this.metaModelManager.getLibraryResource() == null && this.isPivot(ecoreContents) && (nsURI = ((EPackage)ecoreContents.iterator().next()).getNsURI()) != null) {
            String stdlibUri = "http://www.eclipse.org/ocl/3.1.0/OCL.oclstdlib";
            OCLstdlib library = OCLstdlib.create(stdlibUri, "ocl", "ocl", nsURI);
            this.metaModelManager.installResource((Resource)library);
        }
        URI uri = this.ecoreURI != null ? this.ecoreURI : this.ecoreResource.getURI();
        Root pivotRoot2 = null;
        if (pivotResource.getContents().size() > 0 && (eObject = (EObject)pivotResource.getContents().get(0)) instanceof Root) {
            pivotRoot2 = (Root)eObject;
        }
        if (pivotRoot2 == null) {
            pivotRoot2 = this.pivotRoot = this.metaModelManager.createRoot(pivotURI.lastSegment(), uri.toString());
        }
        this.pivotRoot = pivotRoot2;
        this.update(pivotResource, ecoreContents);
        if (this.errors != null) {
            pivotResource.getErrors().addAll(this.errors);
        }
        return pivotRoot2;
    }

    public void initializeEcore2PivotMap() {
        this.ecore2PivotMap.put((EClassifier)EcorePackage.Literals.EBOOLEAN, this.metaModelManager.getBooleanType());
        this.ecore2PivotMap.put((EClassifier)EcorePackage.Literals.EBIG_INTEGER, this.metaModelManager.getIntegerType());
        this.ecore2PivotMap.put((EClassifier)EcorePackage.Literals.EBIG_DECIMAL, this.metaModelManager.getRealType());
        this.ecore2PivotMap.put((EClassifier)EcorePackage.Literals.ESTRING, this.metaModelManager.getStringType());
    }

    protected void installImports() {
        URI baseURI = this.getURI();
        if (!baseURI.isHierarchical() || baseURI.isRelative()) {
            baseURI = null;
        }
        List<Import> allImports = this.pivotRoot.getImports();
        for (EObject eContent : this.ecoreResource.getContents()) {
            EAnnotation importAnnotation;
            if (!(eContent instanceof EModelElement) || (importAnnotation = ((EModelElement)eContent).getEAnnotation("http://www.eclipse.org/OCL/Import")) == null) continue;
            EMap details = importAnnotation.getDetails();
            for (String key : details.keySet()) {
                URI uri = URI.createURI((String)((String)details.get((Object)key)));
                if (baseURI != null) {
                    uri = uri.resolve(baseURI);
                }
                try {
                    assert (uri != null);
                    Element importedObject = this.metaModelManager.loadResource(uri, null, this.ecoreResource.getResourceSet());
                    if (!(importedObject instanceof Namespace)) continue;
                    Import anImport = PivotFactory.eINSTANCE.createImport();
                    anImport.setName(key);
                    anImport.setImportedNamespace((Namespace)importedObject);
                    allImports.add(anImport);
                }
                catch (ParserException e) {
                    this.error(e.getMessage());
                }
            }
        }
    }

    @Override
    public boolean isAdapterFor(@NonNull MetaModelManager metaModelManager) {
        return this.metaModelManager == metaModelManager;
    }

    public boolean isAdapterForType(Object type) {
        return type == Ecore2Pivot.class;
    }

    protected boolean isPivot(@NonNull Collection<EObject> ecoreContents) {
        if (ecoreContents.size() != 1) {
            return false;
        }
        EObject ecoreRoot = ecoreContents.iterator().next();
        if (!(ecoreRoot instanceof EPackage)) {
            return false;
        }
        EPackage ecorePackage = (EPackage)ecoreRoot;
        if (ecorePackage.getEClassifier(PivotPackage.Literals.ENUMERATION_LITERAL.getName()) == null) {
            return false;
        }
        if (ecorePackage.getEClassifier(PivotPackage.Literals.EXPRESSION_IN_OCL.getName()) == null) {
            return false;
        }
        if (ecorePackage.getEClassifier(PivotPackage.Literals.OPERATION_CALL_EXP.getName()) == null) {
            return false;
        }
        return ecorePackage.getEClassifier(PivotPackage.Literals.TEMPLATE_PARAMETER_SUBSTITUTION.getName()) != null;
    }

    @Override
    public void metaModelManagerDisposed(@NonNull MetaModelManager metaModelManager) {
        this.dispose();
    }

    public void notifyChanged(Notification notification) {
    }

    @Override
    public void queueReference(@NonNull EObject eObject) {
        this.referencers.add(eObject);
    }

    @Override
    @NonNull
    public <T extends NamedElement> T refreshElement(@NonNull java.lang.Class<T> pivotClass, EClass pivotEClass, @NonNull EModelElement eModelElement) {
        String id;
        Object pivotElement = null;
        if (this.oldIdMap != null && (id = ((XMLResource)eModelElement.eResource()).getID((EObject)eModelElement)) != null && (pivotElement = (EObject)this.oldIdMap.get(id)) != null && pivotElement.eClass() != pivotEClass) {
            pivotElement = null;
        }
        if (pivotElement == null) {
            EFactory eFactoryInstance = pivotEClass.getEPackage().getEFactoryInstance();
            pivotElement = eFactoryInstance.create(pivotEClass);
        }
        if (!pivotClass.isAssignableFrom(pivotElement.getClass())) {
            throw new ClassCastException();
        }
        NamedElement castElement = (NamedElement)pivotElement;
        Element oldElement = this.newCreateMap.put((EObject)eModelElement, castElement);
        assert (oldElement == null);
        return (T)castElement;
    }

    protected Type resolveDataType(@NonNull EDataType eClassifier) {
        Type pivotType = this.getEcore2PivotMap().get(eClassifier);
        if (pivotType == null) {
            pivotType = this.getPivotType((EObject)eClassifier);
        }
        return pivotType;
    }

    protected Type resolveGenericType(@NonNull Map<String, Type> resolvedSpecializations, @NonNull EGenericType eGenericType) {
        EList eTypeArguments = eGenericType.getETypeArguments();
        assert (!eGenericType.getETypeArguments().isEmpty());
        EClassifier eClassifier = eGenericType.getEClassifier();
        EList eTypeParameters = eClassifier.getETypeParameters();
        assert (eTypeParameters.size() == eTypeArguments.size());
        Type unspecializedPivotType = this.getPivotType((EObject)eClassifier);
        if (unspecializedPivotType == null) {
            return null;
        }
        ArrayList<Type> templateArguments = new ArrayList<Type>();
        for (EGenericType eTypeArgument : eTypeArguments) {
            if (eTypeArgument == null) continue;
            Type typeArgument = this.resolveType(resolvedSpecializations, eTypeArgument);
            templateArguments.add(typeArgument);
        }
        return this.metaModelManager.getLibraryType(unspecializedPivotType, templateArguments);
    }

    protected Type resolveSimpleType(@NonNull EClassifier eClassifier) {
        return this.getPivotType((EObject)eClassifier);
    }

    protected Type resolveType(@NonNull Map<String, Type> resolvedSpecializations, @NonNull EGenericType eGenericType) {
        Type pivotType = this.getCreated(Type.class, (EObject)eGenericType);
        if (pivotType != null) {
            return pivotType;
        }
        EClassifier eClassifier = eGenericType.getEClassifier();
        ETypeParameter eTypeParameter = eGenericType.getETypeParameter();
        EList eTypeArguments = eGenericType.getETypeArguments();
        if (eTypeParameter != null) {
            pivotType = this.resolveTypeParameter(eGenericType);
        } else if (eClassifier == null) {
            pivotType = this.resolveWildcardType(eGenericType);
        } else if (!eTypeArguments.isEmpty()) {
            String ecoreMoniker = Ecore2Moniker.toString(eGenericType);
            pivotType = resolvedSpecializations.get(ecoreMoniker);
            if (pivotType == null) {
                pivotType = this.resolveGenericType(resolvedSpecializations, eGenericType);
                resolvedSpecializations.put(ecoreMoniker, pivotType);
            }
        } else if (eClassifier instanceof EDataType) {
            assert (eGenericType.getETypeArguments().isEmpty());
            pivotType = this.resolveDataType((EDataType)eClassifier);
        } else {
            assert (eGenericType.getETypeArguments().isEmpty());
            pivotType = this.resolveSimpleType(eClassifier);
        }
        this.newCreateMap.put((EObject)eGenericType, pivotType);
        return pivotType;
    }

    protected Type resolveTypeParameter(@NonNull EGenericType eGenericType) {
        EClassifier eClassifier = eGenericType.getEClassifier();
        ETypeParameter eTypeParameter = eGenericType.getETypeParameter();
        EList eTypeArguments = eGenericType.getETypeArguments();
        assert (eClassifier == null);
        assert (eTypeArguments.isEmpty());
        Type pivotType = eTypeParameter != null ? this.getCreated(Type.class, (EObject)eTypeParameter) : null;
        return pivotType;
    }

    protected Type resolveWildcardType(@NonNull EGenericType eGenericType) {
        EObject eContainer;
        List list;
        int index;
        assert (eGenericType.getETypeArguments().isEmpty());
        assert (eGenericType.getEClassifier() == null);
        EClassifier eClassifier = eGenericType.getERawType();
        assert (eClassifier == EcorePackage.Literals.EJAVA_OBJECT);
        Class pivotElement = PivotFactory.eINSTANCE.createClass();
        String name = "wildcard";
        EReference eFeature = eGenericType.eContainmentFeature();
        if (eFeature != null && eFeature.isMany() && (index = (list = (List)(eContainer = eGenericType.eContainer()).eGet(eGenericType.eContainingFeature())).indexOf(eGenericType)) != 0) {
            name = String.valueOf(name) + index;
        }
        pivotElement.setName(name);
        return pivotElement;
    }

    public void setEcoreURI(URI ecoreURI) {
        this.ecoreURI = ecoreURI;
    }

    public void setTarget(Notifier newTarget) {
        assert (newTarget == null || newTarget == this.ecoreResource);
    }

    public void unsetTarget(Notifier oldTarget) {
        assert (oldTarget == this.ecoreResource);
    }

    public void update(@NonNull Resource pivotResource, @NonNull Collection<EObject> ecoreContents) {
        this.newCreateMap = new HashMap<EObject, Element>();
        this.referencers = new HashSet<EObject>();
        this.genericTypes = new ArrayList<EGenericType>();
        PivotUtil.refreshList(pivotResource.getContents(), Collections.singletonList(this.pivotRoot));
        ArrayList<Package> newPackages = new ArrayList<Package>();
        for (EObject eObject : ecoreContents) {
            EClass eClass = eObject.eClass();
            if (eClass.getEPackage() != EcorePackage.eINSTANCE) {
                this.error("Non Ecore " + eClass.getName() + " for Ecore2Pivot.update");
                continue;
            }
            Object pivotElement = this.declarationPass.doInPackageSwitch(eObject);
            if (pivotElement instanceof Package) {
                newPackages.add((Package)pivotElement);
                continue;
            }
            this.error("Bad ecore content");
        }
        PivotUtil.refreshList(this.pivotRoot.getNestedPackage(), newPackages);
        HashMap<String, Type> resolvedSpecializations = new HashMap<String, Type>();
        for (EGenericType eGenericType : this.genericTypes) {
            if (eGenericType == null) continue;
            Type pivotType = this.resolveType(resolvedSpecializations, eGenericType);
            this.newCreateMap.put((EObject)eGenericType, pivotType);
        }
        for (EObject eObject : this.referencers) {
            this.referencePass.doInPackageSwitch(eObject);
        }
        HashSet<Property> redundantOpposites = null;
        for (EObject eObject : this.referencers) {
            List<Property> ambiguousOpposites;
            Property oppositeProperty;
            Property pivotElement;
            if (!(eObject instanceof EReference) || (pivotElement = this.getCreated(Property.class, eObject)) == null || (oppositeProperty = pivotElement.getOpposite()) != null || !(eObject.eContainer() instanceof EClass) || (ambiguousOpposites = this.metaModelManager.installPropertyDeclaration(pivotElement)) == null) continue;
            if (redundantOpposites == null) {
                redundantOpposites = new HashSet<Property>();
            }
            redundantOpposites.addAll(ambiguousOpposites);
        }
        if (redundantOpposites != null) {
            for (Property redundantOpposite : redundantOpposites) {
                Property oppositeOpposite = redundantOpposite.getOpposite();
                oppositeOpposite.setOpposite(null);
                redundantOpposite.setOpposite(null);
                redundantOpposite.getOwningType().getOwnedAttribute().remove(redundantOpposite);
            }
        }
        this.referencers = null;
        this.genericTypes = null;
        this.oldIdMap = new HashMap<String, Element>();
        for (EObject ecoreContent : ecoreContents) {
            Element element;
            Resource resource = ecoreContent.eResource();
            if (!(resource instanceof XMLResource)) continue;
            XMLResource xmlResource = (XMLResource)resource;
            String id = xmlResource.getID(ecoreContent);
            if (id != null && (element = this.newCreateMap.get(ecoreContent)) != null) {
                this.oldIdMap.put(id, element);
            }
            TreeIterator tit = ecoreContent.eAllContents();
            while (tit.hasNext()) {
                Element element2;
                EObject eObject = (EObject)tit.next();
                id = xmlResource.getID(eObject);
                if (id == null || (element2 = this.newCreateMap.get(eObject)) == null) continue;
                this.oldIdMap.put(id, element2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Factory
    extends MetaModelManager.AbstractFactory {
        private Factory() {
            MetaModelManager.addFactory(this);
        }

        @Override
        public int getHandlerPriority(@NonNull EObject eObject) {
            if (eObject instanceof ENamedElement) {
                return 0;
            }
            if (eObject instanceof DynamicEObjectImpl) {
                return 0;
            }
            return -100;
        }

        @Override
        public int getHandlerPriority(@NonNull Resource resource) {
            return Ecore2Pivot.isEcore(resource) ? 0 : -100;
        }

        @Override
        public void configure(@NonNull ResourceSet resourceSet) {
        }

        @Override
        @Nullable
        public URI getPackageURI(@NonNull EObject eObject) {
            String uri;
            if (eObject instanceof EPackage && (uri = ((EPackage)eObject).getNsURI()) != null) {
                return URI.createURI((String)uri);
            }
            return null;
        }

        @Override
        public <T extends Element> T getPivotOf(@NonNull MetaModelManager metaModelManager, @NonNull java.lang.Class<T> pivotClass, @NonNull EObject eObject) {
            return metaModelManager.getPivotOfEcore(pivotClass, eObject);
        }

        @Override
        @Nullable
        public Element importFromResource(@NonNull MetaModelManager metaModelManager, @NonNull Resource ecoreResource, @Nullable URI uri) {
            String uriFragment;
            Ecore2Pivot conversion = Ecore2Pivot.getAdapter(ecoreResource, metaModelManager);
            conversion.setEcoreURI(uri);
            Root pivotRoot = conversion.getPivotRoot();
            String string = uriFragment = uri != null ? uri.fragment() : null;
            if (uriFragment == null) {
                return pivotRoot;
            }
            EObject eObject = ecoreResource.getEObject(uriFragment);
            if (eObject == null) {
                return null;
            }
            return (Element)conversion.newCreateMap.get(eObject);
        }
    }
}

