/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.internal.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.SetValue;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.library.classifier.OclTypeConformsToOperation;
import org.eclipse.ocl.examples.library.collection.CollectionSizeOperation;
import org.eclipse.ocl.examples.library.ecore.EcoreExecutorManager;
import org.eclipse.ocl.examples.library.oclany.OclAnyEqualOperation;
import org.eclipse.ocl.examples.library.oclany.OclAnyOclAsSetOperation;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.IterateExp;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.PivotTables;
import org.eclipse.ocl.examples.pivot.ReferringElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.internal.impl.LoopExpImpl;
import org.eclipse.ocl.examples.pivot.util.Visitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterateExpImpl
extends LoopExpImpl
implements IterateExp {
    protected Variable result;

    protected IterateExpImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PivotPackage.Literals.ITERATE_EXP;
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    public NotificationChain basicSetResult(Variable newResult, NotificationChain msgs) {
        Variable oldResult = this.result;
        this.result = newResult;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldResult, (Object)newResult);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setResult(Variable newResult) {
        if (newResult != this.result) {
            NotificationChain msgs = null;
            if (this.result != null) {
                msgs = ((InternalEObject)this.result).eInverseRemove((InternalEObject)this, -13, null, msgs);
            }
            if (newResult != null) {
                msgs = ((InternalEObject)newResult).eInverseAdd((InternalEObject)this, -13, null, msgs);
            }
            if ((msgs = this.basicSetResult(newResult, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)newResult, (Object)newResult));
        }
    }

    @Override
    public Variable createResult() {
        Variable newResult = (Variable)this.create(PivotPackage.Literals.VARIABLE);
        this.setResult(newResult);
        return newResult;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getOwnedComment()).basicRemove((Object)otherEnd, msgs);
            }
            case 1: {
                return ((InternalEList)this.getExtension()).basicRemove((Object)otherEnd, msgs);
            }
            case 4: {
                return ((InternalEList)this.getOwnedAnnotation()).basicRemove((Object)otherEnd, msgs);
            }
            case 7: {
                return this.basicSetSource(null, msgs);
            }
            case 9: {
                return this.basicSetBody(null, msgs);
            }
            case 10: {
                return ((InternalEList)this.getIterator()).basicRemove((Object)otherEnd, msgs);
            }
            case 12: {
                return this.basicSetResult(null, msgs);
            }
        }
        return this.eDynamicInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getOwnedComment();
            }
            case 1: {
                return this.getExtension();
            }
            case 2: {
                return this.getName();
            }
            case 3: {
                return this.isStatic();
            }
            case 4: {
                return this.getOwnedAnnotation();
            }
            case 5: {
                if (resolve) {
                    return this.getType();
                }
                return this.basicGetType();
            }
            case 6: {
                return this.isRequired();
            }
            case 7: {
                return this.getSource();
            }
            case 8: {
                return this.isImplicit();
            }
            case 9: {
                return this.getBody();
            }
            case 10: {
                return this.getIterator();
            }
            case 11: {
                if (resolve) {
                    return this.getReferredIteration();
                }
                return this.basicGetReferredIteration();
            }
            case 12: {
                return this.getResult();
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getOwnedComment().clear();
                this.getOwnedComment().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getExtension().clear();
                this.getExtension().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.setName((String)newValue);
                return;
            }
            case 3: {
                this.setIsStatic((Boolean)newValue);
                return;
            }
            case 4: {
                this.getOwnedAnnotation().clear();
                this.getOwnedAnnotation().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setType((Type)newValue);
                return;
            }
            case 6: {
                this.setIsRequired((Boolean)newValue);
                return;
            }
            case 7: {
                this.setSource((OCLExpression)newValue);
                return;
            }
            case 8: {
                this.setImplicit((Boolean)newValue);
                return;
            }
            case 9: {
                this.setBody((OCLExpression)newValue);
                return;
            }
            case 10: {
                this.getIterator().clear();
                this.getIterator().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.setReferredIteration((Iteration)newValue);
                return;
            }
            case 12: {
                this.setResult((Variable)newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getOwnedComment().clear();
                return;
            }
            case 1: {
                this.getExtension().clear();
                return;
            }
            case 2: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.setIsStatic(false);
                return;
            }
            case 4: {
                this.getOwnedAnnotation().clear();
                return;
            }
            case 5: {
                this.setType(null);
                return;
            }
            case 6: {
                this.setIsRequired(true);
                return;
            }
            case 7: {
                this.setSource(null);
                return;
            }
            case 8: {
                this.setImplicit(false);
                return;
            }
            case 9: {
                this.setBody(null);
                return;
            }
            case 10: {
                this.getIterator().clear();
                return;
            }
            case 11: {
                this.setReferredIteration(null);
                return;
            }
            case 12: {
                this.setResult(null);
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.ownedComment != null && !this.ownedComment.isEmpty();
            }
            case 1: {
                return this.extension != null && !this.extension.isEmpty();
            }
            case 2: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 3: {
                return (this.eFlags & 0x100) != 0;
            }
            case 4: {
                return this.ownedAnnotation != null && !this.ownedAnnotation.isEmpty();
            }
            case 5: {
                return this.type != null;
            }
            case 6: {
                return (this.eFlags & 0x200) == 0;
            }
            case 7: {
                return this.source != null;
            }
            case 8: {
                return (this.eFlags & 0x400) != 0;
            }
            case 9: {
                return this.body != null;
            }
            case 10: {
                return this.iterator != null && !this.iterator.isEmpty();
            }
            case 11: {
                return this.referredIteration != null;
            }
            case 12: {
                return this.result != null;
            }
        }
        return this.eDynamicIsSet(featureID);
    }

    public int eDerivedOperationID(int baseOperationID, Class<?> baseClass) {
        if (baseClass == ReferringElement.class) {
            switch (baseOperationID) {
                case 0: {
                    return 4;
                }
            }
            return -1;
        }
        return super.eDerivedOperationID(baseOperationID, baseClass);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.allOwnedElements();
            }
            case 1: {
                return this.getValue((Type)arguments.get(0), (String)arguments.get(1));
            }
            case 2: {
                return this.validateSourceIsCollection((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 3: {
                return this.validateNoInitializers((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 4: {
                return this.getReferredElement();
            }
            case 5: {
                return this.validateOneInitializer((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 6: {
                return this.validateBodyTypeConformsToResultType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 7: {
                return this.validateTypeIsResultType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
        }
        return this.eDynamicInvoke(operationID, arguments);
    }

    @Override
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitIterateExp(this);
    }

    @Override
    public Element getReferredElement() {
        return this.getReferredIteration();
    }

    @Override
    public boolean validateTypeIsResultType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_eq;
        IterateExpImpl self = this;
        try {
            Type type = self.getType();
            Variable result = self.getResult();
            if (result == null) {
                throw new InvalidValueException("Null source", new Object[0]);
            }
            Type type_0 = result.getType();
            Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)type, (Object)type_0);
            CAUGHT_eq = eq;
        }
        catch (Exception e) {
            CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_eq == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IterateExp", "TypeIsResultType", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 14, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateBodyTypeConformsToResultType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_conformsTo;
        IterateExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        try {
            OCLExpression body = self.getBody();
            DomainType type = body.getType();
            Variable result = self.getResult();
            if (result == null) {
                throw new InvalidValueException("Null source", new Object[0]);
            }
            Type type_0 = result.getType();
            Boolean conformsTo = OclTypeConformsToOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type, (Object)type_0);
            CAUGHT_conformsTo = conformsTo;
        }
        catch (Exception e) {
            CAUGHT_conformsTo = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_conformsTo == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IterateExp", "BodyTypeConformsToResultType", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 13, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateOneInitializer(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_eq;
        IterateExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        try {
            Variable result = self.getResult();
            if (result == null) {
                throw new InvalidValueException("Null source", new Object[0]);
            }
            OCLExpression initExpression = result.getInitExpression();
            SetValue oclAsSet = OclAnyOclAsSetOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (TypeId)PivotTables.SET_CLSSid_OCLExpression, (Object)initExpression);
            IntegerValue size = CollectionSizeOperation.INSTANCE.evaluate((Object)oclAsSet);
            Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)size, (Object)PivotTables.INT_1);
            CAUGHT_eq = eq;
        }
        catch (Exception e) {
            CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_eq == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IterateExp", "OneInitializer", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 12, message, new Object[]{this}));
        }
        return false;
    }
}

