/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.library;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.ocl.examples.pivot.library.StandardLibraryContribution;
import org.eclipse.ocl.examples.pivot.util.PivotPlugin;

public class StandardLibraryRegistryReader
extends RegistryReader {
    static final String TAG_LIBRARY = "library";
    static final String ATT_URI = "uri";
    static final String ATT_CLASS = "class";

    public StandardLibraryRegistryReader() {
        super(Platform.getExtensionRegistry(), PivotPlugin.getPlugin().getBundle().getSymbolicName(), "standard_library");
    }

    protected boolean readElement(IConfigurationElement element, boolean add) {
        if (element.getName().equals(TAG_LIBRARY)) {
            String uri = element.getAttribute(ATT_URI);
            if (uri == null) {
                this.logMissingAttribute(element, ATT_URI);
            } else if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
            } else {
                if (add) {
                    StandardLibraryContribution.Descriptor previous = StandardLibraryContribution.REGISTRY.put(uri, new StandardLibraryContribution.Descriptor(element, ATT_CLASS));
                    if (previous instanceof StandardLibraryContribution.Descriptor) {
                        StandardLibraryContribution.Descriptor descriptor = previous;
                        EcorePlugin.INSTANCE.log((Object)("Both '" + descriptor.getElement().getContributor().getName() + "' and '" + element.getContributor().getName() + "' register a setting delegate factory for '" + uri + "'"));
                    }
                    return true;
                }
                StandardLibraryContribution.REGISTRY.remove(uri);
                return true;
            }
        }
        return false;
    }
}

