/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagedAdapter;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMetaModelManagerResourceAdapter<T extends Resource>
implements MetaModelManagedAdapter {
    @NonNull
    protected final T resource;
    @NonNull
    protected final MetaModelManager metaModelManager;

    public static void disposeAll(@NonNull Resource resource) {
        EList eAdapters = resource.eAdapters();
        int i = eAdapters.size();
        while (--i >= 0) {
            Adapter adapter = (Adapter)eAdapters.get(i);
            if (!(adapter instanceof AbstractMetaModelManagerResourceAdapter)) continue;
            eAdapters.remove(i);
        }
    }

    @Nullable
    public static AbstractMetaModelManagerResourceAdapter<?> findAdapter(@NonNull Resource resource) {
        return PivotUtil.getAdapter(AbstractMetaModelManagerResourceAdapter.class, (Notifier)resource);
    }

    public AbstractMetaModelManagerResourceAdapter(@NonNull T resource, @NonNull MetaModelManager metaModelManager) {
        this.resource = resource;
        this.metaModelManager = metaModelManager;
        metaModelManager.addListener(this);
    }

    public void dispose() {
        this.resource.eAdapters().remove((Object)this);
        this.metaModelManager.removeListener(this);
    }

    @NonNull
    public MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    public T getTarget() {
        return this.resource;
    }

    @Override
    public boolean isAdapterFor(@NonNull MetaModelManager metaModelManager) {
        return this.metaModelManager == metaModelManager;
    }

    public boolean isAdapterForType(Object type) {
        return type == AbstractMetaModelManagerResourceAdapter.class;
    }

    @Override
    public void metaModelManagerDisposed(@NonNull MetaModelManager metaModelManager) {
        this.dispose();
    }

    public void notifyChanged(Notification notification) {
    }

    public void setTarget(Notifier newTarget) {
        assert (newTarget == this.resource);
    }

    public void unsetTarget(Notifier oldTarget) {
        assert (oldTarget == this.resource);
    }
}

