/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainElement;
import org.eclipse.ocl.examples.domain.elements.DomainFragment;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainProperty;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypeParameters;
import org.eclipse.ocl.examples.domain.ids.OperationId;
import org.eclipse.ocl.examples.domain.ids.ParametersId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.types.AbstractFragment;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.library.executor.ExecutorPackage;
import org.eclipse.ocl.examples.library.executor.ExecutorTypeParameter;
import org.eclipse.ocl.examples.library.executor.ReflectiveType;
import org.eclipse.ocl.examples.pivot.Behavior;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.ElementExtension;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Region;
import org.eclipse.ocl.examples.pivot.State;
import org.eclipse.ocl.examples.pivot.StateMachine;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.Vertex;
import org.eclipse.ocl.examples.pivot.executor.PivotReflectiveFragment;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.PackageManager;
import org.eclipse.ocl.examples.pivot.manager.PackageServer;
import org.eclipse.ocl.examples.pivot.manager.TypeServer;
import org.eclipse.ocl.examples.pivot.scoping.EnvironmentView;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTypeServer
extends ReflectiveType
implements TypeServer {
    @NonNull
    public static final BestOperation bestOperation = new BestOperation();
    @NonNull
    public static final MapValues MAP_VALUES = new MapValues();
    @NonNull
    protected final PackageServer packageServer;
    @NonNull
    protected final PackageManager packageManager;
    @Nullable
    private Map<String, DomainInheritance> name2superclasses = null;
    @Nullable
    private Map<String, List<String>> name2qualifiedNames = null;
    @Nullable
    private Map<String, Map<ParametersId, List<DomainOperation>>> name2operations = null;
    @Nullable
    private Map<String, PartialProperties> name2properties = null;
    @Nullable
    private Map<String, State> name2states = null;
    @NonNull
    protected final DomainType domainType;
    @Nullable
    protected TypeId typeId = null;

    @NonNull
    public static TemplateParameterSubstitution createTemplateParameterSubstitution(@NonNull TemplateParameter formalParameter, @NonNull ParameterableElement type) {
        TemplateParameterSubstitution templateParameterSubstitution = PivotFactory.eINSTANCE.createTemplateParameterSubstitution();
        templateParameterSubstitution.setFormal(formalParameter);
        if (type.eResource() == null) {
            templateParameterSubstitution.setOwnedActual(type);
        } else {
            templateParameterSubstitution.setActual(type);
        }
        return templateParameterSubstitution;
    }

    protected AbstractTypeServer(@NonNull PackageServer packageServer, @NonNull DomainType domainType) {
        super((String)DomainUtil.nonNullModel((Object)domainType.getName()), (ExecutorPackage)packageServer, AbstractTypeServer.computeFlags((DomainType)domainType), new ExecutorTypeParameter[0]);
        this.packageServer = packageServer;
        this.packageManager = packageServer.getPackageManager();
        this.domainType = domainType;
    }

    void addedMemberOperation(@NonNull DomainOperation pivotOperation) {
        Map<String, Map<ParametersId, List<DomainOperation>>> name2operations2 = this.name2operations;
        if (name2operations2 != null) {
            ParametersId parametersId;
            List<DomainOperation> partials;
            String operationName = pivotOperation.getName();
            Map<ParametersId, List<DomainOperation>> overloads = name2operations2.get(operationName);
            if (overloads == null) {
                overloads = new HashMap<ParametersId, List<DomainOperation>>();
                name2operations2.put(operationName, overloads);
            }
            if ((partials = overloads.get(parametersId = pivotOperation.getParametersId())) == null) {
                partials = new ArrayList<DomainOperation>();
                overloads.put(parametersId, partials);
            }
            if (!partials.contains(pivotOperation)) {
                partials.add(pivotOperation);
            }
        }
    }

    void addedMemberProperty(@NonNull DomainProperty pivotProperty) {
        Map<String, PartialProperties> name2properties2 = this.name2properties;
        if (name2properties2 != null) {
            String propertyName = pivotProperty.getName();
            PartialProperties partials = name2properties2.get(propertyName);
            if (partials == null) {
                partials = new PartialProperties();
                name2properties2.put(propertyName, partials);
            }
            partials.add(pivotProperty);
        }
    }

    void changedInheritance() {
        this.uninstall();
    }

    @NonNull
    protected AbstractFragment createFragment(@NonNull DomainInheritance baseInheritance) {
        return new PivotReflectiveFragment(this, baseInheritance);
    }

    @Override
    public void dispose() {
        Map<String, Map<ParametersId, List<DomainOperation>>> name2operations2;
        Map<String, PartialProperties> name2properties2 = this.name2properties;
        if (name2properties2 != null) {
            name2properties2.clear();
            this.name2properties = null;
        }
        if ((name2operations2 = this.name2operations) != null) {
            name2operations2.clear();
            this.name2operations = null;
        }
    }

    @Override
    @NonNull
    public Iterable<? extends DomainOperation> getAllOperations(boolean selectStatic) {
        Map<String, Map<ParametersId, List<DomainOperation>>> name2operations2 = this.name2operations;
        if (name2operations2 == null) {
            name2operations2 = this.initMemberOperations();
        }
        Collection<Map<ParametersId, List<DomainOperation>>> itMapListOps = name2operations2.values();
        Iterable itItListOps = Iterables.transform(itMapListOps, (Function)MAP_VALUES);
        Iterable itListOps = Iterables.concat((Iterable)itItListOps);
        Iterable itOps = Iterables.concat((Iterable)itListOps);
        Iterable subItOps = Iterables.filter((Iterable)itOps, (Predicate)(selectStatic ? SELECT_STATIC_OPERATION : REJECT_STATIC_OPERATION));
        return subItOps;
    }

    @Override
    @NonNull
    public Iterable<? extends DomainOperation> getAllOperations(boolean selectStatic, @NonNull String name) {
        Map<ParametersId, List<DomainOperation>> overloads;
        Map<String, Map<ParametersId, List<DomainOperation>>> name2operations2 = this.name2operations;
        if (name2operations2 == null) {
            name2operations2 = this.initMemberOperations();
        }
        if ((overloads = name2operations2.get(name)) == null || overloads.isEmpty()) {
            return MetaModelManager.EMPTY_OPERATION_LIST;
        }
        Iterable transform = Iterables.concat(overloads.values());
        Iterable subItOps = Iterables.filter((Iterable)transform, (Predicate)(selectStatic ? SELECT_STATIC_OPERATION : REJECT_STATIC_OPERATION));
        return subItOps;
    }

    @Override
    @NonNull
    public Iterable<? extends DomainProperty> getAllProperties(boolean selectStatic) {
        Map<String, PartialProperties> name2properties2 = this.name2properties;
        if (name2properties2 == null) {
            name2properties2 = this.initMemberProperties();
        }
        Iterable transform = Iterables.transform(name2properties2.values(), (Function)new Function<PartialProperties, DomainProperty>(){

            public DomainProperty apply(PartialProperties properties) {
                return properties.get();
            }
        });
        Iterable subItOps = Iterables.filter((Iterable)transform, (Predicate)(selectStatic ? SELECT_STATIC_PROPERTY : REJECT_STATIC_PROPERTY));
        return subItOps;
    }

    @Override
    @NonNull
    public Iterable<? extends DomainProperty> getAllProperties(boolean selectStatic, @NonNull String name) {
        PartialProperties partials;
        Map<String, PartialProperties> name2properties2 = this.name2properties;
        if (name2properties2 == null) {
            name2properties2 = this.initMemberProperties();
        }
        if ((partials = name2properties2.get(name)) == null || partials.isEmpty()) {
            return MetaModelManager.EMPTY_PROPERTY_LIST;
        }
        Iterable subItOps = Iterables.filter((Iterable)partials, (Predicate)(selectStatic ? SELECT_STATIC_PROPERTY : REJECT_STATIC_PROPERTY));
        return subItOps;
    }

    @Override
    @NonNull
    public Iterable<? extends State> getAllStates() {
        Map<String, State> name2states2 = this.name2states;
        if (name2states2 == null) {
            name2states2 = this.initStates();
        }
        Collection<State> values = name2states2.values();
        return values;
    }

    @Override
    @NonNull
    public Iterable<? extends State> getAllStates(@NonNull String name) {
        State state;
        Map<String, State> name2states2 = this.name2states;
        if (name2states2 == null) {
            name2states2 = this.initStates();
        }
        if ((state = name2states2.get(name)) == null) {
            return MetaModelManager.EMPTY_STATE_LIST;
        }
        List<State> singletonList = Collections.singletonList(state);
        return singletonList;
    }

    @Override
    @NonNull
    public Iterable<? extends DomainInheritance> getAllSuperClasses() {
        Map<String, DomainInheritance> name2superclasses2 = this.name2superclasses;
        if (name2superclasses2 == null) {
            name2superclasses2 = this.initSuperClasses();
        }
        Collection<DomainInheritance> values = name2superclasses2.values();
        return values;
    }

    @Override
    @NonNull
    public Iterable<? extends DomainInheritance> getAllSuperClasses(@NonNull String className) {
        Map<String, List<String>> name2qualifiedNames2;
        Map<String, DomainInheritance> name2superclasses2 = this.name2superclasses;
        if (name2superclasses2 == null) {
            name2superclasses2 = this.initSuperClasses();
        }
        if ((name2qualifiedNames2 = this.name2qualifiedNames) == null) {
            DomainInheritance typeServer = name2superclasses2.get(className);
            if (typeServer == null) {
                return MetaModelManager.EMPTY_TYPE_SERVER_LIST;
            }
            List<DomainInheritance> asList = Arrays.asList(typeServer);
            return asList;
        }
        List<String> qualifiedNames = name2qualifiedNames2.get(className);
        if (qualifiedNames == null) {
            return MetaModelManager.EMPTY_TYPE_SERVER_LIST;
        }
        Iterable transform = Iterables.transform(qualifiedNames, (Function)new QualifiedName2DomainInheritance(name2superclasses2));
        return transform;
    }

    @NonNull
    protected Map<String, State> initStates() {
        HashMap<String, State> name2states = new HashMap<String, State>();
        for (DomainInheritance domainInheritance : this.getAllSuperClasses()) {
            TypeServer superTypeServer = null;
            if (domainInheritance instanceof TypeServer) {
                superTypeServer = (TypeServer)domainInheritance;
            } else if (domainInheritance != null) {
                superTypeServer = this.packageManager.getTypeServer((DomainType)domainInheritance);
            }
            if (superTypeServer == null) continue;
            for (DomainType domainType : superTypeServer.getPartialTypes()) {
                assert (domainType != null);
                if (!(domainType instanceof Class)) continue;
                Class superClass = (Class)domainType;
                for (Behavior behavior : superClass.getOwnedBehavior()) {
                    if (!(behavior instanceof StateMachine)) continue;
                    List<Region> regions = ((StateMachine)behavior).getRegion();
                    this.initStatesForRegions(name2states, regions);
                }
            }
        }
        return name2states;
    }

    protected void initStatesForRegions(@NonNull Map<String, State> name2states, @NonNull List<Region> regions) {
        for (Region region : regions) {
            for (Vertex vertex : region.getSubvertex()) {
                if (!(vertex instanceof State)) continue;
                State state = (State)vertex;
                name2states.put(vertex.getName(), state);
                List<Region> nestedRegions = state.getRegion();
                this.initStatesForRegions(name2states, nestedRegions);
            }
        }
    }

    @NonNull
    public Iterable<? extends DomainInheritance> getInitialSuperInheritances() {
        final MetaModelManager metaModelManager = this.packageManager.getMetaModelManager();
        final Iterator<Type> iterator = metaModelManager.getSuperClasses(this.getPivotType()).iterator();
        return new Iterable<DomainInheritance>(){

            @Override
            public Iterator<DomainInheritance> iterator() {
                return new Iterator<DomainInheritance>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public DomainInheritance next() {
                        return ((Type)iterator.next()).getInheritance((DomainStandardLibrary)metaModelManager);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @NonNull
    public List<? extends DomainOperation> getLocalOperations() {
        return (List)DomainUtil.nonNullEMF(this.getPivotType().getOwnedOperation());
    }

    @NonNull
    public List<? extends DomainProperty> getLocalProperties() {
        return (List)DomainUtil.nonNullEMF(this.getPivotType().getOwnedAttribute());
    }

    @NonNull
    public List<? extends DomainType> getLocalSuperTypes() {
        return (List)DomainUtil.nonNullEMF(this.getPivotType().getSuperClass());
    }

    @Nullable
    public DomainOperation getMemberOperation(@NonNull OperationId operationId) {
        String operationName;
        Map<ParametersId, List<DomainOperation>> overloads;
        Map<String, Map<ParametersId, List<DomainOperation>>> name2operations2 = this.name2operations;
        if (name2operations2 == null) {
            name2operations2 = this.initMemberOperations();
        }
        if ((overloads = name2operations2.get(operationName = operationId.getName())) == null) {
            return null;
        }
        ParametersId parametersId = operationId.getParametersId();
        List<DomainOperation> partials = overloads.get(parametersId);
        return partials == null || partials.isEmpty() ? null : partials.get(0);
    }

    @Override
    @Nullable
    public DomainOperation getMemberOperation(@NonNull DomainOperation pivotOperation) {
        String operationName;
        Map<ParametersId, List<DomainOperation>> overloads;
        Map<String, Map<ParametersId, List<DomainOperation>>> name2operations2 = this.name2operations;
        if (name2operations2 == null) {
            name2operations2 = this.initMemberOperations();
        }
        if ((overloads = name2operations2.get(operationName = pivotOperation.getName())) == null) {
            return null;
        }
        ParametersId parametersId = pivotOperation.getParametersId();
        List<DomainOperation> partials = overloads.get(parametersId);
        return partials == null || partials.isEmpty() ? null : partials.get(0);
    }

    @Nullable
    public Iterable<DomainOperation> getMemberOperations(@NonNull DomainOperation pivotOperation) {
        String operationName;
        Map<ParametersId, List<DomainOperation>> overloads;
        Map<String, Map<ParametersId, List<DomainOperation>>> name2operations2 = this.name2operations;
        if (name2operations2 == null) {
            name2operations2 = this.initMemberOperations();
        }
        if ((overloads = name2operations2.get(operationName = pivotOperation.getName())) == null) {
            return null;
        }
        ParametersId parametersId = pivotOperation.getParametersId();
        return overloads.get(parametersId);
    }

    @Nullable
    public Iterable<DomainProperty> getMemberProperties(@NonNull DomainProperty pivotProperty) {
        Map<String, PartialProperties> name2properties2 = this.name2properties;
        if (name2properties2 == null) {
            name2properties2 = this.initMemberProperties();
        }
        String propertyName = pivotProperty.getName();
        return name2properties2.get(propertyName);
    }

    @Override
    @Nullable
    public DomainProperty getMemberProperty(@NonNull String propertyName) {
        PartialProperties partials;
        Map<String, PartialProperties> name2properties2 = this.name2properties;
        if (name2properties2 == null) {
            name2properties2 = this.initMemberProperties();
        }
        if ((partials = name2properties2.get(propertyName)) == null) {
            return null;
        }
        return partials.get();
    }

    @NonNull
    public String getMetaTypeName() {
        return this.getPivotType().getMetaTypeName();
    }

    @NonNull
    public List<? extends DomainProperty> getOwnedAttribute() {
        return (List)DomainUtil.nonNullEMF(this.getPivotType().getOwnedAttribute());
    }

    @NonNull
    public List<? extends DomainOperation> getOwnedOperation() {
        return (List)DomainUtil.nonNullEMF(this.getPivotType().getOwnedOperation());
    }

    @NonNull
    public final PackageManager getPackageManager() {
        return this.packageManager;
    }

    public PackageServer getPackageServer() {
        return this.packageServer;
    }

    @NonNull
    public final DomainStandardLibrary getStandardLibrary() {
        return this.packageManager.getMetaModelManager();
    }

    @NonNull
    public final TypeId getTypeId() {
        TypeId typeId2 = this.typeId;
        if (typeId2 == null) {
            this.typeId = typeId2 = this.domainType.getTypeId();
        }
        return typeId2;
    }

    @NonNull
    public DomainTypeParameters getTypeParameters() {
        return DomainTypeParameters.EMPTY_LIST;
    }

    protected void initMemberFeaturesFrom(@NonNull DomainType pivotType) {
        if (this.name2operations != null) {
            this.initMemberOperationsFrom(pivotType);
        }
        if (this.name2properties != null) {
            this.initMemberPropertiesFrom(pivotType);
        }
    }

    @NonNull
    private Map<String, Map<ParametersId, List<DomainOperation>>> initMemberOperations() {
        Map<String, Map<ParametersId, List<DomainOperation>>> name2operations2 = this.name2operations;
        if (name2operations2 == null) {
            name2operations2 = this.name2operations = new HashMap<String, Map<ParametersId, List<DomainOperation>>>();
            for (DomainInheritance domainInheritance : this.getAllSuperClasses()) {
                TypeServer superTypeServer = null;
                if (domainInheritance instanceof TypeServer) {
                    superTypeServer = (TypeServer)domainInheritance;
                } else if (domainInheritance != null) {
                    superTypeServer = this.packageManager.getTypeServer((DomainType)domainInheritance);
                }
                if (superTypeServer == null) continue;
                for (DomainType domainType : superTypeServer.getPartialTypes()) {
                    assert (domainType != null);
                    if (domainType instanceof Type) {
                        Type unspecializedType = PivotUtil.getUnspecializedTemplateableElement((Type)domainType);
                        TypeServer unspecializedTypeServer = this.packageManager.getTypeServer(unspecializedType);
                        for (DomainType domainType2 : unspecializedTypeServer.getPartialTypes()) {
                            assert (domainType2 != null);
                            this.initMemberOperationsFrom(domainType2);
                        }
                        continue;
                    }
                    this.initMemberOperationsFrom(domainType);
                }
            }
            for (Map map : name2operations2.values()) {
                for (List operations : map.values()) {
                    if (operations == null) continue;
                    this.initMemberOperationsPostProcess(this.name, operations);
                }
            }
        }
        return name2operations2;
    }

    private void initMemberOperationsFrom(@NonNull DomainType type) {
        for (DomainOperation pivotOperation : type.getLocalOperations()) {
            if (pivotOperation == null || pivotOperation.getName() == null) continue;
            this.addedMemberOperation(pivotOperation);
        }
    }

    protected void initMemberOperationsPostProcess(@NonNull String name, @NonNull List<DomainOperation> operations) {
    }

    @NonNull
    protected Map<String, PartialProperties> initMemberProperties() {
        Map<String, PartialProperties> name2properties2 = this.name2properties;
        if (name2properties2 == null) {
            name2properties2 = this.name2properties = new HashMap<String, PartialProperties>();
            for (DomainInheritance domainInheritance : this.getAllSuperClasses()) {
                TypeServer superTypeServer = null;
                if (domainInheritance instanceof TypeServer) {
                    superTypeServer = (TypeServer)domainInheritance;
                } else if (domainInheritance != null) {
                    superTypeServer = this.packageManager.getTypeServer((DomainType)domainInheritance);
                }
                if (superTypeServer == null) continue;
                for (DomainType domainType : superTypeServer.getPartialTypes()) {
                    assert (domainType != null);
                    if (domainType instanceof Type) {
                        Type unspecializedType = PivotUtil.getUnspecializedTemplateableElement((Type)domainType);
                        TypeServer unspecializedTypeServer = this.packageManager.getTypeServer(unspecializedType);
                        for (DomainType domainType2 : unspecializedTypeServer.getPartialTypes()) {
                            assert (domainType2 != null);
                            this.initMemberPropertiesFrom(domainType2);
                        }
                        continue;
                    }
                    this.initMemberPropertiesFrom(domainType);
                }
            }
            for (PartialProperties partialProperties : name2properties2.values()) {
                if (partialProperties == null) continue;
                this.initMemberPropertiesPostProcess(this.name, partialProperties);
            }
        }
        return name2properties2;
    }

    protected void initMemberPropertiesFrom(@NonNull DomainType type) {
        if (type instanceof Type) {
            type = PivotUtil.getUnspecializedTemplateableElement((Type)type);
        }
        if (type instanceof Type) {
            for (ElementExtension extension : ((Type)type).getExtension()) {
                assert (extension != null);
                this.initStereotypePropertiesFrom((Type)type, extension);
            }
        }
        for (DomainProperty pivotProperty : type.getLocalProperties()) {
            if (pivotProperty == null) continue;
            this.addedMemberProperty(pivotProperty);
        }
    }

    protected void initMemberPropertiesPostProcess(@NonNull String name, @NonNull PartialProperties properties) {
    }

    /*
     * WARNING - void declaration
     */
    protected void initStereotypePropertiesFrom(@NonNull Type baseType, @NonNull ElementExtension extensionType) {
        MetaModelManager metaModelManager = this.packageManager.getMetaModelManager();
        Map<String, PartialProperties> name2properties2 = this.name2properties;
        assert (name2properties2 != null);
        Type stereotype = extensionType.getStereotype();
        ArrayList<Object> newExtensionProperties = new ArrayList<Object>();
        List<Property> oldExtensionProperties = extensionType.getOwnedAttribute();
        String extensionPropertyName = "extension_" + stereotype.getName();
        Property extensionProperty = null;
        PartialProperties partialProperties = name2properties2.get(extensionPropertyName);
        if (partialProperties == null) {
            partialProperties = new PartialProperties();
            name2properties2.put(extensionPropertyName, partialProperties);
        }
        for (DomainProperty partialProperty : partialProperties) {
            if (!(partialProperty instanceof Property)) continue;
            extensionProperty = (Property)partialProperty;
            break;
        }
        if (extensionProperty == null) {
            extensionProperty = PivotFactory.eINSTANCE.createProperty();
            extensionProperty.setName(extensionPropertyName);
        }
        extensionProperty.setType(metaModelManager.getMetaclass(extensionType));
        extensionProperty.setIsRequired(false);
        extensionProperty.setIsStatic(true);
        baseType.getOwnedAttribute().add(extensionProperty);
        String basePropertyName = "base_" + baseType.eClass().getName();
        Property baseProperty = null;
        for (Property partialProperty : extensionType.getOwnedAttribute()) {
            if (partialProperty == null) continue;
            baseProperty = partialProperty;
            break;
        }
        if (baseProperty == null) {
            baseProperty = PivotFactory.eINSTANCE.createProperty();
            baseProperty.setName(basePropertyName);
        }
        baseProperty.setType(metaModelManager.getMetaclass(baseType));
        baseProperty.setIsRequired(false);
        baseProperty.setIsStatic(true);
        newExtensionProperties.add(baseProperty);
        baseProperty.setOpposite(extensionProperty);
        extensionProperty.setOpposite(baseProperty);
        EObject umlStereotypeApplication = extensionType.getETarget();
        EClass eClass = umlStereotypeApplication.eClass();
        for (EStructuralFeature eStructuralFeature : eClass.getEAllStructuralFeatures()) {
            void var20_20;
            String featureName = eStructuralFeature.getName();
            if (featureName == null || featureName.startsWith("base_") || !umlStereotypeApplication.eIsSet(eStructuralFeature)) continue;
            Object umlStereotypedElement = umlStereotypeApplication.eGet(eStructuralFeature);
            Property referenceProperty = null;
            for (DomainProperty domainProperty : metaModelManager.getAllProperties(stereotype, false, featureName)) {
                if (!(domainProperty instanceof Property)) continue;
                referenceProperty = (Property)domainProperty;
                break;
            }
            Property property = (Property)DomainUtil.getNamedElement(oldExtensionProperties, (String)featureName);
            if (property == null) {
                Property property2 = PivotFactory.eINSTANCE.createProperty();
                property2.setName(featureName);
            }
            var20_20.setReferredProperty(referenceProperty);
            if (referenceProperty != null) {
                var20_20.setDefault(String.valueOf(umlStereotypedElement));
                var20_20.setIsRequired(referenceProperty.isRequired());
                var20_20.setIsStatic(referenceProperty.isStatic());
                var20_20.setType(referenceProperty.getType());
            }
            newExtensionProperties.add(var20_20);
        }
        PivotUtil.refreshList(oldExtensionProperties, newExtensionProperties);
    }

    @NonNull
    protected Map<String, DomainInheritance> initSuperClasses() {
        this.name2superclasses = new HashMap<String, DomainInheritance>();
        HashMap<String, DomainInheritance> name2superclasses2 = this.name2superclasses;
        this.name2qualifiedNames = null;
        DomainFragment[] domainFragmentArray = this.getFragments();
        int n = domainFragmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            DomainFragment fragment = domainFragmentArray[n2];
            DomainInheritance baseInheritance = fragment.getBaseInheritance();
            String name = baseInheritance.getName();
            DomainInheritance oldInheritance = name2superclasses2.put(name, baseInheritance);
            if (oldInheritance != null) {
                name2superclasses2.clear();
                this.name2qualifiedNames = this.initSuperClassesWithAmbiguousNames(name2superclasses2, new HashMap<String, List<String>>());
                break;
            }
            ++n2;
        }
        return name2superclasses2;
    }

    protected Map<String, List<String>> initSuperClassesWithAmbiguousNames(Map<String, DomainInheritance> name2superclasses2, Map<String, List<String>> name2qualifiedNames2) {
        int counter = 0;
        DomainFragment[] domainFragmentArray = this.getFragments();
        int n = domainFragmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            DomainFragment fragment = domainFragmentArray[n2];
            DomainInheritance baseInheritance = fragment.getBaseInheritance();
            String name = baseInheritance.getName();
            String qualifiedName = Integer.toString(counter++);
            name2superclasses2.put(qualifiedName, baseInheritance);
            List<String> names = name2qualifiedNames2.get(name);
            if (names == null) {
                names = new ArrayList<String>();
                name2qualifiedNames2.put(name, names);
            }
            names.add(name);
            ++n2;
        }
        return name2qualifiedNames2;
    }

    void removedMemberOperation(@NonNull DomainOperation pivotOperation) {
        ParametersId parametersId;
        List<DomainOperation> partials;
        String operationName;
        Map<ParametersId, List<DomainOperation>> overloads;
        Map<String, Map<ParametersId, List<DomainOperation>>> name2operations2 = this.name2operations;
        if (name2operations2 != null && (overloads = name2operations2.get(operationName = pivotOperation.getName())) != null && (partials = overloads.get(parametersId = pivotOperation.getParametersId())) != null) {
            partials.add(pivotOperation);
            if (partials.isEmpty()) {
                overloads.remove(parametersId);
                if (overloads.isEmpty()) {
                    name2operations2.remove(operationName);
                }
            }
        }
    }

    void removedMemberProperty(@NonNull DomainProperty pivotProperty) {
        String propertyName;
        PartialProperties partials;
        Map<String, PartialProperties> name2properties2 = this.name2properties;
        if (name2properties2 != null && (partials = name2properties2.get(propertyName = pivotProperty.getName())) != null) {
            partials.remove(pivotProperty);
            if (partials.isEmpty()) {
                name2properties2.remove(propertyName);
            }
        }
    }

    public void uninstall() {
        this.name2superclasses = null;
        this.name2properties = null;
        this.name2operations = null;
        super.uninstall();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class BestOperation
    implements Function<List<DomainOperation>, DomainOperation> {
        public DomainOperation apply(List<DomainOperation> operations) {
            return operations.get(0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MapValues
    implements Function<Map<ParametersId, List<DomainOperation>>, Iterable<List<DomainOperation>>> {
        public Iterable<List<DomainOperation>> apply(Map<ParametersId, List<DomainOperation>> operations) {
            return operations.values();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PartialProperties
    implements Iterable<DomainProperty> {
        @Nullable
        private DomainProperty resolution = null;
        @Nullable
        private List<DomainProperty> partials = null;

        public synchronized void add(@NonNull DomainProperty pivotProperty) {
            List<DomainProperty> partials2 = this.partials;
            if (partials2 == null) {
                if (this.resolution == null) {
                    this.resolution = pivotProperty;
                } else {
                    this.partials = partials2 = new ArrayList<DomainProperty>();
                    partials2.add(this.resolution);
                    partials2.add(pivotProperty);
                    this.resolution = null;
                }
            } else if (partials2.isEmpty()) {
                if (this.resolution == null) {
                    this.resolution = pivotProperty;
                } else {
                    partials2.add(this.resolution);
                    partials2.add(pivotProperty);
                    this.resolution = null;
                }
            } else {
                partials2.add(pivotProperty);
                this.resolution = null;
            }
        }

        @Nullable
        public synchronized DomainProperty get() {
            if (this.resolution != null) {
                return this.resolution;
            }
            List<DomainProperty> partials2 = this.partials;
            if (partials2 == null) {
                return null;
            }
            int size = partials2.size();
            if (size <= 0) {
                return null;
            }
            if (size == 1) {
                this.resolution = partials2.get(0);
                return this.resolution;
            }
            ArrayList<DomainProperty> values = new ArrayList<DomainProperty>(this.partials);
            int i = 0;
            while (i < values.size() - 1) {
                boolean iRemoved = false;
                DomainProperty iValue = (DomainProperty)values.get(i);
                int j = i + 1;
                while (j < values.size()) {
                    java.lang.Class<?> iClass = iValue.getClass();
                    DomainProperty jValue = (DomainProperty)values.get(j);
                    java.lang.Class<?> jClass = jValue.getClass();
                    int verdict = 0;
                    for (java.lang.Class<? extends DomainElement> key : EnvironmentView.getDisambiguatorKeys()) {
                        if (!key.isAssignableFrom(iClass) || !key.isAssignableFrom(jClass)) continue;
                        List<Comparator<DomainElement>> disambiguators = EnvironmentView.getDisambiguators(key);
                        if (disambiguators != null) {
                            for (Comparator<DomainElement> comparator : disambiguators) {
                                verdict = comparator.compare((DomainElement)iValue, (DomainElement)jValue);
                                if (verdict != 0) break;
                            }
                        }
                        if (verdict != 0) break;
                    }
                    if (verdict == 0) {
                        ++j;
                        continue;
                    }
                    if (verdict < 0) {
                        values.remove(i);
                        iRemoved = true;
                        break;
                    }
                    values.remove(j);
                }
                if (iRemoved) continue;
                ++i;
            }
            this.resolution = (DomainProperty)values.get(0);
            return this.resolution;
        }

        public synchronized boolean isEmpty() {
            if (this.resolution != null) {
                return false;
            }
            List<DomainProperty> partials2 = this.partials;
            if (partials2 == null) {
                return true;
            }
            return partials2.size() <= 0;
        }

        @Override
        @NonNull
        public Iterator<DomainProperty> iterator() {
            DomainProperty property = this.get();
            if (property == null) {
                return Iterators.emptyIterator();
            }
            return Iterators.singletonIterator((Object)property);
        }

        public synchronized void remove(@NonNull DomainProperty pivotProperty) {
            if (pivotProperty == this.resolution) {
                this.resolution = null;
            }
            if (this.partials != null) {
                this.partials.remove(pivotProperty);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class QualifiedName2DomainInheritance
    implements Function<String, DomainInheritance> {
        @NonNull
        protected final Map<String, DomainInheritance> name2superclasses;

        protected QualifiedName2DomainInheritance(@NonNull Map<String, DomainInheritance> name2superclasses) {
            this.name2superclasses = name2superclasses;
        }

        public DomainInheritance apply(String qualifiedClassName) {
            return this.name2superclasses.get(qualifiedClassName);
        }
    }
}

