/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.ExtensibleTypeServer;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.Orphanage;
import org.eclipse.ocl.examples.pivot.manager.PackageServer;

public class CollectionTypeServer
extends ExtensibleTypeServer {
    private static final Logger logger = Logger.getLogger(CollectionTypeServer.class);
    @Nullable
    private Map<TemplateArguments, WeakReference<Type>> specializations = null;

    protected CollectionTypeServer(@NonNull PackageServer packageServer, @NonNull DomainCollectionType domainType) {
        super(packageServer, (DomainType)domainType);
    }

    @NonNull
    protected Type createSpecialization(@NonNull TemplateArguments templateArguments) {
        Type unspecializedType = this.getPivotType();
        String typeName = unspecializedType.getName();
        TemplateSignature templateSignature = unspecializedType.getOwnedTemplateSignature();
        List<TemplateParameter> templateParameters = templateSignature.getOwnedParameter();
        EClass eClass = unspecializedType.eClass();
        EFactory eFactoryInstance = eClass.getEPackage().getEFactoryInstance();
        CollectionType specializedType = (CollectionType)eFactoryInstance.create(eClass);
        specializedType.setName(typeName);
        TemplateBinding templateBinding = PivotFactory.eINSTANCE.createTemplateBinding();
        templateBinding.setSignature(templateSignature);
        HashMap<TemplateParameter, ParameterableElement> allBindings = new HashMap<TemplateParameter, ParameterableElement>();
        TemplateParameter formalParameter = templateParameters.get(0);
        Type elementType = templateArguments.getElementType();
        allBindings.put(formalParameter, elementType);
        TemplateParameterSubstitution templateParameterSubstitution = CollectionTypeServer.createTemplateParameterSubstitution(formalParameter, elementType);
        templateBinding.getParameterSubstitution().add(templateParameterSubstitution);
        specializedType.getTemplateBinding().add(templateBinding);
        this.packageManager.resolveSuperClasses(specializedType, unspecializedType, allBindings);
        CollectionType specializedCollectionType = specializedType;
        specializedCollectionType.setElementType(templateArguments.getElementType());
        try {
            specializedCollectionType.setLowerValue(templateArguments.getLower());
        }
        catch (InvalidValueException e) {
            logger.error((Object)"Out of range lower bound", (Throwable)e);
        }
        try {
            specializedCollectionType.setUpperValue(templateArguments.getUpper());
        }
        catch (InvalidValueException e) {
            logger.error((Object)"Out of range upper bound", (Throwable)e);
        }
        specializedType.setUnspecializedElement(unspecializedType);
        MetaModelManager metaModelManager = this.packageManager.getMetaModelManager();
        Orphanage orphanage = Orphanage.getOrphanage(metaModelManager.getPivotResourceSet());
        specializedType.setPackage(orphanage);
        return specializedType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public synchronized Type findSpecializedType(@NonNull TemplateArguments templateArguments) {
        TemplateSignature templateSignature = this.getPivotType().getOwnedTemplateSignature();
        List<TemplateParameter> templateParameters = templateSignature.getParameter();
        if (templateParameters.size() != 1) {
            return null;
        }
        Map<TemplateArguments, WeakReference<Type>> specializations2 = this.specializations;
        if (specializations2 == null) {
            return null;
        }
        WeakReference<Type> weakReference = specializations2.get(templateArguments);
        if (weakReference == null) {
            return null;
        }
        Type type = (Type)weakReference.get();
        if (type == null) {
            Map<TemplateArguments, WeakReference<Type>> map = specializations2;
            synchronized (map) {
                type = (Type)weakReference.get();
                if (type == null) {
                    specializations2.remove(templateArguments);
                }
            }
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public synchronized Type getSpecializedType(@NonNull Type elementType, @Nullable IntegerValue lower, @Nullable IntegerValue upper) {
        Object object;
        assert (this.getPivotType() instanceof CollectionType);
        IntegerValue lower2 = lower;
        IntegerValue upper2 = upper;
        if (lower2 == null) {
            lower2 = ValuesUtil.ZERO_VALUE;
        }
        if (upper2 == null) {
            upper2 = ValuesUtil.UNLIMITED_VALUE;
        }
        TemplateArguments templateArguments = new TemplateArguments(elementType, lower2, upper2);
        Map<TemplateArguments, WeakReference<Type>> specializations2 = this.specializations;
        if (specializations2 == null) {
            object = this;
            synchronized (object) {
                specializations2 = this.specializations;
                if (specializations2 == null) {
                    specializations2 = this.specializations = new HashMap<TemplateArguments, WeakReference<Type>>();
                }
            }
        }
        object = specializations2;
        synchronized (object) {
            Type specializedType = null;
            WeakReference<Type> weakReference = specializations2.get(templateArguments);
            if (weakReference != null) {
                specializedType = (Type)weakReference.get();
            }
            if (specializedType == null) {
                specializedType = this.createSpecialization(templateArguments);
                specializations2.put(templateArguments, new WeakReference<Type>(specializedType));
            }
            return specializedType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TemplateArguments
    implements Iterable<Object> {
        private final int hashCode;
        @NonNull
        private final Type elementType;
        @NonNull
        private final IntegerValue lower;
        @NonNull
        private final IntegerValue upper;

        public TemplateArguments(@NonNull Type elementType, @NonNull IntegerValue lower, @NonNull IntegerValue upper) {
            this.elementType = elementType;
            this.lower = lower;
            this.upper = upper;
            int hash = elementType.hashCode();
            hash = 111 * hash + lower.hashCode();
            this.hashCode = hash = 111 * hash + upper.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof TemplateArguments)) {
                return false;
            }
            TemplateArguments that = (TemplateArguments)o;
            if (this.hashCode != that.hashCode) {
                return false;
            }
            if (!this.elementType.equals(that.elementType)) {
                return false;
            }
            if (!this.lower.equals(that.lower)) {
                return false;
            }
            return this.upper.equals(that.upper);
        }

        @NonNull
        public Type getElementType() {
            return this.elementType;
        }

        @NonNull
        public IntegerValue getLower() {
            return this.lower;
        }

        @NonNull
        public IntegerValue getUpper() {
            return this.upper;
        }

        public int hashCode() {
            return this.hashCode;
        }

        @NonNull
        public Iterator iterator() {
            return new Iterator();
        }

        public int parametersSize() {
            return 1;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append('(');
            s.append(this.elementType);
            s.append(',');
            s.append(this.lower);
            s.append(',');
            s.append(this.upper);
            s.append(')');
            return s.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class Iterator
        implements java.util.Iterator<Object> {
            private int position = 0;

            protected Iterator() {
            }

            @Override
            public boolean hasNext() {
                return this.position < 3;
            }

            @Override
            public Object next() {
                switch (this.position++) {
                    case 0: {
                        return TemplateArguments.this.elementType;
                    }
                    case 1: {
                        return TemplateArguments.this.lower;
                    }
                    case 2: {
                        return TemplateArguments.this.upper;
                    }
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

