/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import com.google.common.base.Function;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.manager.ExtensibleTypeServer;
import org.eclipse.ocl.examples.pivot.manager.PackageServer;

class TypeTracker
implements Adapter.Internal {
    public static Function<TypeTracker, DomainType> tracker2type = new Function<TypeTracker, DomainType>(){

        public DomainType apply(TypeTracker typeTracker) {
            return typeTracker.getType();
        }
    };
    @NonNull
    protected final ExtensibleTypeServer typeServer;
    @NonNull
    private final DomainType type;

    TypeTracker(@NonNull ExtensibleTypeServer typeServer, @NonNull DomainType type) {
        this.typeServer = typeServer;
        this.type = type;
        assert (!(type instanceof ExtensibleTypeServer));
        if (type instanceof Notifier) {
            ((Notifier)type).eAdapters().add((Object)this);
        }
    }

    public void dispose() {
        this.typeServer.disposedTypeTracker(this);
        if (this.type instanceof Notifier) {
            ((Notifier)this.type).eAdapters().remove((Object)this);
        }
    }

    public final Notifier getTarget() {
        return this.type instanceof Notifier ? (Notifier)this.type : null;
    }

    @NonNull
    public final DomainType getType() {
        return this.type;
    }

    @NonNull
    public ExtensibleTypeServer getTypeServer() {
        return this.typeServer;
    }

    public final boolean isAdapterForType(Object type) {
        return type == this.typeServer.getPackageManager();
    }

    public void notifyChanged(Notification notification) {
        block31: {
            Object feature;
            int eventType;
            block32: {
                block30: {
                    if (notification.getNotifier() != this.type) {
                        return;
                    }
                    eventType = notification.getEventType();
                    feature = notification.getFeature();
                    if (feature != PivotPackage.Literals.TYPE__OWNED_OPERATION) break block30;
                    switch (eventType) {
                        case 3: {
                            Object value = notification.getNewValue();
                            if (value instanceof Operation) {
                                this.typeServer.addedMemberOperation((Operation)value);
                                break;
                            }
                            break block31;
                        }
                        case 5: {
                            List values = (List)notification.getNewValue();
                            for (Object value : values) {
                                if (!(value instanceof Operation)) continue;
                                this.typeServer.addedMemberOperation((Operation)value);
                            }
                            break block31;
                        }
                        case 4: {
                            Object value = notification.getOldValue();
                            if (value instanceof Operation) {
                                this.typeServer.removedMemberOperation((Operation)value);
                                break;
                            }
                            break block31;
                        }
                        case 6: {
                            List values = (List)notification.getOldValue();
                            for (Object value : values) {
                                if (!(value instanceof Operation)) continue;
                                this.typeServer.removedMemberOperation((Operation)value);
                            }
                        }
                    }
                    break block31;
                }
                if (feature != PivotPackage.Literals.TYPE__OWNED_ATTRIBUTE) break block32;
                switch (eventType) {
                    case 3: {
                        Object value = notification.getNewValue();
                        if (value instanceof Property) {
                            this.typeServer.addedMemberProperty((Property)value);
                            break;
                        }
                        break block31;
                    }
                    case 5: {
                        List values = (List)notification.getNewValue();
                        for (Object value : values) {
                            if (!(value instanceof Property)) continue;
                            this.typeServer.addedMemberProperty((Property)value);
                        }
                        break block31;
                    }
                    case 4: {
                        Object value = notification.getOldValue();
                        if (value instanceof Property) {
                            this.typeServer.removedMemberProperty((Property)value);
                            break;
                        }
                        break block31;
                    }
                    case 6: {
                        List values = (List)notification.getOldValue();
                        for (Object value : values) {
                            if (!(value instanceof Property)) continue;
                            this.typeServer.removedMemberProperty((Property)value);
                        }
                    }
                }
                break block31;
            }
            if (feature == PivotPackage.Literals.TYPE__SUPER_CLASS) {
                switch (eventType) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 9: {
                        this.typeServer.changedInheritance();
                    }
                }
            } else if (feature == PivotPackage.Literals.NAMED_ELEMENT__NAME) {
                switch (eventType) {
                    case 1: 
                    case 2: {
                        PackageServer packageServer = this.typeServer.getPackageServer();
                        this.dispose();
                        packageServer.addedMemberType(this.type);
                    }
                }
            }
        }
    }

    public void setTarget(Notifier newTarget) {
        assert (this.type == newTarget);
    }

    public String toString() {
        return String.valueOf(this.type);
    }

    public void unsetTarget(Notifier oldTarget) {
        assert (this.type == oldTarget);
    }
}

