/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.scoping;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainElement;
import org.eclipse.ocl.examples.domain.elements.DomainNamedElement;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.elements.DomainProperty;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Enumeration;
import org.eclipse.ocl.examples.pivot.EnumerationLiteral;
import org.eclipse.ocl.examples.pivot.Library;
import org.eclipse.ocl.examples.pivot.Metaclass;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Precedence;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.State;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.NestedPackageServer;
import org.eclipse.ocl.examples.pivot.manager.PackageManager;
import org.eclipse.ocl.examples.pivot.manager.PackageServer;
import org.eclipse.ocl.examples.pivot.manager.RootPackageServer;
import org.eclipse.ocl.examples.pivot.manager.TypeServer;
import org.eclipse.ocl.examples.pivot.scoping.Attribution;
import org.eclipse.ocl.examples.pivot.scoping.PivotScopeView;
import org.eclipse.ocl.examples.pivot.scoping.ScopeFilter;
import org.eclipse.ocl.examples.pivot.scoping.ScopeView;
import org.eclipse.ocl.examples.pivot.utilities.IllegalLibraryException;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentView {
    private static final Logger logger = Logger.getLogger(EnvironmentView.class);
    @NonNull
    private static LinkedHashMap<java.lang.Class<? extends DomainElement>, List<Comparator<DomainElement>>> disambiguatorMap = new LinkedHashMap();
    @NonNull
    protected final MetaModelManager metaModelManager;
    @NonNull
    protected final EStructuralFeature reference;
    private EClassifier requiredType;
    private boolean isQualifier;
    @Nullable
    protected final String name;
    @NonNull
    private final Map<String, Object> contentsByName = new HashMap<String, Object>();
    private Map<DomainElement, Map<TemplateParameter, ParameterableElement>> templateBindings = null;
    private int contentsSize = 0;
    private List<ScopeFilter> matchers = null;
    private Set<ScopeFilter> resolvers = null;

    static {
        EnvironmentView.addDisambiguator(DomainElement.class, new ImplicitDisambiguator());
        EnvironmentView.addDisambiguator(Operation.class, new OperationDisambiguator());
        EnvironmentView.addDisambiguator(Property.class, new PropertyDisambiguator());
    }

    public static synchronized <T extends DomainElement> void addDisambiguator(@NonNull java.lang.Class<T> targetClass, @NonNull Comparator<T> disambiguator) {
        List<Comparator<DomainElement>> disambiguators = disambiguatorMap.get(targetClass);
        if (disambiguators == null) {
            disambiguators = new ArrayList<Comparator<DomainElement>>();
            disambiguatorMap.put(targetClass, disambiguators);
        }
        Comparator<T> castDisambiguator = disambiguator;
        disambiguators.add(castDisambiguator);
    }

    @NonNull
    public static Iterable<java.lang.Class<? extends DomainElement>> getDisambiguatorKeys() {
        return disambiguatorMap.keySet();
    }

    @Nullable
    public static List<Comparator<DomainElement>> getDisambiguators(@NonNull java.lang.Class<? extends DomainElement> key) {
        return disambiguatorMap.get(key);
    }

    public EnvironmentView(@NonNull MetaModelManager metaModelManager, @NonNull EStructuralFeature reference, @Nullable String name) {
        this.metaModelManager = metaModelManager;
        this.reference = reference;
        this.requiredType = reference.getEType();
        this.isQualifier = false;
        this.name = name;
    }

    public boolean accepts(EClass eClass) {
        assert (eClass != null);
        return this.name == null || PivotUtil.conformsTo(this.requiredType, (EClassifier)eClass) || this.requiredType != null && PivotUtil.conformsTo((EClassifier)eClass, this.requiredType);
    }

    public void addAllElements(@NonNull Type type, @NonNull ScopeView scopeView) {
        Type instanceType;
        Element element = PivotUtil.getLowerBound(type);
        Attribution attribution = PivotUtil.getAttribution(element);
        attribution.computeLookup(element, this, scopeView);
        TemplateableElement type2 = type.getUnspecializedElement();
        element = (type2 instanceof Type ? (Type)type2 : type).getPackage();
        if (element != null) {
            attribution = PivotUtil.getAttribution(element);
            attribution.computeLookup(element, this, scopeView);
        }
        if (type instanceof Metaclass && (instanceType = ((Metaclass)type).getInstanceType()) != null) {
            element = PivotUtil.getLowerBound(instanceType);
            attribution = PivotUtil.getAttribution(element);
            attribution.computeLookup(element, this, scopeView);
        }
    }

    public void addAllEnumerationLiterals(Enumeration pivot) {
        block4: {
            if (!this.accepts(PivotPackage.Literals.ENUMERATION_LITERAL)) break block4;
            String name2 = this.name;
            if (name2 != null) {
                for (EnumerationLiteral literal : pivot.getOwnedLiteral()) {
                    if (literal == null || !name2.equals(literal.getName())) continue;
                    this.addElement(name2, literal);
                }
            } else {
                for (EnumerationLiteral literal : pivot.getOwnedLiteral()) {
                    if (literal == null) continue;
                    this.addNamedElement(literal);
                }
            }
        }
    }

    public void addAllOperations(@NonNull Type type, boolean selectStatic) {
        block5: {
            if (!this.accepts(PivotPackage.Literals.ITERATION) || this.requiredType == PivotPackage.Literals.NAMESPACE) break block5;
            assert (this.metaModelManager.isTypeServeable(type));
            type = PivotUtil.getUnspecializedTemplateableElement(type);
            TypeServer typeServer = this.metaModelManager.getTypeServer(type);
            String name2 = this.name;
            if (name2 != null) {
                for (DomainOperation domainOperation : typeServer.getAllOperations(selectStatic, name2)) {
                    if (domainOperation == null || domainOperation.isStatic() != selectStatic) continue;
                    this.addElement(name2, (DomainElement)domainOperation);
                }
            } else {
                for (DomainOperation domainOperation : typeServer.getAllOperations(selectStatic)) {
                    if (domainOperation == null || domainOperation.isStatic() != selectStatic) continue;
                    this.addNamedElement((DomainNamedElement)domainOperation);
                }
            }
        }
    }

    public void addAllPackages(@NonNull Package pkge) {
        if (this.accepts(PivotPackage.Literals.PACKAGE)) {
            PackageServer parentPackageServer = this.metaModelManager.getPackageServer(pkge);
            String name2 = this.name;
            if (name2 != null) {
                NestedPackageServer nestedPackageServer = parentPackageServer.getMemberPackage(name2);
                if (nestedPackageServer != null) {
                    this.addElement(name2, (DomainElement)nestedPackageServer);
                }
            } else {
                for (PackageServer packageServer : parentPackageServer.getMemberPackages()) {
                    if (packageServer == null) continue;
                    this.addNamedElement((DomainNamedElement)packageServer);
                }
            }
        }
    }

    public void addAllPackages(@NonNull Root root) {
        block4: {
            if (!this.accepts(PivotPackage.Literals.PACKAGE)) break block4;
            String name2 = this.name;
            if (name2 != null) {
                for (Package pkge : root.getNestedPackage()) {
                    if (pkge == null || !name2.equals(pkge.getName())) continue;
                    this.addElement(name2, (DomainElement)this.metaModelManager.getPrimaryPackage(pkge));
                }
            } else {
                for (Package pkge : root.getNestedPackage()) {
                    if (pkge == null) continue;
                    this.addNamedElement((DomainNamedElement)this.metaModelManager.getPrimaryPackage(pkge));
                }
            }
        }
    }

    public void addAllParameters(@NonNull Operation pivot) {
        block4: {
            if (!this.accepts(PivotPackage.Literals.PARAMETER)) break block4;
            String name2 = this.name;
            if (name2 != null) {
                for (Parameter parameter : pivot.getOwnedParameter()) {
                    if (!name2.equals(parameter.getName())) continue;
                    this.addElement(name2, parameter);
                }
            } else {
                for (Parameter parameter : pivot.getOwnedParameter()) {
                    if (parameter == null) continue;
                    this.addNamedElement(parameter);
                }
            }
        }
    }

    public void addAllPrecedences(@NonNull Library pivot) {
        block4: {
            if (!this.accepts(PivotPackage.Literals.PRECEDENCE)) break block4;
            String name2 = this.name;
            if (name2 != null) {
                for (Precedence precedence : pivot.getOwnedPrecedence()) {
                    if (!name2.equals(precedence.getName())) continue;
                    this.addElement(name2, precedence);
                }
            } else {
                for (Precedence precedence : pivot.getOwnedPrecedence()) {
                    if (precedence == null) continue;
                    this.addNamedElement(precedence);
                }
            }
        }
    }

    public void addAllProperties(@NonNull Type type, boolean selectStatic) {
        block5: {
            if (!this.accepts(PivotPackage.Literals.PROPERTY) || this.requiredType == PivotPackage.Literals.NAMESPACE) break block5;
            assert (this.metaModelManager.isTypeServeable(type));
            TypeServer typeServer = this.metaModelManager.getTypeServer(type);
            String name2 = this.name;
            if (name2 != null) {
                for (DomainProperty domainProperty : typeServer.getAllProperties(selectStatic, name2)) {
                    if (domainProperty == null) continue;
                    this.addNamedElement((DomainNamedElement)domainProperty);
                }
            } else {
                for (DomainProperty domainProperty : typeServer.getAllProperties(selectStatic)) {
                    if (domainProperty == null) continue;
                    this.addNamedElement((DomainNamedElement)domainProperty);
                }
            }
        }
    }

    public void addAllStates(@NonNull Class type) {
        block5: {
            if (!this.accepts(PivotPackage.Literals.STATE)) break block5;
            assert (this.metaModelManager.isTypeServeable(type));
            TypeServer typeServer = this.metaModelManager.getTypeServer(type);
            String name2 = this.name;
            if (name2 != null) {
                for (State state : typeServer.getAllStates(name2)) {
                    if (state == null) continue;
                    this.addNamedElement(state);
                }
            } else {
                for (State state : typeServer.getAllStates()) {
                    if (state == null) continue;
                    this.addNamedElement(state);
                }
            }
        }
    }

    public void addAllTemplateParameters(@NonNull TemplateableElement pivot) {
        block4: {
            if (!this.accepts(PivotPackage.Literals.TYPE) && !this.accepts(PivotPackage.Literals.OPERATION)) break block4;
            List<TemplateParameter> templateParameters = PivotUtil.getTemplateParameters(pivot);
            String name2 = this.name;
            if (name2 != null) {
                for (TemplateParameter templateParameter : templateParameters) {
                    DomainNamedElement parameteredElement;
                    if (templateParameter == null || !name2.equals((parameteredElement = (DomainNamedElement)templateParameter.getParameteredElement()).getName())) continue;
                    this.addElement(name2, (DomainElement)parameteredElement);
                }
            } else {
                for (TemplateParameter templateParameter : templateParameters) {
                    DomainNamedElement parameteredElement;
                    if (templateParameter == null || (parameteredElement = (DomainNamedElement)templateParameter.getParameteredElement()) == null) continue;
                    this.addNamedElement(parameteredElement);
                }
            }
        }
    }

    public void addAllTypeTemplateParameterables(@NonNull TemplateableElement pivot) {
        block4: {
            if (!this.accepts(PivotPackage.Literals.TYPE)) break block4;
            List<Type> types = PivotUtil.getTypeTemplateParameterables(pivot);
            String name2 = this.name;
            if (name2 != null) {
                for (Type type : types) {
                    if (!name2.equals(type.getName())) continue;
                    this.addElement(name2, type);
                }
            } else {
                for (Type type : types) {
                    if (type == null) continue;
                    this.addNamedElement(type);
                }
            }
        }
    }

    public void addAllTypes(@NonNull Package pkge) {
        if (this.accepts(PivotPackage.Literals.CLASS)) {
            PackageServer packageServer = this.metaModelManager.getPackageServer(pkge);
            String name2 = this.name;
            if (name2 != null) {
                Type type = packageServer.getMemberType(name2);
                if (type != null) {
                    this.addNamedElement(type);
                }
            } else {
                for (TypeServer type : packageServer.getMemberTypes()) {
                    if (type == null) continue;
                    this.addNamedElement((DomainNamedElement)type);
                }
            }
        }
    }

    public void addElement(String elementName, DomainElement element) {
        Object value;
        if (elementName == null || element == null) {
            return;
        }
        if (element instanceof EObject && !(element instanceof Variable) && ((EObject)element).eResource() == null) {
            logger.error((Object)("Orphan '" + element + "'"));
            return;
        }
        if (this.name != null && !this.name.equals(elementName)) {
            assert (!(element instanceof DomainProperty) && !(element instanceof DomainOperation));
            return;
        }
        if (element instanceof PackageServer) {
            element = ((PackageServer)element).getPivotPackage();
        } else if (element instanceof DomainPackage) {
            element = this.metaModelManager.getPackageServer((DomainPackage)element).getPivotPackage();
        } else if (element instanceof EObject) {
            element = (DomainNamedElement)this.metaModelManager.getPrimaryElement((EObject)element);
        }
        if (this.name != null && this.matchers != null) {
            for (ScopeFilter filter : this.matchers) {
                if (filter.matches(this, element)) continue;
                return;
            }
        }
        if (element instanceof TypeServer) {
            element = ((TypeServer)element).getPivotType();
        }
        if (this.requiredType != null && this.name != null && !this.requiredType.isInstance((Object)element)) {
            return;
        }
        if (this.matchers != null) {
            if (this.resolvers == null) {
                this.resolvers = new HashSet<ScopeFilter>();
            }
            this.resolvers.addAll(this.matchers);
        }
        if ((value = this.contentsByName.get(elementName)) != element) {
            if (value == null) {
                this.contentsByName.put(elementName, element);
                ++this.contentsSize;
            } else {
                List<DomainElement> values;
                if (value instanceof DomainElement) {
                    values = new ArrayList<DomainElement>();
                    values.add((DomainElement)value);
                    this.contentsByName.put(elementName, values);
                } else {
                    List castValue = (List)value;
                    values = castValue;
                }
                if (!values.contains(element)) {
                    values.add(element);
                    ++this.contentsSize;
                }
            }
        }
    }

    public void addElements(@NonNull Map<String, ? extends DomainElement> elements) {
        String name2 = this.name;
        if (name2 != null) {
            DomainElement element = elements.get(name2);
            if (element != null) {
                this.addElement(name2, element);
            }
        } else {
            for (String key : elements.keySet()) {
                DomainElement element;
                if (key == null || (element = elements.get(key)) == null) continue;
                this.addElement(key, element);
            }
        }
    }

    public void addElements(@Nullable Iterable<? extends DomainElement> elements) {
        if (elements != null) {
            for (DomainElement domainElement : elements) {
                DomainNamedElement namedElement;
                String elementName;
                if (!(domainElement instanceof DomainNamedElement) || (elementName = (namedElement = (DomainNamedElement)domainElement).getName()) == null) continue;
                this.addElement(elementName, (DomainElement)namedElement);
            }
        }
    }

    public void addElementsOfScope(@Nullable Element element, @NonNull ScopeView scopeView) {
        if (element != null) {
            element = PivotUtil.getLowerBound(element);
            Attribution attribution = PivotUtil.getAttribution(element);
            attribution.computeLookup(element, this, scopeView);
        }
    }

    public void addFilter(@NonNull ScopeFilter filter) {
        if (this.matchers == null) {
            this.matchers = new ArrayList<ScopeFilter>();
        }
        this.matchers.add(filter);
    }

    public void addImportedElement(@NonNull URI baseURI) {
        String name;
        if (PivotUtil.isPivotURI(baseURI)) {
            baseURI = PivotUtil.getNonPivotURI(baseURI);
        }
        if ((name = this.getName()) != null) {
            URI uri = URI.createURI((String)name).resolve(baseURI);
            try {
                Element importedElement = this.metaModelManager.loadResource(uri, null, null);
                if (importedElement != null) {
                    this.addElement(name, importedElement);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addLibContents(@NonNull Type libType, @NonNull ScopeView scopeView) {
        this.addElementsOfScope(libType, scopeView);
        for (Type superClass : libType.getSuperClass()) {
            if (superClass == null) continue;
            this.addLibContents(superClass, scopeView);
        }
    }

    public void addNamedElement(DomainNamedElement namedElement) {
        if (namedElement == null) {
            return;
        }
        String elementName = namedElement.getName();
        if (elementName != null) {
            this.addElement(elementName, (DomainElement)namedElement);
        }
    }

    public void addNamedElements(Iterable<? extends DomainNamedElement> namedElements) {
        for (DomainNamedElement domainNamedElement : namedElements) {
            if (domainNamedElement == null) continue;
            this.addNamedElement(domainNamedElement);
        }
    }

    public void addRootPackages() {
        PackageManager packageManager = this.metaModelManager.getPackageManager();
        String name2 = this.name;
        if (name2 != null) {
            PackageServer packageServer;
            RootPackageServer rootPackageServer = packageManager.getMemberPackage(name2);
            if (rootPackageServer != null) {
                this.addNamedElement((DomainNamedElement)rootPackageServer);
            }
            if ((packageServer = packageManager.getPackageByURI(name2)) != null) {
                this.addElement(name2, (DomainElement)packageServer);
            }
        } else {
            for (RootPackageServer rootPackageServer : packageManager.getMemberPackages()) {
                if (rootPackageServer == null) continue;
                this.addNamedElement((DomainNamedElement)rootPackageServer);
            }
            for (PackageServer packageServer : packageManager.getAllPackagesWithUris()) {
                String nsURI = packageServer.getNsURI();
                if (nsURI == null) continue;
                this.addElement(nsURI, (DomainElement)packageServer);
            }
        }
    }

    public int computeLookups(@NonNull Element target, @Nullable Element child) {
        PivotScopeView pivotScopeView = new PivotScopeView(this.metaModelManager, target, child, false);
        return this.computeLookups(pivotScopeView);
    }

    public int computeLookups(@NonNull ScopeView scopeView) {
        ScopeView aScope = scopeView;
        try {
            while (aScope != null && !this.hasFinalResult()) {
                EObject aTarget = aScope.getTarget();
                if (aTarget != null) {
                    Attribution attribution = aScope.getAttribution();
                    aScope = attribution.computeLookup(aTarget, this, aScope);
                    continue;
                }
                break;
            }
        }
        catch (IllegalLibraryException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn((Object)("Lookup of '" + this.name + "' failed"), (Throwable)e);
        }
        return this.resolveDuplicates();
    }

    public void computeQualifiedLookups(@NonNull Element target) {
        PivotScopeView parentScopeView = new PivotScopeView(this.metaModelManager, target, null, true);
        this.addElementsOfScope(target, parentScopeView);
    }

    @Nullable
    public EObject getContent() {
        if (this.contentsSize == 0) {
            return null;
        }
        if (this.contentsSize != 1) {
            logger.warn((Object)("Unhandled ambiguous content for '" + this.name + "'"));
        }
        for (Map.Entry<String, Object> entry : this.contentsByName.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof List) {
                List values = (List)value;
                value = values.get(values.size() - 1);
            }
            if (!(value instanceof EObject)) continue;
            return (EObject)value;
        }
        return null;
    }

    @NonNull
    public Set<Map.Entry<String, Object>> getEntries() {
        Set<Map.Entry<String, Object>> result = this.contentsByName.entrySet();
        return result;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @NonNull
    public EStructuralFeature getReference() {
        return this.reference;
    }

    @Nullable
    public EClassifier getRequiredType() {
        return this.requiredType;
    }

    public int getSize() {
        return this.contentsSize;
    }

    @NonNull
    public MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    public boolean hasFinalResult() {
        if (this.contentsSize == 0) {
            return false;
        }
        return this.getName() != null;
    }

    public boolean isQualifier() {
        return this.isQualifier;
    }

    public void removeFilter(@NonNull ScopeFilter filter) {
        if (this.matchers != null) {
            this.matchers.remove(filter);
        }
    }

    public int resolveDuplicates() {
        if (this.contentsSize > 1 && this.getName() != null) {
            int newSize = 0;
            for (Map.Entry<String, Object> entry : this.contentsByName.entrySet()) {
                Object listOrValue = entry.getValue();
                if (listOrValue instanceof List) {
                    List values = (List)listOrValue;
                    int i = 0;
                    while (i < values.size() - 1) {
                        boolean iRemoved = false;
                        DomainElement iValue = (DomainElement)values.get(i);
                        Map<TemplateParameter, ParameterableElement> iBindings = this.templateBindings != null ? this.templateBindings.get(iValue) : null;
                        int j = i + 1;
                        while (j < values.size()) {
                            java.lang.Class<?> iClass = iValue.getClass();
                            DomainElement jValue = (DomainElement)values.get(j);
                            java.lang.Class<?> jClass = jValue.getClass();
                            int verdict = 0;
                            for (java.lang.Class<? extends DomainElement> key : disambiguatorMap.keySet()) {
                                if (!key.isAssignableFrom(iClass) || !key.isAssignableFrom(jClass)) continue;
                                for (Comparator<DomainElement> comparator : disambiguatorMap.get(key)) {
                                    verdict = comparator.compare(iValue, jValue);
                                    if (verdict != 0) break;
                                }
                                if (verdict != 0) break;
                            }
                            if (verdict == 0 && this.resolvers != null) {
                                Map<TemplateParameter, ParameterableElement> jBindings = this.templateBindings != null ? this.templateBindings.get(jValue) : null;
                                for (ScopeFilter filter : this.resolvers) {
                                    verdict = filter.compareMatches(this.metaModelManager, iValue, iBindings, jValue, jBindings);
                                    if (verdict != 0) break;
                                }
                            }
                            if (verdict == 0) {
                                ++j;
                                continue;
                            }
                            if (verdict < 0) {
                                values.remove(i);
                                iRemoved = true;
                                break;
                            }
                            values.remove(j);
                        }
                        if (iRemoved) continue;
                        ++i;
                    }
                    newSize += values.size();
                    continue;
                }
                ++newSize;
            }
            this.contentsSize = newSize;
        }
        return this.getSize();
    }

    public void setBindings(@NonNull DomainElement eObject, @Nullable Map<TemplateParameter, ParameterableElement> bindings) {
        if (this.templateBindings == null) {
            this.templateBindings = new HashMap<DomainElement, Map<TemplateParameter, ParameterableElement>>();
        }
        this.templateBindings.put(eObject, bindings);
    }

    public void setIsQualifier(boolean isQualifier) {
        this.isQualifier = isQualifier;
    }

    public void setRequiredType(@Nullable EClassifier requiredType) {
        assert (requiredType == null || PivotUtil.conformsTo(this.reference.getEType(), requiredType));
        this.requiredType = requiredType;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.reference.getName());
        s.append(" : ");
        if (this.requiredType != null) {
            s.append(this.requiredType.getName());
        }
        if (this.isQualifier) {
            s.append(" (qualifier)");
        }
        s.append(" \"");
        if (this.name != null) {
            s.append(this.name);
        }
        s.append("\" {");
        String prefix = "";
        for (String contentName : this.contentsByName.keySet()) {
            s.append(prefix);
            s.append(contentName);
            Object content = this.contentsByName.get(contentName);
            if (content instanceof List) {
                s.append("*");
                s.append(((List)content).size());
            }
            prefix = ",";
        }
        s.append("}");
        return s.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ImplicitDisambiguator
    implements Comparator<DomainElement> {
        private ImplicitDisambiguator() {
        }

        @Override
        public int compare(DomainElement match1, DomainElement match2) {
            boolean match2IsImplicit;
            boolean match1IsImplicit = match1 instanceof Property && ((Property)match1).isImplicit();
            boolean bl = match2IsImplicit = match2 instanceof Property && ((Property)match2).isImplicit();
            if (!match1IsImplicit) {
                return match2IsImplicit ? 1 : 0;
            }
            return match2IsImplicit ? 0 : -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OperationDisambiguator
    implements Comparator<Operation> {
        private OperationDisambiguator() {
        }

        @Override
        public int compare(Operation match1, Operation match2) {
            if (this.isRedefinitionOf(match1, match2)) {
                return 1;
            }
            if (this.isRedefinitionOf(match2, match1)) {
                return -1;
            }
            return 0;
        }

        protected boolean isRedefinitionOf(@NonNull Operation operation1, @NonNull Operation operation2) {
            List<Operation> redefinedOperations = operation1.getRedefinedOperation();
            for (Operation redefinedOperation : redefinedOperations) {
                if (redefinedOperation == null) continue;
                if (redefinedOperation == operation2) {
                    return true;
                }
                if (!this.isRedefinitionOf(redefinedOperation, operation2)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PropertyDisambiguator
    implements Comparator<Property> {
        private PropertyDisambiguator() {
        }

        @Override
        public int compare(Property match1, Property match2) {
            if (this.isRedefinitionOf(match1, match2)) {
                return 1;
            }
            if (this.isRedefinitionOf(match2, match1)) {
                return -1;
            }
            return 0;
        }

        protected boolean isRedefinitionOf(@NonNull Property property1, @NonNull Property property2) {
            List<Property> redefinedProperties = property1.getRedefinedProperty();
            for (Property redefinedProperty : redefinedProperties) {
                if (redefinedProperty == null) continue;
                if (redefinedProperty == property2) {
                    return true;
                }
                if (!this.isRedefinitionOf(redefinedProperty, property2)) continue;
                return true;
            }
            return false;
        }
    }
}

