/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.uml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.utilities.StandaloneProjectMap;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ElementExtension;
import org.eclipse.ocl.examples.pivot.Metaclass;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.OCL;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.Stereotype;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.ecore.AbstractEcore2Pivot;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.uml.UML2PivotDeclarationSwitch;
import org.eclipse.ocl.examples.pivot.uml.UML2PivotReferenceSwitch;
import org.eclipse.ocl.examples.pivot.utilities.AbstractConversion;
import org.eclipse.ocl.examples.pivot.utilities.AliasAdapter;
import org.eclipse.ocl.examples.pivot.utilities.PivotObjectImpl;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.resource.UMLResource;
import org.eclipse.uml2.uml.resources.util.UMLResourcesUtil;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UML2Pivot
extends AbstractEcore2Pivot {
    @NonNull
    public static final String STEREOTYPE_BASE_PREFIX = "base_";
    @NonNull
    public static final String STEREOTYPE_EXTENSION_PREFIX = "extension_";
    private static final Logger logger = Logger.getLogger(UML2Pivot.class);
    public static MetaModelManager.Factory FACTORY = new Factory();
    @NonNull
    protected final Resource umlResource;
    protected Root pivotRoot = null;
    private URI umlURI = null;

    @Nullable
    public static UML2Pivot findAdapter(@NonNull Resource resource, @NonNull MetaModelManager metaModelManager) {
        for (Adapter adapter : resource.eAdapters()) {
            UML2Pivot uml2Pivot;
            if (!(adapter instanceof UML2Pivot) || (uml2Pivot = (UML2Pivot)adapter).getMetaModelManager() != metaModelManager) continue;
            return uml2Pivot;
        }
        return null;
    }

    @NonNull
    public static UML2Pivot getAdapter(@NonNull Resource resource, @Nullable MetaModelManager metaModelManager) {
        UML2Pivot adapter;
        if (metaModelManager == null) {
            metaModelManager = new MetaModelManager();
        } else {
            adapter = UML2Pivot.findAdapter(resource, metaModelManager);
            if (adapter != null) {
                return adapter;
            }
        }
        adapter = new Outer(resource, metaModelManager);
        resource.eAdapters().add((Object)adapter);
        return adapter;
    }

    public static Root importFromUML(@NonNull MetaModelManager metaModelManager, String alias, Resource umlResource) throws ParserException {
        if (umlResource == null) {
            return null;
        }
        UML2Pivot conversion = UML2Pivot.getAdapter(umlResource, metaModelManager);
        return conversion.getPivotRoot();
    }

    public static Element importFromUML(@NonNull MetaModelManager metaModelManager, String alias, EObject eObject) throws ParserException {
        if (eObject == null) {
            return null;
        }
        Resource umlResource = eObject.eResource();
        if (umlResource == null) {
            return null;
        }
        UML2Pivot conversion = UML2Pivot.getAdapter(umlResource, metaModelManager);
        Root pivotRoot = conversion.getPivotRoot();
        return conversion.getCreated(Element.class, eObject);
    }

    public static String initialize(@NonNull ResourceSet resourceSet) {
        UMLResourcesUtil.init((ResourceSet)resourceSet);
        String resourcesPluginId = "org.eclipse.uml2.uml.resources";
        String resourcesLocation = null;
        StandaloneProjectMap projectMap = StandaloneProjectMap.getAdapter((ResourceSet)resourceSet);
        URI locationURI = projectMap.getLocation("org.eclipse.uml2.uml.resources");
        if (locationURI != null) {
            resourcesLocation = locationURI.toString();
            while (resourcesLocation.endsWith("/")) {
                resourcesLocation = resourcesLocation.substring(0, resourcesLocation.length() - 1);
            }
        }
        if (resourcesLocation == null) {
            return "'org.eclipse.uml2.uml.resources' not found on class-path";
        }
        Map uriMap = resourceSet.getURIConverter().getURIMap();
        uriMap.put(URI.createURI((String)"pathmap://UML_PROFILES/"), URI.createURI((String)(String.valueOf(resourcesLocation) + "/profiles/")));
        uriMap.put(URI.createURI((String)"pathmap://UML_METAMODELS/"), URI.createURI((String)(String.valueOf(resourcesLocation) + "/metamodels/")));
        uriMap.put(URI.createURI((String)"pathmap://UML_LIBRARIES/"), URI.createURI((String)(String.valueOf(resourcesLocation) + "/libraries/")));
        return null;
    }

    public static String initialize(@NonNull StandaloneProjectMap projectMap) {
        UMLResourcesUtil.init(null);
        String resourcesPluginId = "org.eclipse.uml2.uml.resources";
        String resourcesLocation = null;
        URI locationURI = projectMap.getLocation("org.eclipse.uml2.uml.resources");
        if (locationURI != null) {
            resourcesLocation = locationURI.toString();
            while (resourcesLocation.endsWith("/")) {
                resourcesLocation = resourcesLocation.substring(0, resourcesLocation.length() - 1);
            }
        }
        if (resourcesLocation == null) {
            return "'org.eclipse.uml2.uml.resources' not found on class-path";
        }
        Map uriMap = URIConverter.URI_MAP;
        uriMap.put(URI.createURI((String)"pathmap://UML_PROFILES/"), URI.createURI((String)(String.valueOf(resourcesLocation) + "/profiles/")));
        uriMap.put(URI.createURI((String)"pathmap://UML_METAMODELS/"), URI.createURI((String)(String.valueOf(resourcesLocation) + "/metamodels/")));
        uriMap.put(URI.createURI((String)"pathmap://UML_LIBRARIES/"), URI.createURI((String)(String.valueOf(resourcesLocation) + "/libraries/")));
        return null;
    }

    public static boolean isUML(@NonNull Resource resource) {
        EList contents = resource.getContents();
        for (EObject content : contents) {
            if (!(content instanceof org.eclipse.uml2.uml.Package)) continue;
            return true;
        }
        return false;
    }

    protected UML2Pivot(@NonNull Resource umlResource, @NonNull MetaModelManager metaModelManager) {
        super(metaModelManager);
        this.umlResource = umlResource;
        metaModelManager.addExternalResource(this);
        metaModelManager.addListener(this);
    }

    public abstract void addCreated(@NonNull EObject var1, @NonNull Element var2);

    public void addImportedPackages(@NonNull List<? extends org.eclipse.uml2.uml.Package> importedPackages) {
        for (org.eclipse.uml2.uml.Package package_ : importedPackages) {
            EObject rootContainer = EcoreUtil.getRootContainer((EObject)package_);
            Resource importedResource = (Resource)DomainUtil.nonNullEMF((Object)rootContainer.eResource());
            this.addImportedResource(importedResource);
        }
    }

    public abstract void addImportedResource(@NonNull Resource var1);

    public abstract void addProperties(@NonNull List<org.eclipse.uml2.uml.Property> var1, @Nullable AbstractConversion.Predicate<org.eclipse.uml2.uml.Property> var2);

    public abstract void addStereotypeApplication(@NonNull EObject var1);

    @NonNull
    protected URI createPivotURI() {
        URI uri = this.umlResource.getURI();
        if (uri == null) {
            throw new IllegalStateException("Missing resource URI");
        }
        return PivotUtil.getPivotURI(uri);
    }

    public void dispose() {
        this.metaModelManager.removeExternalResource(this);
        this.getTarget().eAdapters().remove((Object)this);
        this.metaModelManager.removeListener(this);
    }

    @Override
    public abstract void error(@NonNull String var1);

    @Nullable
    public abstract <T extends Element> T getCreated(@NonNull java.lang.Class<T> var1, @NonNull EObject var2);

    @NonNull
    public abstract UML2PivotDeclarationSwitch getDeclarationPass();

    @NonNull
    public abstract Root getPivotRoot() throws ParserException;

    @Nullable
    public abstract Type getPivotType(@NonNull EObject var1);

    @Override
    @NonNull
    public Resource getResource() {
        return this.umlResource;
    }

    @NonNull
    public abstract Outer getRoot();

    @NonNull
    public Notifier getTarget() {
        return this.umlResource;
    }

    @Override
    @NonNull
    public URI getURI() {
        return (URI)DomainUtil.nonNullState((Object)this.umlResource.getURI());
    }

    @NonNull
    protected Root installDeclarations(@NonNull Resource pivotResource) {
        URI pivotURI = pivotResource.getURI();
        Root pivotRoot2 = this.pivotRoot = this.metaModelManager.createRoot(pivotURI.lastSegment(), this.umlURI != null ? this.umlURI.toString() : pivotURI.toString());
        pivotResource.getContents().add((Object)pivotRoot2);
        UML2PivotDeclarationSwitch declarationPass = this.getDeclarationPass();
        ArrayList<Package> rootPackages = new ArrayList<Package>();
        for (EObject eObject : this.umlResource.getContents()) {
            Object pivotElement = declarationPass.doSwitch(eObject);
            if (pivotElement instanceof Package) {
                rootPackages.add((Package)pivotElement);
                continue;
            }
            if (pivotElement == null) continue;
            this.error("Bad UML content : " + eObject.eClass().getName());
        }
        PivotUtil.refreshList(pivotRoot2.getNestedPackage(), rootPackages);
        return pivotRoot2;
    }

    @Override
    public boolean isAdapterFor(@NonNull MetaModelManager metaModelManager) {
        return this.metaModelManager == metaModelManager;
    }

    public boolean isAdapterForType(Object type) {
        return type == UML2Pivot.class;
    }

    protected boolean isPivot(@NonNull Collection<EObject> umlContents) {
        if (umlContents.size() != 1) {
            return false;
        }
        EObject umlRoot = umlContents.iterator().next();
        if (!(umlRoot instanceof EPackage)) {
            return false;
        }
        EPackage umlPackage = (EPackage)umlRoot;
        if (umlPackage.getEClassifier(PivotPackage.Literals.ENUMERATION_LITERAL.getName()) == null) {
            return false;
        }
        if (umlPackage.getEClassifier(PivotPackage.Literals.EXPRESSION_IN_OCL.getName()) == null) {
            return false;
        }
        if (umlPackage.getEClassifier(PivotPackage.Literals.OPERATION_CALL_EXP.getName()) == null) {
            return false;
        }
        return umlPackage.getEClassifier(PivotPackage.Literals.TEMPLATE_PARAMETER_SUBSTITUTION.getName()) != null;
    }

    @Override
    public void metaModelManagerDisposed(@NonNull MetaModelManager metaModelManager) {
        this.dispose();
    }

    public void notifyChanged(Notification notification) {
    }

    protected <T extends Element> T refreshElement(@NonNull java.lang.Class<T> pivotClass, EClass pivotEClass, @NonNull EObject umlElement) {
        assert (pivotEClass != null);
        EFactory eFactoryInstance = pivotEClass.getEPackage().getEFactoryInstance();
        EObject pivotElement = eFactoryInstance.create(pivotEClass);
        if (!pivotClass.isAssignableFrom(pivotElement.getClass())) {
            throw new ClassCastException();
        }
        Element castElement = (Element)pivotElement;
        return (T)castElement;
    }

    @NonNull
    protected <T extends NamedElement> T refreshNamedElement(@NonNull java.lang.Class<T> pivotClass, EClass pivotEClass, @NonNull org.eclipse.uml2.uml.NamedElement umlNamedElement) {
        assert (pivotEClass != null);
        EFactory eFactoryInstance = pivotEClass.getEPackage().getEFactoryInstance();
        EObject pivotElement = eFactoryInstance.create(pivotEClass);
        if (!pivotClass.isAssignableFrom(pivotElement.getClass())) {
            throw new ClassCastException();
        }
        NamedElement castElement = (NamedElement)pivotElement;
        castElement.setName(umlNamedElement.getName());
        return (T)castElement;
    }

    @Nullable
    protected Type resolveType(@NonNull org.eclipse.uml2.uml.Type umlType) {
        Type pivotType = this.getCreated(Type.class, (EObject)umlType);
        if (pivotType != null) {
            return pivotType;
        }
        if (umlType instanceof PrimitiveType) {
            if (UMLUtil.isBoolean((org.eclipse.uml2.uml.Type)umlType)) {
                return this.metaModelManager.getBooleanType();
            }
            if (UMLUtil.isInteger((org.eclipse.uml2.uml.Type)umlType)) {
                return this.metaModelManager.getStringType();
            }
            if (UMLUtil.isReal((org.eclipse.uml2.uml.Type)umlType)) {
                return this.metaModelManager.getStringType();
            }
            if (UMLUtil.isString((org.eclipse.uml2.uml.Type)umlType)) {
                return this.metaModelManager.getStringType();
            }
            if (UMLUtil.isUnlimitedNatural((org.eclipse.uml2.uml.Type)umlType)) {
                return this.metaModelManager.getStringType();
            }
        }
        return pivotType;
    }

    @Nullable
    protected Type resolveTypeParameter(@NonNull EGenericType eGenericType) {
        EClassifier eClassifier = eGenericType.getEClassifier();
        ETypeParameter eTypeParameter = eGenericType.getETypeParameter();
        if (eTypeParameter != null) {
            EList eTypeArguments = eGenericType.getETypeArguments();
            assert (eClassifier == null);
            assert (eTypeArguments.isEmpty());
            Type pivotType = this.getCreated(Type.class, (EObject)eTypeParameter);
            return pivotType;
        }
        return null;
    }

    @Nullable
    protected Type resolveWildcardType(@NonNull EGenericType eGenericType) {
        EObject eContainer;
        List list;
        int index;
        assert (eGenericType.getETypeArguments().isEmpty());
        assert (eGenericType.getEClassifier() == null);
        EClassifier eClassifier = eGenericType.getERawType();
        assert (eClassifier == EcorePackage.Literals.EJAVA_OBJECT);
        Class pivotElement = PivotFactory.eINSTANCE.createClass();
        String name = "wildcard";
        EReference eFeature = eGenericType.eContainmentFeature();
        if (eFeature != null && eFeature.isMany() && (index = (list = (List)(eContainer = eGenericType.eContainer()).eGet(eGenericType.eContainingFeature())).indexOf(eGenericType)) != 0) {
            name = String.valueOf(name) + index;
        }
        pivotElement.setName(name);
        return pivotElement;
    }

    protected void setOriginalMapping(@NonNull Element pivotElement, @NonNull EObject umlElement) {
        ((PivotObjectImpl)((Object)pivotElement)).setTarget((Notifier)umlElement);
        this.addCreated(umlElement, pivotElement);
    }

    public void setTarget(Notifier newTarget) {
        assert (newTarget == null || newTarget == this.umlResource);
    }

    public void setUMLURI(URI umlURI) {
        this.umlURI = umlURI;
    }

    public void unsetTarget(Notifier oldTarget) {
        assert (oldTarget == this.umlResource);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Factory
    extends MetaModelManager.AbstractFactory {
        private Factory() {
            MetaModelManager.addFactory(this);
        }

        @Override
        public int getHandlerPriority(@NonNull EObject eObject) {
            if (eObject instanceof org.eclipse.uml2.uml.Element) {
                return 100;
            }
            if (eObject.eResource() instanceof UMLResource) {
                return 100;
            }
            return -100;
        }

        @Override
        public int getHandlerPriority(@NonNull Resource resource) {
            return UML2Pivot.isUML(resource) ? 100 : -100;
        }

        @Override
        public void configure(@NonNull ResourceSet resourceSet) {
            OCL.initialize(resourceSet);
        }

        @Override
        @Nullable
        public URI getPackageURI(@NonNull EObject eObject) {
            String uri;
            if (eObject instanceof org.eclipse.uml2.uml.Package && (uri = ((org.eclipse.uml2.uml.Package)eObject).getURI()) != null) {
                return URI.createURI((String)uri);
            }
            return null;
        }

        @Override
        public <T extends Element> T getPivotOf(@NonNull MetaModelManager metaModelManager, @NonNull java.lang.Class<T> pivotClass, @NonNull EObject eObject) throws ParserException {
            Resource metaModel = eObject.eResource();
            if (metaModel == null) {
                return null;
            }
            UML2Pivot uml2pivot = UML2Pivot.getAdapter(metaModel, metaModelManager);
            uml2pivot.getPivotRoot();
            return uml2pivot.getCreated(pivotClass, eObject);
        }

        @Override
        @Nullable
        public Element importFromResource(@NonNull MetaModelManager metaModelManager, @NonNull Resource umlResource, @Nullable URI uri) throws ParserException {
            String uriFragment;
            UML2Pivot conversion = UML2Pivot.getAdapter(umlResource, metaModelManager);
            conversion.setUMLURI(uri);
            Root pivotRoot = conversion.getPivotRoot();
            String string = uriFragment = uri != null ? uri.fragment() : null;
            if (uriFragment == null) {
                return pivotRoot;
            }
            EObject eObject = umlResource.getEObject(uriFragment);
            if (eObject == null) {
                return null;
            }
            return conversion.getCreated(Element.class, eObject);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Inner
    extends UML2Pivot {
        @NonNull
        protected final Outer root;

        protected Inner(@NonNull Resource umlResource, @NonNull Outer root) {
            super(umlResource, root.getMetaModelManager());
            this.root = root;
        }

        @Override
        public void addCreated(@NonNull EObject umlElement, @NonNull Element pivotElement) {
            this.root.addCreated(umlElement, pivotElement);
        }

        @Override
        public void addGenericType(@NonNull EGenericType eObject) {
            this.root.addGenericType(eObject);
        }

        @Override
        public void addImportedResource(@NonNull Resource importedResource) {
            this.root.addImportedResource(importedResource);
        }

        @Override
        public void addMapping(@NonNull EObject eObject, @NonNull Element pivotElement) {
            this.root.addMapping(eObject, pivotElement);
        }

        @Override
        public void addProperties(@NonNull List<org.eclipse.uml2.uml.Property> properties, @Nullable AbstractConversion.Predicate<org.eclipse.uml2.uml.Property> predicate) {
            this.root.addProperties(properties, predicate);
        }

        @Override
        public void addStereotypeApplication(@NonNull EObject stereotypeApplication) {
            this.root.addStereotypeApplication(stereotypeApplication);
        }

        @Override
        public void error(@NonNull String message) {
            this.root.error(message);
        }

        @Override
        public <T extends Element> T getCreated(@NonNull java.lang.Class<T> requiredClass, @NonNull EObject eObject) {
            return this.root.getCreated(requiredClass, eObject);
        }

        @Override
        @NonNull
        public UML2PivotDeclarationSwitch getDeclarationPass() {
            return this.root.getDeclarationPass();
        }

        @Override
        @NonNull
        public Root getPivotRoot() throws ParserException {
            Root pivotRoot2 = this.pivotRoot;
            if (pivotRoot2 == null) {
                pivotRoot2 = this.root.getPivotRoot();
                Resource pivotResource = this.pivotRoot.eResource();
                if (pivotResource == null) {
                    throw new IllegalStateException("Missing containing resource");
                }
                this.metaModelManager.installResource(pivotResource);
            }
            return pivotRoot2;
        }

        @Override
        @Nullable
        public Type getPivotType(@NonNull EObject eObject) {
            return this.root.getPivotType(eObject);
        }

        @Override
        @NonNull
        public Outer getRoot() {
            return this.root;
        }

        @Override
        public void queueReference(@NonNull EObject umlElement) {
            this.root.queueReference(umlElement);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Outer
    extends UML2Pivot {
        @NonNull
        private Map<EObject, Element> createMap = new HashMap<EObject, Element>();
        @NonNull
        private Set<EObject> referencers = new HashSet<EObject>();
        @NonNull
        private Set<UML2Pivot> allConverters = new HashSet<UML2Pivot>();
        private List<Resource.Diagnostic> errors = null;
        @NonNull
        protected final UML2PivotDeclarationSwitch declarationPass = new UML2PivotDeclarationSwitch(this);
        @NonNull
        protected final UML2PivotReferenceSwitch referencePass = new UML2PivotReferenceSwitch(this);
        private List<Resource> importedResources = null;
        @NonNull
        private Set<org.eclipse.uml2.uml.Property> umlProperties = new HashSet<org.eclipse.uml2.uml.Property>();
        @NonNull
        private Map<Type, List<Property>> stereotypeProperties = new HashMap<Type, List<Property>>();
        @NonNull
        private List<EObject> umlStereotypeApplications = new ArrayList<EObject>();

        protected Outer(@NonNull Resource umlResource, @NonNull MetaModelManager metaModelManager) {
            super(umlResource, metaModelManager);
        }

        @Override
        public void addCreated(@NonNull EObject eObject, @NonNull Element pivotElement) {
            Element oldElement = this.createMap.put(eObject, pivotElement);
        }

        @Override
        public void addGenericType(@NonNull EGenericType eObject) {
        }

        @Override
        public void addImportedResource(@NonNull Resource importedResource) {
            if (importedResource != this.umlResource) {
                if (this.importedResources == null) {
                    this.importedResources = new ArrayList<Resource>();
                }
                if (!this.importedResources.contains(importedResource)) {
                    this.importedResources.add(importedResource);
                }
            }
        }

        @Override
        public void addMapping(@NonNull EObject eObject, @NonNull Element pivotElement) {
            if (pivotElement instanceof PivotObjectImpl) {
                ((PivotObjectImpl)((Object)pivotElement)).setTarget((Notifier)eObject);
            }
            this.addCreated(eObject, pivotElement);
        }

        @Override
        public void addProperties(@NonNull List<org.eclipse.uml2.uml.Property> properties, @Nullable AbstractConversion.Predicate<org.eclipse.uml2.uml.Property> predicate) {
            for (org.eclipse.uml2.uml.Property umlProperty : properties) {
                if (umlProperty == null || predicate != null && !predicate.filter(umlProperty)) continue;
                this.umlProperties.add(umlProperty);
            }
        }

        @Override
        public void addStereotypeApplication(@NonNull EObject umlStereotypeApplication) {
            this.umlStereotypeApplications.add(umlStereotypeApplication);
            EClass eClass = umlStereotypeApplication.eClass();
            EPackage ePackage = eClass.getEPackage();
            this.addImportedResource((Resource)DomainUtil.nonNullEMF((Object)ePackage.eResource()));
        }

        @Override
        public void error(@NonNull String message) {
            if (this.errors == null) {
                this.errors = new ArrayList<Resource.Diagnostic>();
            }
            this.errors.add((Resource.Diagnostic)new XMIException(message));
        }

        @Override
        public <T extends Element> T getCreated(@NonNull java.lang.Class<T> requiredClass, @NonNull EObject eObject) {
            Element element = this.createMap.get(eObject);
            if (element == null) {
                return null;
            }
            if (!requiredClass.isAssignableFrom(element.getClass())) {
                logger.error((Object)("UML " + element.getClass().getName() + "' element is not a '" + requiredClass.getName() + "'"));
                return null;
            }
            Element castElement = element;
            return (T)castElement;
        }

        @Override
        @NonNull
        public final UML2PivotDeclarationSwitch getDeclarationPass() {
            return this.declarationPass;
        }

        @Nullable
        public List<Resource> getImportedResources() {
            return this.importedResources;
        }

        @Override
        @NonNull
        public Root getPivotRoot() throws ParserException {
            Root pivotRoot2 = this.pivotRoot;
            if (pivotRoot2 == null) {
                URI pivotURI = this.createPivotURI();
                Resource pivotResource = this.metaModelManager.getResource(pivotURI, "org.eclipse.ocl.examples.pivot");
                try {
                    pivotRoot2 = this.installDeclarations(pivotResource);
                    this.installImports();
                    if (this.umlStereotypeApplications.size() > 0) {
                        this.installStereotypes();
                    }
                    this.installProperties();
                    this.installReferences();
                }
                catch (Exception e) {
                    throw new ParserException("Failed to load '" + pivotURI + "' : " + e.getMessage(), e);
                }
                if (this.errors != null) {
                    pivotResource.getErrors().addAll(this.errors);
                }
                this.installAliases(pivotResource);
                this.metaModelManager.installResource(pivotResource);
            }
            return pivotRoot2;
        }

        @Override
        public Type getPivotType(@NonNull EObject eObject) {
            Element pivotElement = this.createMap.get(eObject);
            if (pivotElement == null) {
                UML2Pivot converter;
                Resource resource = eObject.eResource();
                if (resource != this.umlResource && resource != null && this.allConverters.add(converter = Outer.getAdapter(resource, this.metaModelManager))) {
                    try {
                        converter.getPivotRoot();
                    }
                    catch (ParserException e) {
                        String message = e.getMessage();
                        this.error(message);
                    }
                }
                pivotElement = this.createMap.get(eObject);
            }
            if (pivotElement == null) {
                this.error("Unresolved " + eObject);
            } else if (!(pivotElement instanceof Type)) {
                this.error("Incompatible " + eObject);
            } else {
                return (Type)pivotElement;
            }
            return null;
        }

        @Override
        @NonNull
        public Outer getRoot() {
            return this;
        }

        protected void installAliases(@NonNull Resource pivotResource) {
            AliasAdapter umlAdapter = AliasAdapter.findAdapter(this.umlResource);
            if (umlAdapter != null) {
                Map<EObject, String> umlAliasMap = umlAdapter.getAliasMap();
                AliasAdapter pivotAdapter = AliasAdapter.getAdapter(pivotResource);
                Map<EObject, String> pivotAliasMap = pivotAdapter.getAliasMap();
                for (EObject eObject : umlAliasMap.keySet()) {
                    String alias = umlAliasMap.get(eObject);
                    Element element = this.createMap.get(eObject);
                    pivotAliasMap.put(element, alias);
                }
            }
        }

        protected void installImports() throws ParserException {
            if (this.importedResources != null) {
                int i = 0;
                while (i < this.importedResources.size()) {
                    Resource importedResource = this.importedResources.get(i);
                    if (importedResource != null) {
                        if (FACTORY.getHandlerPriority(importedResource) != 100) {
                            this.metaModelManager.loadResource(importedResource, null);
                        } else {
                            UML2Pivot adapter = UML2Pivot.findAdapter(importedResource, this.metaModelManager);
                            if (adapter == null) {
                                Inner importedAdapter = new Inner(importedResource, this);
                                importedResource.eAdapters().add((Object)importedAdapter);
                                URI pivotURI = importedAdapter.createPivotURI();
                                Resource pivotResource = this.metaModelManager.getResource(pivotURI, "org.eclipse.ocl.examples.pivot");
                                importedAdapter.installDeclarations(pivotResource);
                                adapter = importedAdapter;
                                this.metaModelManager.installResource(pivotResource);
                            }
                        }
                    }
                    ++i;
                }
            }
        }

        protected void installProperties() {
            HashMap typeProperties = new HashMap();
            ArrayList<org.eclipse.uml2.uml.Property> sortedList = new ArrayList<org.eclipse.uml2.uml.Property>(this.umlProperties);
            Collections.sort(sortedList, new Comparator<org.eclipse.uml2.uml.Property>(){

                @Override
                public int compare(org.eclipse.uml2.uml.Property o1, org.eclipse.uml2.uml.Property o2) {
                    String n2;
                    String n1 = o1.getName();
                    return n1 == (n2 = o2.getName()) ? 0 : (n1 != null && n2 != null ? n1.compareTo(n2) : (n2 == null ? 1 : -1));
                }
            });
            for (org.eclipse.uml2.uml.Property umlProperty : sortedList) {
                org.eclipse.uml2.uml.Property opposite;
                Type pivotType = null;
                EObject umlOwner = (EObject)DomainUtil.nonNullEMF((Object)umlProperty.eContainer());
                if (umlOwner instanceof Association) {
                    opposite = umlProperty.getOtherEnd();
                    if (opposite != null) {
                        pivotType = this.getCreated(Type.class, (EObject)DomainUtil.nonNullModel((Object)opposite.getType()));
                    }
                } else {
                    pivotType = this.getCreated(Type.class, umlOwner);
                }
                if (pivotType != null) {
                    String name;
                    ArrayList<org.eclipse.uml2.uml.Property> someProperties = (ArrayList<org.eclipse.uml2.uml.Property>)typeProperties.get(pivotType);
                    if (someProperties == null) {
                        someProperties = new ArrayList<org.eclipse.uml2.uml.Property>();
                        typeProperties.put(pivotType, someProperties);
                    }
                    if ((name = umlProperty.getName()) == null) {
                        name = umlProperty.getType().getName();
                        continue;
                    }
                    someProperties.add(umlProperty);
                    continue;
                }
                opposite = umlProperty.getOtherEnd();
                if (opposite == null) continue;
                org.eclipse.uml2.uml.Type oppositeType = (org.eclipse.uml2.uml.Type)DomainUtil.nonNullEMF((Object)opposite.getType());
                pivotType = this.getCreated(Type.class, (EObject)oppositeType);
            }
            HashSet allPropertiedTypes = new HashSet(typeProperties.keySet());
            allPropertiedTypes.addAll(this.stereotypeProperties.keySet());
            for (Type pivotType : allPropertiedTypes) {
                List umlProperties = (List)typeProperties.get(pivotType);
                List<Property> pivotProperties = this.stereotypeProperties.get(pivotType);
                pivotProperties = pivotProperties == null ? new ArrayList<Property>(umlProperties.size()) : new ArrayList<Property>(pivotProperties);
                if (umlProperties != null) {
                    for (org.eclipse.uml2.uml.Property umlProperty : umlProperties) {
                        Property pivotProperty;
                        if (umlProperty == null || (pivotProperty = this.getCreated(Property.class, (EObject)umlProperty)) == null) continue;
                        pivotProperties.add(pivotProperty);
                    }
                }
                Collections.sort(pivotProperties, new Comparator<Property>(){

                    @Override
                    public int compare(Property o1, Property o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                this.refreshList((List)DomainUtil.nonNullEMF(pivotType.getOwnedAttribute()), pivotProperties);
            }
        }

        protected void installReferences() {
            for (EObject eObject : this.referencers) {
                this.referencePass.doSwitch(eObject);
            }
        }

        protected void installStereotypes() {
            HashMap<EObject, List<org.eclipse.uml2.uml.Element>> stereotypedElements = new HashMap<EObject, List<org.eclipse.uml2.uml.Element>>();
            for (EObject umlStereotypeApplication : this.umlStereotypeApplications) {
                assert (umlStereotypeApplication != null);
                stereotypedElements.put(umlStereotypeApplication, this.resolveStereotypedElements(umlStereotypeApplication));
            }
            Map<Element, List<EObject>> stereotypeApplications = this.resolveStereotypeApplications(stereotypedElements);
            HashMap metaclassProperties = new HashMap();
            for (Element pivotStereotypedElement : stereotypeApplications.keySet()) {
                List<EObject> umlStereotypeApplications = stereotypeApplications.get(pivotStereotypedElement);
                List<ElementExtension> oldElementExtensions = pivotStereotypedElement.getExtension();
                ArrayList<ElementExtension> newElementExtensions = new ArrayList<ElementExtension>(umlStereotypeApplications.size());
                for (EObject umlStereotypeApplication : umlStereotypeApplications) {
                    assert (umlStereotypeApplication != null);
                    List umlStereotypedElements = (List)stereotypedElements.get(umlStereotypeApplication);
                    assert (umlStereotypedElements != null);
                    Type pivotStereotype = this.resolveStereotype(umlStereotypeApplication, umlStereotypedElements);
                    if (pivotStereotype == null) {
                        pivotStereotype = this.resolveStereotype(umlStereotypeApplication, umlStereotypedElements);
                    }
                    if (pivotStereotype == null) continue;
                    ElementExtension newElementExtension = null;
                    for (ElementExtension oldElementExtension : oldElementExtensions) {
                        if (oldElementExtension.getStereotype() != pivotStereotype) continue;
                        newElementExtension = oldElementExtension;
                    }
                    if (newElementExtension == null) {
                        newElementExtension = PivotFactory.eINSTANCE.createElementExtension();
                    }
                    newElementExtension.setStereotype(pivotStereotype);
                    newElementExtension.setName(String.valueOf(((NamedElement)pivotStereotypedElement).getName()) + "$" + pivotStereotype.getName());
                    newElementExtension.getSuperClass().add(this.metaModelManager.getOclAnyType());
                    this.setOriginalMapping(newElementExtension, umlStereotypeApplication);
                    newElementExtensions.add(newElementExtension);
                }
                this.refreshList(oldElementExtensions, newElementExtensions);
            }
            for (Metaclass metaclass : metaclassProperties.keySet()) {
                List newProperties = (List)metaclassProperties.get(metaclass);
                List<Property> oldProperties = metaclass.getOwnedAttribute();
                assert (oldProperties != null);
                this.refreshList(oldProperties, newProperties);
            }
        }

        @Override
        public void queueReference(@NonNull EObject umlElement) {
            this.referencers.add(umlElement);
        }

        @NonNull
        protected Map<Element, List<EObject>> resolveStereotypeApplications(@NonNull Map<EObject, List<org.eclipse.uml2.uml.Element>> stereotypedElements) {
            HashMap<Element, List<EObject>> stereotypeApplications = new HashMap<Element, List<EObject>>();
            for (EObject umlStereotypeApplication : this.umlStereotypeApplications) {
                assert (umlStereotypeApplication != null);
                List<org.eclipse.uml2.uml.Element> umlStereotypedElements = stereotypedElements.get(umlStereotypeApplication);
                assert (umlStereotypedElements != null);
                for (org.eclipse.uml2.uml.Element umlStereotypedElement : umlStereotypedElements) {
                    assert (umlStereotypedElement != null);
                    Element pivotStereotypedElement = this.getCreated(Element.class, (EObject)umlStereotypedElement);
                    ArrayList<EObject> umlElementExtensions = (ArrayList<EObject>)stereotypeApplications.get(pivotStereotypedElement);
                    if (umlElementExtensions == null) {
                        umlElementExtensions = new ArrayList<EObject>();
                        stereotypeApplications.put(pivotStereotypedElement, umlElementExtensions);
                    }
                    umlElementExtensions.add(umlStereotypeApplication);
                }
            }
            return stereotypeApplications;
        }

        @Nullable
        protected Type resolveStereotype(@NonNull EObject umlStereotypeApplication, @NonNull List<org.eclipse.uml2.uml.Element> umlStereotypedElements) {
            EClass umlStereotypeEClass = umlStereotypeApplication.eClass();
            if (!(umlStereotypeApplication instanceof DynamicEObjectImpl)) {
                return this.metaModelManager.getPivotOfEcore(Type.class, (EObject)umlStereotypeEClass);
            }
            org.eclipse.uml2.uml.Package umlStereotypedPackage = null;
            Iterator<org.eclipse.uml2.uml.Element> iterator = umlStereotypedElements.iterator();
            block0: while (iterator.hasNext()) {
                org.eclipse.uml2.uml.Element umlStereotypedElement;
                org.eclipse.uml2.uml.Element eObject = umlStereotypedElement = iterator.next();
                while (eObject != null) {
                    if (eObject instanceof org.eclipse.uml2.uml.Package) {
                        if (umlStereotypedPackage == null) {
                            umlStereotypedPackage = (org.eclipse.uml2.uml.Package)eObject;
                            continue block0;
                        }
                        if (umlStereotypedPackage == (org.eclipse.uml2.uml.Package)eObject) continue block0;
                        logger.error((Object)("Conflicting packages for stereotype application of " + umlStereotypeEClass.getName()));
                        continue block0;
                    }
                    eObject = eObject.eContainer();
                }
            }
            EPackage umlProfileEPackage = umlStereotypeEClass.getEPackage();
            if (umlStereotypedPackage != null) {
                String profileName = umlProfileEPackage.getName();
                org.eclipse.uml2.uml.Package umlPackage = umlStereotypedPackage;
                while (umlPackage != null) {
                    for (ProfileApplication umlProfileApplication : umlPackage.getProfileApplications()) {
                        Profile umlProfile = umlProfileApplication.getAppliedProfile();
                        if (!profileName.equals(umlProfile.getName())) continue;
                        org.eclipse.uml2.uml.Stereotype umlStereotype = umlProfile.getOwnedStereotype(umlStereotypeEClass.getName());
                        return umlStereotype != null ? this.getCreated(Stereotype.class, (EObject)umlStereotype) : null;
                    }
                    umlPackage = umlPackage.getNestingPackage();
                }
            }
            logger.error((Object)("Missing package for stereotype application of " + umlStereotypeEClass.getName()));
            return null;
        }

        @NonNull
        protected List<org.eclipse.uml2.uml.Element> resolveStereotypedElements(@NonNull EObject umlStereotypeApplication) {
            EClass eClass = umlStereotypeApplication.eClass();
            ArrayList<org.eclipse.uml2.uml.Element> umlStereotypedElements = new ArrayList<org.eclipse.uml2.uml.Element>();
            for (EStructuralFeature eStructuralFeature : eClass.getEAllStructuralFeatures()) {
                Object umlStereotypedElement;
                String featureName = eStructuralFeature.getName();
                if (featureName == null || !featureName.startsWith(UML2Pivot.STEREOTYPE_BASE_PREFIX) || !(eStructuralFeature instanceof EReference) || !umlStereotypeApplication.eIsSet(eStructuralFeature) || !((umlStereotypedElement = umlStereotypeApplication.eGet(eStructuralFeature)) instanceof org.eclipse.uml2.uml.Element)) continue;
                umlStereotypedElements.add((org.eclipse.uml2.uml.Element)umlStereotypedElement);
            }
            return umlStereotypedElements;
        }
    }
}

