/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.uml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.Annotation;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.Comment;
import org.eclipse.ocl.examples.pivot.ConnectionPointReference;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.DataType;
import org.eclipse.ocl.examples.pivot.DynamicElement;
import org.eclipse.ocl.examples.pivot.DynamicType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Enumeration;
import org.eclipse.ocl.examples.pivot.EnumerationLiteral;
import org.eclipse.ocl.examples.pivot.FinalState;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.Profile;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Pseudostate;
import org.eclipse.ocl.examples.pivot.Region;
import org.eclipse.ocl.examples.pivot.State;
import org.eclipse.ocl.examples.pivot.StateMachine;
import org.eclipse.ocl.examples.pivot.Stereotype;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Transition;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeTemplateParameter;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2PivotDeclarationSwitch;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.TypeServer;
import org.eclipse.ocl.examples.pivot.uml.UML2Pivot;
import org.eclipse.ocl.examples.pivot.utilities.AbstractConversion;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ClassifierTemplateParameter;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.LiteralSpecification;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UML2PivotDeclarationSwitch
extends UMLSwitch<Object> {
    protected final Ecore2PivotDeclarationSwitch ecoreSwitch;
    protected final UML2Pivot converter;
    protected final MetaModelManager metaModelManager;

    public UML2PivotDeclarationSwitch(UML2Pivot converter) {
        this.converter = converter;
        this.ecoreSwitch = new Ecore2PivotDeclarationSwitch(converter);
        this.metaModelManager = converter.getMetaModelManager();
    }

    public Object caseAssociation(Association umlAssociation) {
        assert (umlAssociation != null);
        EList memberEnds = umlAssociation.getMemberEnds();
        this.converter.addProperties((List<org.eclipse.uml2.uml.Property>)memberEnds, null);
        Property firstPivotElement = null;
        for (org.eclipse.uml2.uml.Property umlProperty : memberEnds) {
            Property pivotElement = (Property)this.doSwitch((EObject)umlProperty);
            if (firstPivotElement == null) {
                firstPivotElement = pivotElement;
                continue;
            }
            firstPivotElement.setOpposite(pivotElement);
            pivotElement.setOpposite(firstPivotElement);
        }
        return this;
    }

    public Class caseClass(org.eclipse.uml2.uml.Class umlClass) {
        assert (umlClass != null);
        Class pivotElement = this.converter.refreshNamedElement(Class.class, PivotPackage.Literals.CLASS, (org.eclipse.uml2.uml.NamedElement)umlClass);
        this.copyClass(pivotElement, umlClass);
        return pivotElement;
    }

    public Object caseClassifierTemplateParameter(ClassifierTemplateParameter umlTemplateParameter) {
        assert (umlTemplateParameter != null);
        org.eclipse.uml2.uml.Class umlParameterClass = (org.eclipse.uml2.uml.Class)umlTemplateParameter.getParameteredElement();
        Class pivotElement = this.converter.refreshNamedElement(Class.class, PivotPackage.Literals.CLASS, (org.eclipse.uml2.uml.NamedElement)umlParameterClass);
        TypeTemplateParameter typeTemplateParameter = (TypeTemplateParameter)pivotElement.getTemplateParameter();
        if (typeTemplateParameter == null) {
            typeTemplateParameter = PivotFactory.eINSTANCE.createTypeTemplateParameter();
            typeTemplateParameter.setOwnedParameteredElement(pivotElement);
            this.converter.setOriginalMapping(typeTemplateParameter, (EObject)umlTemplateParameter);
        }
        this.converter.setOriginalMapping(pivotElement, (EObject)umlParameterClass);
        return typeTemplateParameter;
    }

    public Comment caseComment(org.eclipse.uml2.uml.Comment umlComment) {
        assert (umlComment != null);
        Comment pivotElement = this.converter.refreshElement(Comment.class, PivotPackage.Literals.COMMENT, (EObject)umlComment);
        pivotElement.setBody(umlComment.getBody());
        this.copyComments(pivotElement, (org.eclipse.uml2.uml.Element)umlComment);
        return pivotElement;
    }

    public ConnectionPointReference caseConnectionPointReference(org.eclipse.uml2.uml.ConnectionPointReference umlConnectionPointReference) {
        assert (umlConnectionPointReference != null);
        ConnectionPointReference pivotElement = this.converter.refreshNamedElement(ConnectionPointReference.class, PivotPackage.Literals.CONNECTION_POINT_REFERENCE, (org.eclipse.uml2.uml.NamedElement)umlConnectionPointReference);
        this.copyNamedElement(pivotElement, (org.eclipse.uml2.uml.NamedElement)umlConnectionPointReference);
        return pivotElement;
    }

    public Constraint caseConstraint(org.eclipse.uml2.uml.Constraint umlConstraint) {
        assert (umlConstraint != null);
        Constraint pivotElement = this.converter.refreshNamedElement(Constraint.class, PivotPackage.Literals.CONSTRAINT, (org.eclipse.uml2.uml.NamedElement)umlConstraint);
        Object pivotSpecification = this.doSwitch((EObject)umlConstraint.getSpecification());
        pivotElement.setSpecification((OpaqueExpression)pivotSpecification);
        this.copyNamedElement(pivotElement, (org.eclipse.uml2.uml.NamedElement)umlConstraint);
        if (!umlConstraint.getConstrainedElements().isEmpty()) {
            this.converter.queueReference((EObject)umlConstraint);
        } else {
            pivotElement.getConstrainedElement().clear();
        }
        return pivotElement;
    }

    public DataType caseDataType(org.eclipse.uml2.uml.DataType umlDataType) {
        assert (umlDataType != null);
        DataType pivotElement = this.converter.refreshNamedElement(DataType.class, PivotPackage.Literals.DATA_TYPE, (org.eclipse.uml2.uml.NamedElement)umlDataType);
        this.copyDataTypeOrEnum(pivotElement, umlDataType);
        EList umlAttributes = umlDataType.getAttributes();
        this.doSwitchAll((List<? extends EObject>)umlAttributes);
        this.converter.addProperties((List<org.eclipse.uml2.uml.Property>)umlAttributes, null);
        pivotElement.getSuperClass().add(this.metaModelManager.getOclAnyType());
        return pivotElement;
    }

    public Enumeration caseEnumeration(org.eclipse.uml2.uml.Enumeration umlEnumeration) {
        assert (umlEnumeration != null);
        Enumeration pivotElement = this.converter.refreshNamedElement(Enumeration.class, PivotPackage.Literals.ENUMERATION, (org.eclipse.uml2.uml.NamedElement)umlEnumeration);
        this.copyDataTypeOrEnum(pivotElement, (org.eclipse.uml2.uml.DataType)umlEnumeration);
        this.doSwitchAll((Collection)pivotElement.getOwnedLiteral(), (List)umlEnumeration.getOwnedLiterals(), null);
        pivotElement.getSuperClass().add(this.metaModelManager.getEnumerationType());
        return pivotElement;
    }

    public EnumerationLiteral caseEnumerationLiteral(org.eclipse.uml2.uml.EnumerationLiteral umlEnumLiteral) {
        assert (umlEnumLiteral != null);
        EnumerationLiteral pivotElement = this.converter.refreshNamedElement(EnumerationLiteral.class, PivotPackage.Literals.ENUMERATION_LITERAL, (org.eclipse.uml2.uml.NamedElement)umlEnumLiteral);
        this.copyNamedElement(pivotElement, (org.eclipse.uml2.uml.NamedElement)umlEnumLiteral);
        return pivotElement;
    }

    public FinalState caseFinalState(org.eclipse.uml2.uml.FinalState umlState) {
        assert (umlState != null);
        FinalState pivotElement = this.converter.refreshNamedElement(FinalState.class, PivotPackage.Literals.FINAL_STATE, (org.eclipse.uml2.uml.NamedElement)umlState);
        this.copyState(pivotElement, (org.eclipse.uml2.uml.State)umlState);
        return pivotElement;
    }

    public Object caseInstanceValue(InstanceValue umlInstanceValue) {
        assert (umlInstanceValue != null);
        OpaqueExpression pivotElement = this.converter.refreshNamedElement(OpaqueExpression.class, PivotPackage.Literals.OPAQUE_EXPRESSION, (org.eclipse.uml2.uml.NamedElement)umlInstanceValue);
        pivotElement.getBody().clear();
        pivotElement.getLanguage().clear();
        String umlBody = umlInstanceValue.getQualifiedName();
        pivotElement.getBody().add(umlBody);
        this.copyNamedElement(pivotElement, (org.eclipse.uml2.uml.NamedElement)umlInstanceValue);
        return pivotElement;
    }

    public Class caseInterface(Interface umlInterface) {
        assert (umlInterface != null);
        Class pivotElement = this.converter.refreshNamedElement(Class.class, PivotPackage.Literals.CLASS, (org.eclipse.uml2.uml.NamedElement)umlInterface);
        pivotElement.setIsInterface(true);
        this.copyClassOrInterface(pivotElement, (Classifier)umlInterface);
        return pivotElement;
    }

    public Object caseLiteralSpecification(LiteralSpecification umlLiteral) {
        assert (umlLiteral != null);
        OpaqueExpression pivotElement = this.converter.refreshNamedElement(OpaqueExpression.class, PivotPackage.Literals.OPAQUE_EXPRESSION, (org.eclipse.uml2.uml.NamedElement)umlLiteral);
        pivotElement.getBody().clear();
        pivotElement.getLanguage().clear();
        String umlBody = umlLiteral.toString();
        String s = umlBody.trim();
        if (s.startsWith("result")) {
            s = s.substring(6);
            if ((s = s.trim()).startsWith("=")) {
                s = s.substring(1);
                umlBody = s.trim();
            }
        }
        pivotElement.getBody().add(umlBody);
        this.copyNamedElement(pivotElement, (org.eclipse.uml2.uml.NamedElement)umlLiteral);
        return pivotElement;
    }

    public OpaqueExpression caseOpaqueExpression(org.eclipse.uml2.uml.OpaqueExpression umlExpression) {
        assert (umlExpression != null);
        OpaqueExpression pivotElement = this.converter.refreshNamedElement(OpaqueExpression.class, PivotPackage.Literals.OPAQUE_EXPRESSION, (org.eclipse.uml2.uml.NamedElement)umlExpression);
        pivotElement.getBody().clear();
        pivotElement.getLanguage().clear();
        EList umlBodies = umlExpression.getBodies();
        EList umlLanguages = umlExpression.getLanguages();
        int i = 0;
        while (i < umlBodies.size()) {
            String s;
            String umlLanguage = null;
            if (i < umlLanguages.size()) {
                umlLanguage = (String)umlLanguages.get(i);
                pivotElement.getLanguage().add(umlLanguage);
            }
            String umlBody = (String)umlBodies.get(i);
            if ((umlLanguage == null || umlLanguage.equals("OCL")) && (s = umlBody.trim()).startsWith("result")) {
                s = s.substring(6);
                if ((s = s.trim()).startsWith("=")) {
                    s = s.substring(1);
                    umlBody = s.trim();
                }
            }
            pivotElement.getBody().add(umlBody);
            ++i;
        }
        this.copyNamedElement(pivotElement, (org.eclipse.uml2.uml.NamedElement)umlExpression);
        return pivotElement;
    }

    public Operation caseOperation(org.eclipse.uml2.uml.Operation umlOperation) {
        ArrayList<org.eclipse.uml2.uml.Constraint> exclusions;
        assert (umlOperation != null);
        Operation pivotElement = this.converter.refreshNamedElement(Operation.class, PivotPackage.Literals.OPERATION, (org.eclipse.uml2.uml.NamedElement)umlOperation);
        EList preconditions = umlOperation.getPreconditions();
        org.eclipse.uml2.uml.Constraint bodyCondition = umlOperation.getBodyCondition();
        EList postconditions = umlOperation.getPostconditions();
        this.doSwitchAll((Collection)pivotElement.getPrecondition(), (List)preconditions, null);
        this.doSwitchAll((Collection)pivotElement.getPostcondition(), (List)postconditions, null);
        Constraint constraint = bodyCondition != null ? (Constraint)this.doSwitch((EObject)bodyCondition) : null;
        pivotElement.setBodyExpression(constraint != null ? constraint.getSpecification() : null);
        if (preconditions.size() > 0 || bodyCondition != null || postconditions.size() > 0) {
            exclusions = new ArrayList();
            exclusions.addAll((Collection<org.eclipse.uml2.uml.Constraint>)preconditions);
            if (bodyCondition != null) {
                exclusions.add(bodyCondition);
            }
            exclusions.addAll((Collection<org.eclipse.uml2.uml.Constraint>)postconditions);
        } else {
            exclusions = Collections.emptyList();
        }
        this.copyNamespace(pivotElement, (org.eclipse.uml2.uml.Namespace)umlOperation, exclusions);
        for (org.eclipse.uml2.uml.Parameter umlParameter : umlOperation.getOwnedParameters()) {
            Parameter pivotObject;
            ParameterDirectionKind direction = umlParameter.getDirection();
            if (direction != ParameterDirectionKind.IN_LITERAL || (pivotObject = (Parameter)this.doSwitch((EObject)umlParameter)) == null) continue;
            pivotElement.getOwnedParameter().add(pivotObject);
        }
        this.copyTemplateSignature(pivotElement, umlOperation.getOwnedTemplateSignature());
        this.converter.queueReference((EObject)umlOperation);
        return pivotElement;
    }

    public Package casePackage(org.eclipse.uml2.uml.Package umlPackage) {
        assert (umlPackage != null);
        Package pivotElement = this.converter.refreshNamedElement(Package.class, PivotPackage.Literals.PACKAGE, (org.eclipse.uml2.uml.NamedElement)umlPackage);
        this.copyPackage(pivotElement, umlPackage);
        return pivotElement;
    }

    public Parameter caseParameter(org.eclipse.uml2.uml.Parameter eObject) {
        assert (eObject != null);
        Parameter pivotElement = this.converter.refreshNamedElement(Parameter.class, PivotPackage.Literals.PARAMETER, (org.eclipse.uml2.uml.NamedElement)eObject);
        this.copyTypedMultiplicityElement(pivotElement, (TypedElement)eObject, null);
        return pivotElement;
    }

    public PrimitiveType casePrimitiveType(org.eclipse.uml2.uml.PrimitiveType umlPrimitiveType) {
        Object object;
        assert (umlPrimitiveType != null);
        PrimitiveType primaryElement = null;
        String name = umlPrimitiveType.getName();
        if ("Boolean".equals(name)) {
            primaryElement = this.metaModelManager.getBooleanType();
        } else if ("Integer".equals(name)) {
            primaryElement = this.metaModelManager.getIntegerType();
        } else if ("Real".equals(name)) {
            primaryElement = this.metaModelManager.getRealType();
        } else if ("String".equals(name)) {
            primaryElement = this.metaModelManager.getStringType();
        } else if ("UnlimitedNatural".equals(name)) {
            primaryElement = this.metaModelManager.getUnlimitedNaturalType();
        }
        PrimitiveType pivotElement = this.converter.refreshNamedElement(PrimitiveType.class, PivotPackage.Literals.PRIMITIVE_TYPE, (org.eclipse.uml2.uml.NamedElement)umlPrimitiveType);
        if (primaryElement != null) {
            TypeServer typeServer1 = this.metaModelManager.getTypeServer(primaryElement);
            TypeServer typeServer2 = this.metaModelManager.getTypeServer(pivotElement);
            pivotElement.setBehavioralType(primaryElement);
        }
        this.copyClassifier(pivotElement, (Classifier)umlPrimitiveType);
        String instanceClassName = null;
        org.eclipse.uml2.uml.Stereotype ecoreStereotype = umlPrimitiveType.getAppliedStereotype("Ecore::EDataType");
        if (ecoreStereotype != null && (object = umlPrimitiveType.getValue(ecoreStereotype, "instanceClassName")) instanceof String) {
            instanceClassName = (String)object;
        }
        pivotElement.setInstanceClassName(instanceClassName);
        return pivotElement;
    }

    public Object caseProfile(org.eclipse.uml2.uml.Profile umlProfile) {
        assert (umlProfile != null);
        Profile pivotElement = this.converter.refreshNamedElement(Profile.class, PivotPackage.Literals.PROFILE, (org.eclipse.uml2.uml.NamedElement)umlProfile);
        this.copyPackage(pivotElement, (org.eclipse.uml2.uml.Package)umlProfile);
        return pivotElement;
    }

    public Property caseProperty(org.eclipse.uml2.uml.Property umlProperty) {
        assert (umlProperty != null);
        Property pivotElement = this.converter.refreshNamedElement(Property.class, PivotPackage.Literals.PROPERTY, (org.eclipse.uml2.uml.NamedElement)umlProperty);
        this.copyProperty(pivotElement, umlProperty, null);
        pivotElement.setIsComposite(umlProperty.getClass_() != null && umlProperty.isComposite());
        pivotElement.setImplicit(umlProperty.getClass_() == null);
        this.converter.queueReference((EObject)umlProperty);
        ValueSpecification defaultValue = umlProperty.getDefaultValue();
        pivotElement.setDefaultExpression((OpaqueExpression)(defaultValue != null ? this.doSwitch((EObject)defaultValue) : null));
        return pivotElement;
    }

    public Pseudostate casePseudostate(org.eclipse.uml2.uml.Pseudostate umlPseudostate) {
        assert (umlPseudostate != null);
        Pseudostate pivotElement = this.converter.refreshNamedElement(Pseudostate.class, PivotPackage.Literals.PSEUDOSTATE, (org.eclipse.uml2.uml.NamedElement)umlPseudostate);
        this.copyNamedElement(pivotElement, (org.eclipse.uml2.uml.NamedElement)umlPseudostate);
        return pivotElement;
    }

    public Region caseRegion(org.eclipse.uml2.uml.Region umlRegion) {
        assert (umlRegion != null);
        Region pivotElement = this.converter.refreshNamedElement(Region.class, PivotPackage.Literals.REGION, (org.eclipse.uml2.uml.NamedElement)umlRegion);
        this.copyNamespace(pivotElement, (org.eclipse.uml2.uml.Namespace)umlRegion, null);
        this.doSwitchAll((Collection)pivotElement.getSubvertex(), (List)umlRegion.getSubvertices(), null);
        this.doSwitchAll((Collection)pivotElement.getTransition(), (List)umlRegion.getTransitions(), null);
        return pivotElement;
    }

    public State caseState(org.eclipse.uml2.uml.State umlState) {
        assert (umlState != null);
        State pivotElement = this.converter.refreshNamedElement(State.class, PivotPackage.Literals.STATE, (org.eclipse.uml2.uml.NamedElement)umlState);
        this.copyState(pivotElement, umlState);
        return pivotElement;
    }

    public StateMachine caseStateMachine(org.eclipse.uml2.uml.StateMachine umlStateMachine) {
        assert (umlStateMachine != null);
        StateMachine pivotElement = this.converter.refreshNamedElement(StateMachine.class, PivotPackage.Literals.STATE_MACHINE, (org.eclipse.uml2.uml.NamedElement)umlStateMachine);
        this.copyClass(pivotElement, (org.eclipse.uml2.uml.Class)umlStateMachine);
        this.doSwitchAll((Collection)pivotElement.getRegion(), (List)umlStateMachine.getRegions(), null);
        return pivotElement;
    }

    public Stereotype caseStereotype(org.eclipse.uml2.uml.Stereotype umlStereotype) {
        assert (umlStereotype != null);
        Stereotype pivotElement = this.converter.refreshNamedElement(Stereotype.class, PivotPackage.Literals.STEREOTYPE, (org.eclipse.uml2.uml.NamedElement)umlStereotype);
        this.copyClass(pivotElement, (org.eclipse.uml2.uml.Class)umlStereotype);
        return pivotElement;
    }

    public Transition caseTransition(org.eclipse.uml2.uml.Transition umlTransition) {
        assert (umlTransition != null);
        Transition pivotElement = this.converter.refreshNamedElement(Transition.class, PivotPackage.Literals.TRANSITION, (org.eclipse.uml2.uml.NamedElement)umlTransition);
        this.copyNamespace(pivotElement, (org.eclipse.uml2.uml.Namespace)umlTransition, null);
        this.converter.queueReference((EObject)umlTransition);
        return pivotElement;
    }

    public Object caseValueSpecification(ValueSpecification umlValueSpecification) {
        assert (umlValueSpecification != null);
        OpaqueExpression pivotElement = this.converter.refreshNamedElement(OpaqueExpression.class, PivotPackage.Literals.OPAQUE_EXPRESSION, (org.eclipse.uml2.uml.NamedElement)umlValueSpecification);
        pivotElement.getBody().clear();
        pivotElement.getLanguage().clear();
        String umlBody = "<<Unsupported " + umlValueSpecification.getClass().getSimpleName() + ">>";
        pivotElement.getBody().add(umlBody);
        this.copyNamedElement(pivotElement, (org.eclipse.uml2.uml.NamedElement)umlValueSpecification);
        return pivotElement;
    }

    protected void copyAnnotatedElement(@NonNull NamedElement pivotElement, @NonNull EModelElement umlElement, @Nullable List<EAnnotation> excludedAnnotations) {
        List<Annotation> pivotAnnotations = pivotElement.getOwnedAnnotation();
        for (EAnnotation eAnnotation : umlElement.getEAnnotations()) {
            Annotation pivotAnnotation;
            if (excludedAnnotations != null && excludedAnnotations.contains(eAnnotation) || (pivotAnnotation = (Annotation)this.doSwitch((EObject)eAnnotation)) == null) continue;
            pivotAnnotations.add(pivotAnnotation);
        }
    }

    protected void copyClassOrInterface(@NonNull Class pivotElement, @NonNull Classifier umlClassifier) {
        Object object;
        this.copyClassifier(pivotElement, umlClassifier);
        pivotElement.setIsAbstract(umlClassifier.isAbstract());
        String instanceClassName = null;
        org.eclipse.uml2.uml.Stereotype ecoreStereotype = umlClassifier.getAppliedStereotype("Ecore::EClass");
        if (ecoreStereotype != null && (object = umlClassifier.getValue(ecoreStereotype, "instanceClassName")) instanceof String) {
            instanceClassName = (String)object;
        }
        pivotElement.setInstanceClassName(instanceClassName);
        this.doSwitchAll((Collection)pivotElement.getOwnedOperation(), (List)umlClassifier.getOperations(), null);
        EList umlAttributes = umlClassifier.getAttributes();
        this.converter.addProperties((List<org.eclipse.uml2.uml.Property>)umlAttributes, new AbstractConversion.Predicate<org.eclipse.uml2.uml.Property>(){

            @Override
            public boolean filter(@NonNull org.eclipse.uml2.uml.Property element) {
                if (element.getAssociation() == null) {
                    UML2PivotDeclarationSwitch.this.doSwitch((EObject)element);
                }
                return element.getAssociation() == null;
            }
        });
        this.converter.queueReference((EObject)umlClassifier);
    }

    protected void copyClass(@NonNull Class pivotElement, @NonNull org.eclipse.uml2.uml.Class umlClass) {
        pivotElement.setIsInterface(false);
        this.copyClassOrInterface(pivotElement, (Classifier)umlClass);
        for (Classifier umlType : umlClass.getNestedClassifiers()) {
            Type type = (Type)this.doSwitch((EObject)umlType);
        }
        this.doSwitchAll((Collection)pivotElement.getOwnedBehavior(), (List)umlClass.getOwnedBehaviors(), null);
    }

    protected void copyClassifier(@NonNull Class pivotElement, @NonNull Classifier umlClassifier) {
        EList invariants = umlClassifier.getOwnedRules();
        this.doSwitchAll((Collection)pivotElement.getOwnedInvariant(), (List)invariants, null);
        this.copyNamespace(pivotElement, (org.eclipse.uml2.uml.Namespace)umlClassifier, (List<org.eclipse.uml2.uml.Constraint>)invariants);
        this.copyTemplateSignature(pivotElement, umlClassifier.getOwnedTemplateSignature());
    }

    protected void copyComments(@NonNull Element pivotElement, @NonNull org.eclipse.uml2.uml.Element umlElement) {
        this.doSwitchAll((Collection)pivotElement.getOwnedComment(), (List)umlElement.getOwnedComments(), null);
    }

    protected void copyConstraints(@NonNull Namespace pivotElement, @NonNull org.eclipse.uml2.uml.Namespace umlNamespace, @Nullable List<org.eclipse.uml2.uml.Constraint> exclusions) {
        Object ownedRules = umlNamespace.getOwnedRules();
        if (exclusions != null && exclusions.size() > 0) {
            ownedRules = new ArrayList(ownedRules);
            ownedRules.removeAll(exclusions);
        }
        this.doSwitchAll((Collection)pivotElement.getOwnedRule(), (List)ownedRules, null);
    }

    protected void copyDataTypeOrEnum(@NonNull DataType pivotElement, @NonNull org.eclipse.uml2.uml.DataType umlDataType) {
        Object object;
        this.copyClassifier(pivotElement, (Classifier)umlDataType);
        String instanceClassName = null;
        org.eclipse.uml2.uml.Stereotype ecoreStereotype = umlDataType.getAppliedStereotype("Ecore::EDataType");
        if (ecoreStereotype != null && (object = umlDataType.getValue(ecoreStereotype, "instanceClassName")) instanceof String) {
            instanceClassName = (String)object;
        }
        pivotElement.setInstanceClassName(instanceClassName);
    }

    protected void copyModelElement(@NonNull Element pivotElement, @NonNull org.eclipse.uml2.uml.Element umlElement) {
        this.converter.setOriginalMapping(pivotElement, (EObject)umlElement);
    }

    protected void copyNamedElement(@NonNull NamedElement pivotElement, @NonNull org.eclipse.uml2.uml.NamedElement umlNamedElement) {
        this.copyModelElement(pivotElement, (org.eclipse.uml2.uml.Element)umlNamedElement);
        String name = umlNamedElement.getName();
        pivotElement.setName(name);
        this.copyAnnotatedElement(pivotElement, (EModelElement)umlNamedElement, null);
        this.copyComments(pivotElement, (org.eclipse.uml2.uml.Element)umlNamedElement);
    }

    protected void copyNamespace(@NonNull Namespace pivotElement, @NonNull org.eclipse.uml2.uml.Namespace umlNamespace, @Nullable List<org.eclipse.uml2.uml.Constraint> exclusions) {
        this.copyNamedElement(pivotElement, (org.eclipse.uml2.uml.NamedElement)umlNamespace);
        this.copyConstraints(pivotElement, umlNamespace, exclusions);
    }

    protected void copyPackage(@NonNull Package pivotElement, @NonNull org.eclipse.uml2.uml.Package umlPackage) {
        Object object;
        Object object2;
        this.copyNamespace(pivotElement, (org.eclipse.uml2.uml.Namespace)umlPackage, null);
        String nsPrefix = null;
        org.eclipse.uml2.uml.Stereotype ecoreStereotype = umlPackage.getAppliedStereotype("Ecore::EPackage");
        if (ecoreStereotype != null && (object2 = umlPackage.getValue(ecoreStereotype, "nsPrefix")) instanceof String) {
            nsPrefix = (String)object2;
        }
        pivotElement.setNsPrefix(nsPrefix);
        String nsURI = umlPackage.getURI();
        if (nsURI == null && ecoreStereotype != null && (object = umlPackage.getValue(ecoreStereotype, "nsURI")) instanceof String) {
            nsPrefix = (String)object;
        }
        pivotElement.setNsURI(nsURI);
        this.doSwitchAll((Collection)pivotElement.getNestedPackage(), (List)umlPackage.getNestedPackages(), null);
        this.doSwitchAll((Collection)pivotElement.getOwnedType(), (List)umlPackage.getOwnedTypes(), (AbstractConversion.Predicate)new AbstractConversion.Predicate<org.eclipse.uml2.uml.Type>(){

            @Override
            public boolean filter(@NonNull org.eclipse.uml2.uml.Type element) {
                return !(element instanceof Association);
            }
        });
        for (org.eclipse.uml2.uml.Type type : umlPackage.getOwnedTypes()) {
            if (!(type instanceof Association)) continue;
            this.doSwitch((EObject)type);
        }
        EList importedPackages = umlPackage.getImportedPackages();
        if (!importedPackages.isEmpty()) {
            this.converter.addImportedPackages((List<? extends org.eclipse.uml2.uml.Package>)importedPackages);
            this.converter.queueReference((EObject)umlPackage);
        } else {
            pivotElement.getImportedPackage().clear();
        }
    }

    protected void copyProperty(@NonNull Property pivotElement, @NonNull org.eclipse.uml2.uml.Property umlProperty, List<EAnnotation> excludedAnnotations) {
        this.copyTypedMultiplicityElement(pivotElement, (TypedElement)umlProperty, excludedAnnotations);
        pivotElement.setIsReadOnly(umlProperty.isReadOnly());
        pivotElement.setIsDerived(umlProperty.isDerived());
    }

    protected void copyState(@NonNull State pivotElement, @NonNull org.eclipse.uml2.uml.State umlState) {
        this.copyNamespace(pivotElement, (org.eclipse.uml2.uml.Namespace)umlState, null);
        this.doSwitchAll((Collection)pivotElement.getRegion(), (List)umlState.getRegions(), null);
    }

    protected void copyTemplateSignature(TemplateableElement pivotElement, org.eclipse.uml2.uml.TemplateSignature umlTemplateSignature) {
        EList umlTemplateParameters;
        if (umlTemplateSignature != null && !(umlTemplateParameters = umlTemplateSignature.getOwnedParameters()).isEmpty()) {
            TemplateSignature pivotTemplateSignature = PivotFactory.eINSTANCE.createTemplateSignature();
            pivotElement.setOwnedTemplateSignature(pivotTemplateSignature);
            this.doSwitchAll((Collection)pivotTemplateSignature.getOwnedParameter(), (List)umlTemplateParameters, null);
        }
    }

    protected void copyTypedMultiplicityElement(@NonNull TypedMultiplicityElement pivotElement, @NonNull TypedElement umlTypedElement, List<EAnnotation> excludedAnnotations) {
        this.copyNamedElement(pivotElement, (org.eclipse.uml2.uml.NamedElement)umlTypedElement);
        int lower = ((MultiplicityElement)umlTypedElement).getLower();
        int upper = ((MultiplicityElement)umlTypedElement).getUpper();
        pivotElement.setIsRequired(upper == 1 && lower == 1);
        org.eclipse.uml2.uml.Type umlType = umlTypedElement.getType();
        if (umlType != null) {
            this.converter.queueReference((EObject)umlTypedElement);
            Resource umlResource = umlType.eResource();
            if (umlResource != null) {
                this.converter.addImportedResource(umlResource);
            }
        }
    }

    public Element defaultCase(EObject umlObject) {
        DynamicElement pivotElement;
        if (umlObject instanceof org.eclipse.uml2.uml.Type) {
            pivotElement = this.converter.refreshElement(DynamicType.class, PivotPackage.Literals.DYNAMIC_TYPE, umlObject);
            ((DynamicType)pivotElement).setName(((org.eclipse.uml2.uml.Type)umlObject).getName());
        } else if (umlObject instanceof org.eclipse.uml2.uml.Element) {
            pivotElement = this.converter.refreshElement(DynamicElement.class, PivotPackage.Literals.DYNAMIC_ELEMENT, umlObject);
        } else {
            this.converter.error("Unsupported " + umlObject.eClass().getName() + " for UML2PivotDeclarationSwitch");
            return null;
        }
        EClass umlMetaClass = umlObject.eClass();
        Type metaType = this.metaModelManager.getPivotOfEcore(Type.class, (EObject)umlMetaClass);
        pivotElement.setMetaType(metaType);
        return pivotElement;
    }

    public Object doInPackageSwitch(@NonNull EObject eObject) {
        int classifierID = eObject.eClass().getClassifierID();
        return this.doSwitch(classifierID, eObject);
    }

    public Object doSwitch(EObject eObject) {
        EClass eClass = eObject.eClass();
        EPackage ePackage = eClass.getEPackage();
        if (ePackage == UMLPackage.eINSTANCE) {
            return this.doInPackageSwitch(eObject);
        }
        if (ePackage == EcorePackage.eINSTANCE) {
            return this.ecoreSwitch.doInPackageSwitch(eObject);
        }
        this.converter.addStereotypeApplication(eObject);
        return null;
    }

    public <T extends Element, V extends EObject> void doSwitchAll(Collection<T> pivotObjects, List<V> eObjects, @Nullable AbstractConversion.Predicate<V> predicate) {
        assert (pivotObjects != null);
        assert (eObjects != null);
        eObjects.size();
        for (EObject eObject : eObjects) {
            Element pivotObject;
            if (eObject == null || predicate != null && !predicate.filter(eObject) || (pivotObject = (Element)this.doSwitch(eObject)) == null) continue;
            pivotObjects.add(pivotObject);
        }
    }

    public <T extends Element> void doSwitchAll(@NonNull List<? extends EObject> eObjects) {
        for (EObject eObject : eObjects) {
            this.doSwitch(eObject);
        }
    }
}

