/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.util;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.OCLDebugOptions;
import org.eclipse.ocl.examples.pivot.PivotStandaloneSetup;
import org.eclipse.ocl.examples.pivot.library.StandardLibraryRegistryReader;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PivotPlugin
extends EMFPlugin {
    @NonNull
    public static final String PLUGIN_ID = "org.eclipse.ocl.examples.pivot";
    @NonNull
    public static final String EMPTY_STRING = "";
    @NonNull
    private static final String PREFIX_THROWING = "THROWN ";
    @NonNull
    private static final String SEPARATOR_SPACE = " ";
    @NonNull
    private static final String PARENTHESIS_OPEN = "(";
    @NonNull
    private static final String PARENTHESIS_CLOSE = ")";
    @NonNull
    private static final String SEPARATOR_METHOD = "#";
    @NonNull
    private static final String PREFIX_CATCHING = "CAUGHT ";
    @NonNull
    public static final String STANDARD_LIBRARY_PPID = "standard_library";
    @NonNull
    public static final PivotPlugin INSTANCE = new PivotPlugin();
    private static Implementation plugin;
    private static boolean traceAll;

    static {
        traceAll = Boolean.getBoolean("org.eclipse.ocl.debug");
    }

    public PivotPlugin() {
        super(new ResourceLocator[0]);
    }

    public static String getPluginId() {
        return PivotPlugin.getPlugin() != null ? PivotPlugin.getPlugin().getBundle().getSymbolicName() : PLUGIN_ID;
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static Resource.Factory getPivotResourceFactory() {
        return new ResourceFactoryImpl(){

            public Resource createResource(URI uri) {
                return new ResourceImpl(uri){

                    public EObject getEObject(String uriFragment) {
                        return super.getEObject(URI.decode((String)uriFragment));
                    }
                };
            }
        };
    }

    public static void catching(Class<?> clazz, String methodName, Throwable throwable) {
        if (PivotPlugin.shouldTrace(OCLDebugOptions.EXCEPTIONS_CATCHING)) {
            PivotPlugin.trace(PREFIX_CATCHING + throwable.getMessage() + SEPARATOR_SPACE + PARENTHESIS_OPEN + clazz.getName() + SEPARATOR_METHOD + methodName + PARENTHESIS_CLOSE);
            throwable.printStackTrace(System.err);
        }
    }

    public static void throwing(Class<?> clazz, String methodName, Throwable throwable) {
        if (PivotPlugin.shouldTrace(OCLDebugOptions.EXCEPTIONS_THROWING)) {
            PivotPlugin.trace(PREFIX_THROWING + throwable.getMessage() + SEPARATOR_SPACE + PARENTHESIS_OPEN + clazz.getName() + SEPARATOR_METHOD + methodName + PARENTHESIS_CLOSE);
            throwable.printStackTrace(System.err);
        }
    }

    public static boolean shouldTrace(String option) {
        if (PivotPlugin.getPlugin() != null) {
            if (PivotPlugin.getPlugin().isDebugging()) {
                return Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)option));
            }
            return false;
        }
        return traceAll || Boolean.getBoolean(option);
    }

    public static void trace(String message) {
        System.out.println("[OCL] " + message);
    }

    public static void error(int code, String message) {
        PivotPlugin.error(code, message, null);
    }

    public static void error(int code, String message, Throwable throwable) {
        PivotPlugin.log(4, code, message, throwable);
    }

    public static void info(String message) {
        PivotPlugin.info(0, message);
    }

    public static void info(int code, String message) {
        PivotPlugin.info(code, message, null);
    }

    public static void info(int code, String message, Throwable throwable) {
        PivotPlugin.log(1, code, message, throwable);
    }

    public static void warning(int code, String message) {
        PivotPlugin.warning(code, message, null);
    }

    public static void warning(int code, String message, Throwable throwable) {
        PivotPlugin.log(2, code, message, throwable);
    }

    public static void log(int severity, int code, String message, Throwable throwable) {
        String msg = message == null ? EMPTY_STRING : message;
        try {
            if (PivotPlugin.getPlugin() != null) {
                PivotPlugin.getPlugin().log(new Status(severity, PivotPlugin.getPluginId(), code, msg, throwable));
            } else if (PivotPlugin.shouldTrace(OCLDebugOptions.DEBUG)) {
                switch (code) {
                    case 2: {
                        System.err.print("WARNING ");
                        break;
                    }
                    case 4: 
                    case 8: {
                        System.err.print("ERROR ");
                        break;
                    }
                    default: {
                        return;
                    }
                }
                System.err.print(code);
                System.err.print(": ");
                System.err.println(message);
                if (throwable != null) {
                    throwable.printStackTrace(System.err);
                }
            }
        }
        catch (IllegalArgumentException iae) {
            PivotPlugin.catching(PivotPlugin.class, "log", iae);
        }
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            new StandardLibraryRegistryReader().readRegistry();
            PivotStandaloneSetup.doSetup();
        }
    }
}

